/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.browser;

import com.cosylab.cdb.browser.Browser;
import com.cosylab.cdb.browser.CDBDialog;
import com.cosylab.cdb.browser.CDBLogic;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

class CDBMenu
extends JMenuBar
implements ActionListener {
    private JMenuItem exit;
    private JMenuItem clearCache;
    private JMenuItem saveXML;
    private JMenuItem addNode;
    private JMenuItem removeNode;

    CDBMenu() {
        JMenu jMenu = new JMenu("File ");
        jMenu.setMnemonic(70);
        this.saveXML = new JMenuItem("Save XML file");
        this.saveXML.addActionListener(this);
        jMenu.add(this.saveXML);
        this.exit = new JMenuItem("Exit");
        this.exit.addActionListener(this);
        jMenu.add(this.exit);
        JMenu jMenu2 = new JMenu("Administration");
        jMenu2.setMnemonic(65);
        this.clearCache = new JMenuItem("Clear Cache");
        this.clearCache.addActionListener(this);
        jMenu2.add(this.clearCache);
        JMenu jMenu3 = new JMenu("Edit");
        jMenu3.setMnemonic(69);
        this.addNode = new JMenuItem("Add node");
        this.addNode.addActionListener(this);
        jMenu3.add(this.addNode);
        this.removeNode = new JMenuItem("Remove node");
        this.removeNode.addActionListener(this);
        jMenu3.add(this.removeNode);
        this.add(jMenu);
        this.add(jMenu3);
        this.add(jMenu2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addNode) {
            CDBLogic.addNode();
        }
        if (actionEvent.getSource() == this.removeNode) {
            CDBLogic.deleteNode();
        }
        if (actionEvent.getSource() == this.exit) {
            if (Browser.getInstance().buttonsEnabled()) {
                String string = "Warning: Node has been modified.";
                String string2 = "Please save or reset changes before closing the Browser.";
                CDBDialog cDBDialog = new CDBDialog(Browser.getInstance(), string, string2);
                return;
            }
            System.exit(0);
        }
        if (actionEvent.getSource() == this.saveXML) {
            Serializable serializable;
            String string;
            Object object;
            if (Browser.getInstance().buttonsEnabled() && CDBLogic.isXMLTabSelected()) {
                object = "Warning: XML string has been modified.";
                string = "It is raccomanded to validate (save) or reset it before saving it.";
                serializable = new CDBDialog(Browser.getInstance(), (String)object, string);
            }
            if (CDBLogic.isXMLTabSelected()) {
                Browser.getInstance().display("MESSAGE: Trying to save XML String... ", true);
                object = new JFileChooser();
                int n = ((JFileChooser)object).showSaveDialog((Component)object);
                switch (n) {
                    case 1: {
                        Browser.getInstance().display("saving interrupted.\t(Location " + Browser.getInstance().getPath() + ").", false);
                        break;
                    }
                    case 0: {
                        serializable = ((JFileChooser)object).getSelectedFile();
                        try {
                            CDBLogic.selectedXMLArea.write(new FileWriter((File)serializable));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        Browser.getInstance().display("XML String saved successfully to file: " + ((File)serializable).getAbsolutePath() + ".\t(Location: " + Browser.getInstance().getPath() + ").", false);
                        break;
                    }
                    case -1: {
                        Browser.getInstance().display("ERROR occured while trying to save XML string. \t(Location: " + Browser.getInstance().getPath() + ").", false);
                    }
                }
            } else {
                object = "Warning: Trying to save XML String.";
                string = "To save XML String you have to select a XML Tab.";
                serializable = new CDBDialog(Browser.getInstance(), (String)object, string);
            }
        }
        if (actionEvent.getSource() == this.clearCache) {
            CDBLogic.clearCache();
        }
    }
}

