/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.browser;

import com.cosylab.cdb.browser.CDBDialog;
import com.cosylab.cdb.browser.CDBLogic;
import com.cosylab.cdb.browser.CDBMenu;
import com.cosylab.cdb.browser.CDBTable;
import com.cosylab.cdb.browser.CDBTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;

public class Browser
extends JFrame
implements ActionListener {
    private static Browser instance = null;
    private static String strIOR = null;
    private JTextArea messageTextArea;
    private JSplitPane splitPane;
    private final int dividerLocation = 240;
    private JTextField currentLocation;
    private final JButton saveChanges = new JButton(" Save Changes to XML record ");
    private final JButton resetData = new JButton(" Reset Data ");
    private JButton refreshTree = new JButton("   Refrest CDB Tree   ");
    private final String titleCol1 = "ATTRIBUTE NAME";
    private final String titleCol2 = "ATTRIBUTE VALUE";

    Browser() {
        super("Configuration Database Browser");
        if (this.buttonsEnabled()) {
            this.setDefaultCloseOperation(0);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (Browser.this.buttonsEnabled()) {
                    String string = "Warning: Node has been modified.";
                    String string2 = "Please save or reset changes before closing the Browser.";
                    CDBDialog cDBDialog = new CDBDialog(Browser.getInstance(), string, string2);
                } else {
                    System.exit(0);
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }
        });
    }

    public static Browser getInstance() {
        if (instance == null) {
            instance = new Browser();
        }
        return instance;
    }

    public void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)jPanel, "Center");
        this.messageTextArea = new JTextArea(10, 20);
        this.messageTextArea.setEditable(false);
        jPanel.add((Component)new JScrollPane(this.messageTextArea), "South");
        this.splitPane = new JSplitPane(1, true);
        this.saveChanges.setEnabled(false);
        this.resetData.setEnabled(false);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBackground(Color.LIGHT_GRAY);
        jTextArea.setEditable(false);
        this.setRightComp(jTextArea, false);
        this.setLeftComp();
        jPanel.add((Component)this.splitPane, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.refreshTree.addActionListener(this);
        JLabel jLabel = new JLabel("CURRENT LOCATION:   ", 4);
        this.currentLocation = new JTextField(40);
        this.currentLocation.setBackground(Color.WHITE);
        this.currentLocation.setEditable(false);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.add(this.refreshTree);
        jPanel3.add(jLabel);
        jPanel2.add(jPanel3);
        jPanel2.add(this.currentLocation);
        jPanel.add((Component)jPanel2, "North");
    }

    public void createTabbedPane(LinkedHashMap linkedHashMap, String string) {
        JComponent jComponent;
        JTabbedPane jTabbedPane = new JTabbedPane();
        String[] stringArray = new String[]{"ATTRIBUTE NAME", "ATTRIBUTE VALUE"};
        Object[][] objectArray = CDBLogic.getData(linkedHashMap);
        if (objectArray != null) {
            jComponent = new CDBTable(objectArray, stringArray);
            CDBTableModel cDBTableModel = new CDBTableModel(objectArray, stringArray);
            ((JTable)jComponent).setModel(cDBTableModel);
            jComponent.setBackground(Color.LIGHT_GRAY);
            ((JTable)jComponent).setSelectionMode(0);
            CDBLogic.tableModels.put(CDBLogic.getKey(), cDBTableModel);
            CDBLogic.tables.put(CDBLogic.getKey(), jComponent);
            jTabbedPane.addTab(" Table View ", new JScrollPane(jComponent));
            CDBLogic.selectedTable = (CDBTable)jComponent;
            CDBLogic.selectedTableModel = cDBTableModel;
        } else {
            CDBLogic.selectedTable = null;
            CDBLogic.selectedTableModel = null;
            CDBLogic.tableModels.put(CDBLogic.getKey(), null);
            CDBLogic.tables.put(CDBLogic.getKey(), null);
            jTabbedPane.addTab(" Table View ", null);
            jTabbedPane.setEnabledAt(0, false);
        }
        if (string != null) {
            jComponent = new JTextArea(string);
            CDBLogic.addListener((JTextArea)jComponent);
            ((JTextComponent)jComponent).setEditable(true);
            jComponent.setBackground(Color.LIGHT_GRAY);
            ((JTextArea)jComponent).setLineWrap(true);
            ((JTextArea)jComponent).setWrapStyleWord(true);
            CDBLogic.xmls.put(CDBLogic.getKey(), jComponent);
            jTabbedPane.addTab(" XML View ", jComponent);
            if (!jTabbedPane.isEnabledAt(0)) {
                jTabbedPane.setSelectedIndex(1);
            }
            CDBLogic.selectedXMLArea = jComponent;
        } else {
            CDBLogic.xmls.put(CDBLogic.getKey(), null);
            jTabbedPane.addTab(" XML View ", null);
            jTabbedPane.setEnabledAt(1, false);
            CDBLogic.selectedXMLArea = null;
        }
        CDBLogic.selectedTabbedPane = jTabbedPane;
        CDBLogic.tabbedPanes.put(CDBLogic.getKey(), jTabbedPane);
        this.setRightComp(jTabbedPane, true);
    }

    public void setRightComp(JComponent jComponent, boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jComponent, "Center");
        if (bl) {
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            this.saveChanges.setEnabled(false);
            this.resetData.setEnabled(false);
            this.saveChanges.addActionListener(this);
            this.resetData.addActionListener(this);
            jPanel2.add(this.saveChanges);
            jPanel2.add(this.resetData);
            jPanel.add((Component)jPanel2, "North");
        }
        this.splitPane.setRightComponent(new JScrollPane(jPanel));
        this.splitPane.setDividerLocation(240);
    }

    public void setLeftComp() {
        JTree jTree = CDBLogic.setUpCDBTree(strIOR);
        this.splitPane.setLeftComponent(new JScrollPane(jTree));
        this.splitPane.setDividerLocation(240);
    }

    public void display(String string, boolean bl) {
        if (bl) {
            this.messageTextArea.append("\n" + string);
        } else {
            this.messageTextArea.append(" " + string);
        }
    }

    public void setPath(String string) {
        this.currentLocation.setText(" " + string);
    }

    public String getPath() {
        return this.currentLocation.getText();
    }

    public void enableButtons(boolean bl) {
        if (bl) {
            this.saveChanges.setEnabled(true);
            this.resetData.setEnabled(true);
        } else {
            this.saveChanges.setEnabled(false);
            this.resetData.setEnabled(false);
        }
    }

    public boolean buttonsEnabled() {
        return this.saveChanges.isEnabled() && this.resetData.isEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.refreshTree) {
            if (this.buttonsEnabled()) {
                String string = "WARNING: Not able to refresh CDB Tree.";
                String string2 = "Please save or reset changes made to node " + this.getPath() + ".";
                CDBDialog cDBDialog = new CDBDialog(this, string, string2);
                return;
            }
            this.messageTextArea.setText("\nRefreshing CDB Tree... ");
            CDBLogic.clearHashMaps();
            this.setPath("");
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBackground(Color.LIGHT_GRAY);
            jTextArea.setEditable(false);
            this.setRightComp(jTextArea, false);
            this.setLeftComp();
            this.display("done.", false);
        }
        if (actionEvent.getSource() == this.resetData) {
            if (CDBLogic.isXMLTabSelected()) {
                CDBLogic.resetXMLString();
            } else {
                CDBLogic.selectedTable.editCellAt(0, 0);
                CDBLogic.resetTable();
            }
        }
        if (actionEvent.getSource() == this.saveChanges) {
            if (CDBLogic.isXMLTabSelected()) {
                CDBLogic.saveXMLString(false);
            } else {
                CDBLogic.selectedTable.editCellAt(0, 0);
                CDBLogic.saveTable();
            }
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-d") || i >= stringArray.length - 1) continue;
            strIOR = stringArray[++i];
        }
        instance = Browser.getInstance();
        instance.setJMenuBar(new CDBMenu());
        instance.createGUI();
        instance.setBounds(50, 50, 850, 650);
        instance.setVisible(true);
    }
}

