/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart.demo;

import com.cosylab.gui.components.r2.chart.AbstractDataModel;
import com.cosylab.gui.components.r2.chart.Point;
import com.cosylab.gui.components.r2.chart.PointIterator;

public class RandomTrendDataModel
extends AbstractDataModel {
    private int pointsPerUpdate = 1;
    private double changePerPoint = 1.0;
    private int index = 0;
    private double startValue = 1.0;
    private double startPosition = 0.0;
    private double positionAdvance = 0.1;
    private double valueRange = 5.0;

    public RandomTrendDataModel() {
    }

    public RandomTrendDataModel(double d, int n, double d2, double d3, double d4, double d5) {
        this.changePerPoint = d;
        this.pointsPerUpdate = n;
        this.positionAdvance = d2;
        this.startPosition = d3;
        this.startValue = d4;
        this.valueRange = d5;
        this.point.x = d3;
        this.point.y = d4;
        this.pointCount = n;
    }

    public double getChangePerPoint() {
        return this.changePerPoint;
    }

    public PointIterator getPointIterator() {
        this.index = 0;
        return this;
    }

    public int getPointsPerUpdate() {
        return this.pointsPerUpdate;
    }

    public double getPositionAdvance() {
        return this.positionAdvance;
    }

    public double getStartPosition() {
        return this.startPosition;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public double getValueRange() {
        return this.valueRange;
    }

    public boolean hasNext() {
        return this.index < this.pointsPerUpdate;
    }

    public Point next() {
        this.point.x += this.positionAdvance;
        double d = this.changePerPoint * (Math.random() - 0.5) * 2.0;
        double d2 = this.point.y + d;
        this.point.y = d2 > this.startValue + this.valueRange ? (this.point.y -= Math.abs(d)) : (d2 < this.startValue - this.valueRange ? (this.point.y += Math.abs(d)) : d2);
        ++this.index;
        return this.point;
    }

    public void setChangePerPoint(double d) {
        this.changePerPoint = d;
    }

    public void setPointsPerUpdate(int n) {
        this.pointCount = this.pointsPerUpdate = n;
    }

    public void setPositionAdvance(double d) {
        this.positionAdvance = d;
    }

    public void setStartPosition(double d) {
        this.point.x = this.startPosition = d;
    }

    public void setStartValue(double d) {
        this.point.y = this.startValue = d;
    }

    public void setValueRange(double d) {
        this.valueRange = d;
    }
}

