/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartProperties;
import com.cosylab.gui.components.r2.chart.DefaultPointTransformer;
import com.cosylab.gui.components.r2.chart.Point;
import com.cosylab.gui.components.r2.chart.PointIterator;

public class TrendPointTransformer
extends DefaultPointTransformer {
    private double leftover = 0.0;

    public TrendPointTransformer() {
        this.updateTransformation();
    }

    public void clearLast() {
        this.lastPoint = null;
    }

    public void transform(PointIterator pointIterator) {
        int n;
        int n2;
        if (!pointIterator.hasNext()) {
            return;
        }
        int n3 = this.chartRectangle.x;
        int n4 = this.chartRectangle.y;
        Point point = null;
        if (this.lastPoint != null) {
            point = this.lastPoint;
            n2 = n3 + (int)Math.rint((point.x - this.x0 + this.leftover) * this.x1);
            n = n4 + this.chartRectangle.height - 1 - (int)Math.rint((point.y - this.y0) * this.y1);
            if (Double.isInfinite(n)) {
                n = this.chartRectangle.height + 1;
                System.out.println("Autocorrect: (" + n2 + ",Infinite) -> (" + n2 + "," + n + ")");
            }
            if (Double.isNaN(n)) {
                n = 0;
                System.out.println("Autocorrect: (" + n2 + ",NaN) -> (" + n2 + "," + n + ")");
            }
            this.add(this.points.newPoint(n2, n));
            if (!Double.isInfinite(point.y) && !Double.isNaN(point.y)) {
                this.maxValue.y = point.y;
                this.maxValue.x = point.x;
                this.minValue.y = point.y;
                this.minValue.x = point.x;
            } else {
                this.maxValue.y = Double.MIN_VALUE;
                this.maxValue.x = 0.0;
                this.minValue.y = Double.MAX_VALUE;
                this.minValue.x = 0.0;
            }
        } else {
            this.maxValue.y = Double.MIN_VALUE;
            this.maxValue.x = 0.0;
            this.minValue.y = Double.MAX_VALUE;
            this.minValue.x = 0.0;
        }
        while (pointIterator.hasNext()) {
            point = pointIterator.next();
            n2 = n3 + (int)Math.rint((point.x - this.x0 + this.leftover) * this.x1);
            n = n4 + this.chartRectangle.height - 1 - (int)Math.rint((point.y - this.y0) * this.y1);
            if (Double.isInfinite(n)) {
                n = this.chartRectangle.height + 1;
                System.out.println("Autocorrect: (" + n2 + ",Infinite) -> (" + n2 + "," + n + ")");
            }
            if (Double.isNaN(n)) {
                n = 0;
                System.out.println("Autocorrect: (" + n2 + ",NaN) -> (" + n2 + "," + n + ")");
            }
            this.add(this.points.newPoint(n2, n));
            if (Double.isInfinite(point.y) || Double.isNaN(point.y)) continue;
            if (point.y > this.maxValue.y) {
                this.maxValue.y = point.y;
                this.maxValue.x = point.x;
                continue;
            }
            if (!(point.y < this.minValue.y)) continue;
            this.minValue.y = point.y;
            this.minValue.x = point.x;
        }
        if (this.lastPoint == null) {
            this.lastPoint = (Point)point.clone();
            this.leftover = 0.0;
        }
        this.lastPoint.x = point.x;
        this.lastPoint.y = point.y;
        if (this.xScale.max() < this.lastPoint.x) {
            this.xScale.set(this.lastPoint.x - this.xScale.length(), this.lastPoint.x);
            if (ChartProperties.getChartProperties().isDebugData()) {
                System.out.println("Scale Advance " + this.lastPoint + " -> " + this.last);
            }
        }
    }
}

