/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.BaseChart;
import com.cosylab.gui.components.r2.chart.HistoryTrendChartArea;
import com.cosylab.gui.components.r2.chart.Interval;
import com.cosylab.gui.components.r2.chart.SinusTrendModel;
import com.cosylab.gui.components.r2.chart.TrendChartArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TrendDemo
extends JFrame {
    private BaseChart ivjChart = null;
    private JPanel ivjJFrameContentPane = null;
    private TrendChartArea trend;

    public TrendDemo() {
        this.initialize();
    }

    public TrendDemo(String string) {
        super(string);
    }

    private BaseChart getChart() {
        if (this.ivjChart == null) {
            try {
                this.ivjChart = new BaseChart();
                this.ivjChart.setName("Chart");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjChart;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.getJFrameContentPane().add((Component)this.getChart(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
    }

    private void initialize() {
        try {
            this.trend = new HistoryTrendChartArea();
            this.getChart().setChartArea(this.trend);
            this.getChart().getViewManager().setXScale(new Interval(0.0, 100.0));
            this.getChart().getViewManager().setYScale(new Interval(-1.0, 3.0));
            SinusTrendModel sinusTrendModel = new SinusTrendModel();
            this.trend.addDataModel(sinusTrendModel);
            sinusTrendModel.startAutomaticUpdate();
            this.setName("TrendDemo");
            this.setDefaultCloseOperation(2);
            this.setSize(319, 167);
            this.setContentPane(this.getJFrameContentPane());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public static void main(String[] stringArray) {
        try {
            TrendDemo trendDemo = new TrendDemo();
            trendDemo.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            trendDemo.show();
            Insets insets = trendDemo.getInsets();
            trendDemo.setSize(trendDemo.getWidth() + insets.left + insets.right, trendDemo.getHeight() + insets.top + insets.bottom);
            trendDemo.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }
}

