/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.AbstractDataModel;
import com.cosylab.gui.components.r2.chart.Point;
import com.cosylab.gui.components.r2.chart.PointIterator;
import com.cosylab.gui.components.r2.chart.SinusFunction;

public class SinusTrendModel
extends AbstractDataModel {
    protected int updateRate = 1000;
    protected int valuesPerUpdate = 1;
    protected double speed = 1.0;
    public SinusFunction f = new SinusFunction();
    public Point[] points;
    protected int index = 0;
    private long x = 0L;
    protected boolean ready = true;

    public SinusTrendModel() {
        this.setSpeed(0.1);
        this.setValuesPerUpdate(this.valuesPerUpdate);
        this.f.setAmplitude(2.0);
        this.f.setOffset(0.5);
        this.f.setPhase(0.0);
    }

    public PointIterator getPointIterator() {
        this.index = 0;
        this.updateValues();
        return this;
    }

    public double getSpeed() {
        return this.speed;
    }

    public int getUpdateRate() {
        return this.updateRate;
    }

    public int getValuesPerUpdate() {
        return this.valuesPerUpdate;
    }

    public boolean hasNext() {
        return this.index < this.valuesPerUpdate;
    }

    public Point next() {
        return this.points[this.index++];
    }

    protected synchronized void runIt() {
        System.out.println("Run It");
        try {
            this.wait(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (true) {
            this.updateChartData();
            try {
                this.wait(this.updateRate);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void setSpeed(double d) {
        this.speed = d;
        this.f.setFrequency(this.speed / 1000.0);
    }

    public void setUpdateRate(int n) {
        this.updateRate = n;
    }

    public void setValuesPerUpdate(int n) {
        this.valuesPerUpdate = n;
        this.points = new Point[this.valuesPerUpdate];
        int n2 = 0;
        while (n2 < this.valuesPerUpdate) {
            this.points[n2++] = new Point();
        }
        if (this.ready) {
            this.pointCount = this.valuesPerUpdate;
        }
    }

    public void startAutomaticUpdate() {
        new Thread(){

            public void run() {
                SinusTrendModel.this.runIt();
            }
        }.start();
    }

    protected void updateValues() {
        if (this.x > 1000000000L) {
            this.x = 0L;
        }
        for (int i = 0; i < this.valuesPerUpdate; ++i) {
            this.points[i].x = this.x + (long)((i + 1) * this.updateRate / this.valuesPerUpdate);
            this.points[i].y = this.f.y(this.points[i].x);
            this.points[i].x /= 1000.0;
        }
        this.x += (long)this.updateRate;
        this.pointCount = this.valuesPerUpdate;
    }
}

