/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.AbstractChartAxis;
import com.cosylab.gui.components.r2.chart.ChartXAxis;
import com.cosylab.gui.components.r2.chart.accessories.FormatStringMaker;
import com.cosylab.gui.components.r2.chart.accessories.IntervalNumber;
import com.cosylab.gui.components.r2.chart.accessories.RoundDoubleToDouble;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class ImprovedChartXAxis
extends AbstractChartAxis
implements ChartXAxis {
    private boolean isLogaritmic = false;
    private double xmin;
    private double xminDraw;
    private double xmax;
    private double xmaxDraw;
    private FontMetrics fm;
    private double yOrigin = -1.0;
    private double ymax;
    private double ymin;

    public void drawAxis(Graphics graphics) {
        this.xmin = this.xScale.min();
        this.xmax = this.xScale.max();
        this.ymax = this.yScale.max();
        this.ymin = this.yScale.min();
        if (this.chartSize == null) {
            return;
        }
        if (this.isLogaritmic) {
            if (this.xmin != 0.0) {
                this.drawLogaritmicAxis(graphics);
            } else {
                this.drawLinearAxis(graphics);
            }
        } else {
            this.drawLinearAxis(graphics);
        }
    }

    private void drawLinearAxis(Graphics graphics) {
        if (this.chartSize == null) {
            return;
        }
        double d = this.xScale.min();
        double d2 = this.xScale.max();
        double d3 = d2 - d;
        double d4 = 2.5;
        graphics.setColor(this.lineColor);
        graphics.drawLine(0, this.chartSize.height, this.chartSize.width + this.majorTickLength, this.chartSize.height);
        double d5 = d;
        try {
            d5 = RoundDoubleToDouble.roundUpToDigits(d, d3, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.print(" In com.cosylab.gui.chart.ImprovedChartXAxis.drawAxis() occured exception: " + illegalArgumentException.toString());
        }
        String string = FormatStringMaker.getFormatString(d5);
        this.setFormat(string);
        String string2 = this.format(d);
        String string3 = this.format(d2);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = string2.length() > string3.length() ? fontMetrics.stringWidth(string2) : fontMetrics.stringWidth(string3);
        int n2 = (int)Math.rint((double)this.chartSize.width / ((double)n * d4));
        double d6 = d3 / (double)n2;
        double d7 = IntervalNumber.getRightInterval(d6);
        int n3 = -n / 2;
        double d8 = IntervalNumber.getSubInterval(d6);
        double d9 = IntervalNumber.getSubSubInterval(d6);
        graphics.setColor(this.fontColor);
        this.setFormat(FormatStringMaker.getFormatString(d7));
        string2 = this.format(d);
        string3 = this.format(d2);
        n = string2.length() > string3.length() ? fontMetrics.stringWidth(string2) : fontMetrics.stringWidth(string3);
        n2 = (int)Math.rint((double)this.chartSize.width / ((double)n * d4));
        d6 = d3 / (double)n2;
        d7 = IntervalNumber.getRightInterval(d6);
        n3 = -n / 2;
        d8 = IntervalNumber.getSubInterval(d6);
        d9 = IntervalNumber.getSubSubInterval(d6);
        if (n2 < 2) {
            graphics.drawLine(this.chartSize.width, this.chartSize.height, this.chartSize.width, this.chartSize.height + this.majorTickLength);
            graphics.drawLine(0, this.chartSize.height, 0, this.chartSize.height + this.majorTickLength);
            graphics.drawString(string2, (int)((double)(-n) / 2.0), this.chartSize.height + fontMetrics.getHeight() + this.textMargin.top);
            graphics.drawString(string3, this.chartSize.width - (int)((double)n / 2.0), this.chartSize.height + fontMetrics.getHeight() + this.textMargin.top);
            this.preferedHeight = fontMetrics.getHeight() + this.textMargin.bottom + this.textMargin.top + this.majorTickLength;
            this.preferedWidth = n + this.textMargin.left + this.textMargin.right + this.majorTickLength;
            return;
        }
        try {
            d5 = RoundDoubleToDouble.truncToDigits(d, IntervalNumber.getRoundedInterval(d7), 1);
            d5 = Math.ceil((d - d5) / d7) * d7 + d5;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.print(" In com.cosylab.gui.chart.ImprovedChartXAxis.drawAxis() occured exception: " + illegalArgumentException.toString());
        }
        int n4 = 0;
        while (d5 - (double)n4 * d7 >= d) {
            graphics.drawString(this.format(d5 - (double)n4 * d7), (int)((d5 - d - (double)n4 * d7) / d3 * (double)this.chartSize.width) + n3, this.chartSize.height + fontMetrics.getHeight() + this.textMargin.top);
            ++n4;
        }
        n4 = 1;
        while (d5 + (double)n4 * d7 <= d2) {
            graphics.drawString(this.format(d5 + (double)n4 * d7), (int)((d5 - d + (double)n4 * d7) / d3 * (double)this.chartSize.width) + n3, this.chartSize.height + fontMetrics.getHeight() + this.textMargin.top);
            ++n4;
        }
        graphics.setColor(this.lineColor);
        n4 = 1;
        while (d5 - (double)n4 * d8 >= d) {
            graphics.drawLine((int)((d5 - d - (double)n4 * d8) / d3 * (double)this.chartSize.width), this.chartSize.height, (int)((d5 - d - (double)n4 * d8) / d3 * (double)this.chartSize.width), this.chartSize.height + this.majorTickLength);
            ++n4;
        }
        n4 = 1;
        while (d5 - (double)n4 * d9 >= d) {
            graphics.drawLine((int)((d5 - d - (double)n4 * d9) / d3 * (double)this.chartSize.width), this.chartSize.height, (int)((d5 - d - (double)n4 * d9) / d3 * (double)this.chartSize.width), this.chartSize.height + this.minorTickLength);
            ++n4;
        }
        n4 = 0;
        while (d5 + (double)n4 * d8 <= d2) {
            graphics.drawLine((int)((d5 - d + (double)n4 * d8) / d3 * (double)this.chartSize.width), this.chartSize.height, (int)((d5 - d + (double)n4 * d8) / d3 * (double)this.chartSize.width), this.chartSize.height + this.majorTickLength);
            ++n4;
        }
        n4 = 1;
        while (d5 + (double)n4 * d9 <= d2) {
            graphics.drawLine((int)((d5 - d + (double)n4 * d9) / d3 * (double)this.chartSize.width), this.chartSize.height, (int)((d5 - d + (double)n4 * d9) / d3 * (double)this.chartSize.width), this.chartSize.height + this.minorTickLength);
            ++n4;
        }
        this.preferedHeight = fontMetrics.getHeight() + this.textMargin.bottom + this.textMargin.top + this.majorTickLength;
        this.preferedWidth = n + this.textMargin.left + this.textMargin.right + this.majorTickLength;
    }

    private void drawLogaritmicAxis(Graphics graphics) {
        double d = 1.0;
        double d2 = 1.0;
        graphics.drawLine(0, (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), this.chartSize.width + this.majorTickLength, (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)));
        this.xminDraw = RoundDoubleToDouble.roundUpToTenth(this.xmin);
        this.xmaxDraw = RoundDoubleToDouble.truncToTenth(this.xmax);
        String string = FormatStringMaker.getFormatString(this.xminDraw / 10.0);
        String string2 = FormatStringMaker.getFormatString(this.xmaxDraw);
        this.setFormat(string2);
        String string3 = this.format(this.xmax);
        this.setFormat(string);
        String string4 = this.format(this.xmin);
        this.fm = graphics.getFontMetrics(this.font);
        int n = string4.length() > string3.length() ? this.fm.stringWidth(string4) : this.fm.stringWidth(string3);
        int n2 = (int)Math.rint(this.chartSize.width / (n * 2));
        if (n2 < 2 || Math.log(this.xmax / this.xmin) < 0.7) {
            graphics.drawLine(this.chartSize.width, (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), this.chartSize.width, (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
            graphics.drawLine(0, (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), 0, (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
            graphics.drawString(string4, (int)((double)(-n) / 2.0), this.chartSize.height + this.fm.getHeight() + this.textMargin.top);
            graphics.drawString(string3, this.chartSize.width - (int)((double)n / 2.0), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.fm.getHeight() + this.textMargin.top);
            this.preferedHeight = this.fm.getHeight() + this.textMargin.bottom + this.textMargin.top + this.majorTickLength;
            this.preferedWidth = n + this.textMargin.left + this.textMargin.right + this.majorTickLength;
            return;
        }
        double d3 = d * (double)this.chartSize.width / Math.log(this.xmax / this.xmin);
        double d4 = d2 * d3 / (double)n;
        int n3 = (int)Math.rint(2.0 / d4);
        try {
            if (d3 > 20.0) {
                if (d4 > 4.0) {
                    this.logDraw(-1, -1, graphics);
                } else if (d4 > 2.0) {
                    this.logDraw(-1, 0, graphics);
                } else {
                    this.logDraw(-1, n3, graphics);
                }
            } else if (d3 > 8.0) {
                this.logDraw(0, n3, graphics);
            } else {
                int n4 = (int)Math.ceil(1.0 / d3);
                if (n3 < n4) {
                    n3 = n4;
                }
                this.logDraw(n4, n3, graphics);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.print(illegalArgumentException.toString());
        }
        this.preferedHeight = this.fm.getHeight() + this.textMargin.bottom + this.textMargin.top + this.majorTickLength;
        this.preferedWidth = n + this.textMargin.left + this.textMargin.right + this.majorTickLength;
    }

    public boolean isIsLogaritmic() {
        return this.isLogaritmic;
    }

    private void logDraw(int n, int n2, Graphics graphics) throws IllegalArgumentException {
        block38: {
            int n3;
            int n4;
            double d;
            block37: {
                String string;
                if (!(n == -1 && n2 >= -1 || n == 0 && n2 >= 1 || n >= 1 && n2 >= n)) {
                    throw new IllegalArgumentException("Not possible combination of arguments of logDraw1() method!");
                }
                d = this.xminDraw;
                if (n == -1) {
                    n4 = d <= this.xmax ? 1 : (int)Math.ceil(10.0 * (1.0 - this.xmax / d));
                    while (d * (1.0 - 0.1 * (double)n4) >= this.xmin) {
                        if ((n4 == 3 || n4 == 5 || n4 == 7 || n4 == 8) && n2 == -1) {
                            graphics.drawString(this.format(d * (1.0 - 0.1 * (double)n4)), (int)(Math.log(d * (1.0 - 0.1 * (double)n4) / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width - (double)(this.fm.stringWidth(this.format(d * (1.0 - 0.1 * (double)n4))) / 2)), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.fm.getHeight() + this.textMargin.top);
                            graphics.drawLine((int)(Math.log((1.0 - 0.1 * (double)n4) * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((1.0 - 0.1 * (double)n4) * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
                        } else if ((n4 == 5 || n4 == 8) && n2 == 0) {
                            graphics.drawString(this.format(d * (1.0 - 0.1 * (double)n4)), (int)(Math.log(d * (1.0 - 0.1 * (double)n4) / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width - (double)(this.fm.stringWidth(this.format(d * (1.0 - 0.1 * (double)n4))) / 2)), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.fm.getHeight() + this.textMargin.top);
                            graphics.drawLine((int)(Math.log((1.0 - 0.1 * (double)n4) * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((1.0 - 0.1 * (double)n4) * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
                        } else {
                            graphics.drawLine((int)(Math.log((1.0 - 0.1 * (double)n4) * this.xminDraw / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((1.0 - 0.1 * (double)n4) * this.xminDraw / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.minorTickLength);
                        }
                        ++n4;
                    }
                } else if (n == 0) {
                    n4 = 3;
                    while (d * (1.0 - 0.1 * (double)n4) > this.xmin) {
                        graphics.drawLine((int)(Math.log((1.0 - 0.1 * (double)n4) * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((1.0 - 0.1 * (double)n4) * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.minorTickLength);
                        n4 += 3;
                    }
                }
                if (n == -1) {
                    n4 = 0;
                    while (d < this.xmaxDraw) {
                        if (d <= 1.0) {
                            string = FormatStringMaker.getFormatString(d);
                            this.setFormat(string);
                        }
                        for (n3 = 1; n3 <= 9; ++n3) {
                            if (n3 == 1 && (n2 <= 0 || n4 % n2 == 0) || (n3 == 2 || n3 == 5) && n2 <= 0 || (n3 == 3 || n3 == 7) && n2 == -1) {
                                graphics.drawString(this.format((double)n3 * d), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width - (double)(this.fm.stringWidth(this.format(d)) / 2)), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.fm.getHeight() + this.textMargin.top);
                                graphics.drawLine((int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
                                continue;
                            }
                            if (n3 == 1) {
                                graphics.drawLine((int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
                                continue;
                            }
                            graphics.drawLine((int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.minorTickLength);
                        }
                        d *= 10.0;
                        ++n4;
                    }
                } else if (n == 0) {
                    n4 = 0;
                    while (d < this.xmaxDraw) {
                        if (d <= 1.0) {
                            string = FormatStringMaker.getFormatString(d);
                            this.setFormat(string);
                        }
                        if (n4 % n2 == 0) {
                            graphics.drawString(this.format(d), (int)(Math.log(d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width - (double)(this.fm.stringWidth(this.format(d)) / 2)), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.fm.getHeight() + this.textMargin.top);
                        }
                        graphics.drawLine((int)(Math.log(d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log(d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
                        for (n3 = 4; n3 <= 9; n3 += 3) {
                            graphics.drawLine((int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.minorTickLength);
                        }
                        d *= 10.0;
                        ++n4;
                    }
                } else {
                    n4 = 0;
                    while (d < this.xmaxDraw) {
                        if (d <= 1.0) {
                            string = FormatStringMaker.getFormatString(d);
                            this.setFormat(string);
                        }
                        if (n4 % n2 == 0) {
                            graphics.drawString(this.format(d), (int)(Math.log(d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width - (double)(this.fm.stringWidth(this.format(d)) / 2)), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.fm.getHeight() + this.textMargin.top);
                        }
                        if (n4 % n == 0) {
                            graphics.drawLine((int)(Math.log(d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log(d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
                        }
                        d *= 10.0;
                        ++n4;
                    }
                }
                if (d <= 1.0) {
                    string = FormatStringMaker.getFormatString(d);
                    this.setFormat(string);
                }
                if (n != -1) break block37;
                n3 = 1;
                while ((double)n3 * d <= this.xmax) {
                    if ((n3 == 1 || n3 == 10) && (n2 <= 0 || n4 % n2 == 0) || (n3 == 2 || n3 == 5) && n2 <= 0 || (n3 == 3 || n3 == 7) && n2 == -1) {
                        graphics.drawString(this.format((double)n3 * d), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width - (double)(this.fm.stringWidth(this.format(d)) / 2)), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.fm.getHeight() + this.textMargin.top);
                        graphics.drawLine((int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
                    } else if (n3 == 1 || n3 == 10) {
                        graphics.drawLine((int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
                    } else {
                        graphics.drawLine((int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.minorTickLength);
                    }
                    ++n3;
                }
                break block38;
            }
            if (n != 0) break block38;
            if (n4 % n2 == 0) {
                graphics.drawString(this.format(d), (int)(Math.log(d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width - (double)(this.fm.stringWidth(this.format(d)) / 2)), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.fm.getHeight() + this.textMargin.top);
            }
            n3 = 1;
            while ((double)n3 * d <= this.xmax) {
                if (n3 == 1 || n3 == 10) {
                    graphics.drawLine((int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.majorTickLength);
                } else {
                    graphics.drawLine((int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)), (int)(Math.log((double)n3 * d / this.xmin) / Math.log(this.xmax / this.xmin) * (double)this.chartSize.width), (int)Math.rint((double)this.chartSize.height * (this.ymax - this.yOrigin) / (this.ymax - this.ymin)) + this.minorTickLength);
                }
                n3 += 3;
            }
        }
    }

    public void setIsLogaritmic(boolean bl) {
        this.isLogaritmic = bl;
    }
}

