/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.AbstractDataModel;
import com.cosylab.gui.components.r2.chart.Function;
import com.cosylab.gui.components.r2.chart.Interval;
import com.cosylab.gui.components.r2.chart.PlainChartStyle;
import com.cosylab.gui.components.r2.chart.Point;
import com.cosylab.gui.components.r2.chart.PointIterator;
import java.awt.Color;

public class FunctionDataModel
extends AbstractDataModel {
    private Function function;
    private int index = 0;
    private Interval xScale;
    private Interval yScale;

    public FunctionDataModel() {
        this.chartStyle = new PlainChartStyle(1, Color.black, 0, 0, Color.black);
    }

    public FunctionDataModel(Function function) {
        this();
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getPointCount() {
        return this.function == null ? 0 : (this.pointCount = this.chartService.getChartDisplayablePointCount());
    }

    public PointIterator getPointIterator() {
        this.index = 0;
        this.xScale = this.chartService.getViewManager().getExtractedXScale(this.preferedXScale);
        this.yScale = this.chartService.getViewManager().getExtractedYScale(this.preferedYScale);
        return this;
    }

    public boolean hasNext() {
        return this.index < this.pointCount;
    }

    public Point next() {
        if (this.function == null) {
            return this.point;
        }
        this.point.x = this.xScale.min() + (double)this.index * (this.xScale.max() - this.xScale.min()) / (double)(this.chartService.getChartDisplayablePointCount() - 1);
        this.point.y = this.function.y(this.point.x);
        ++this.index;
        return this.point;
    }

    public void setFunction(Function function) {
        this.function = function;
    }
}

