/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartDataListener;
import com.cosylab.gui.components.r2.chart.ChartDataModel;
import com.cosylab.gui.components.r2.chart.ChartDataService;
import com.cosylab.gui.components.r2.chart.ChartService;
import com.cosylab.gui.components.r2.chart.ChartStyleManager;
import com.cosylab.gui.components.r2.chart.ChartUpdateRequest;
import com.cosylab.gui.components.r2.chart.ChartViewManager;
import com.cosylab.gui.components.r2.chart.DataChange;
import com.cosylab.gui.components.r2.chart.DataManageable;
import com.cosylab.gui.components.r2.chart.PointTransformerModel;

class DefaultDataService
implements ChartService,
ChartDataService {
    public ChartDataModel dataModel;
    public ChartService chartService;
    public PointTransformerModel pointTransformer;

    public DefaultDataService(ChartDataModel chartDataModel, ChartService chartService, PointTransformerModel pointTransformerModel) {
        this.chartService = chartService;
        this.dataModel = chartDataModel;
        this.pointTransformer = pointTransformerModel;
        this.dataModel.setChartService(this);
        this.chartService.getChartStyleManager().getStyleForSerie(this.dataModel);
        this.pointTransformer.setXScale(this.chartService.getViewManager().addUserXScale(chartDataModel.getPreferedXScale()));
        this.pointTransformer.setYScale(this.chartService.getViewManager().addUserYScale(chartDataModel.getPreferedYScale()));
        if (this.dataModel instanceof DataManageable) {
            ((DataManageable)((Object)this.dataModel)).getDataManager().addDataChartListener(new ChartDataListener(){

                public void dataChanged(DataChange dataChange) {
                    DefaultDataService.this.updateChart(dataChange);
                }
            });
        }
    }

    public int getChartDisplayablePointCount() {
        return this.chartService.getChartDisplayablePointCount();
    }

    public ChartService getChartService() {
        return this.chartService;
    }

    public ChartStyleManager getChartStyleManager() {
        return this.chartService.getChartStyleManager();
    }

    public ChartDataModel getDataModel() {
        return this.dataModel;
    }

    public PointTransformerModel getPointTransformer() {
        return this.pointTransformer;
    }

    public ChartViewManager getViewManager() {
        return this.chartService.getViewManager();
    }

    public void prepare() {
    }

    public void setChartService(ChartService chartService) {
        this.chartService.getViewManager().removeUserXScale(this.dataModel.getPreferedXScale());
        this.chartService.getViewManager().removeUserYScale(this.dataModel.getPreferedYScale());
        this.chartService = chartService;
        this.dataModel.setChartService(this);
        this.chartService.getChartStyleManager().getStyleForSerie(this.dataModel);
        this.pointTransformer.setXScale(this.chartService.getViewManager().addUserXScale(this.dataModel.getPreferedXScale()));
        this.pointTransformer.setYScale(this.chartService.getViewManager().addUserYScale(this.dataModel.getPreferedYScale()));
    }

    public int transform() {
        if (this.dataModel.getPointCount() == 0) {
            return 1;
        }
        this.pointTransformer.transform(this.dataModel.getPointIterator());
        return 0;
    }

    public void updateChart(ChartUpdateRequest chartUpdateRequest) {
        this.chartService.updateChart(chartUpdateRequest);
    }

    public void updateChart(DataChange dataChange) {
        switch (dataChange.getCode()) {
            case 0: {
                this.chartService.updateChart(ChartUpdateRequest.RELOAD_ALL);
                break;
            }
            case 1: {
                this.chartService.updateChart(ChartUpdateRequest.UPDATE_ALL);
                break;
            }
            default: {
                this.chartService.updateChart(ChartUpdateRequest.UPDATE_SERIE);
            }
        }
    }
}

