/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.AbstractChartAxis;
import com.cosylab.gui.components.r2.chart.ChartXAxis;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class DefaultChartXAxis
extends AbstractChartAxis
implements ChartXAxis {
    public void drawAxis(Graphics graphics) {
        if (this.chartSize == null) {
            return;
        }
        if (this.xScale.isLogaritmic()) {
            this.drawLogAxis(graphics);
        } else {
            this.drawLinAxis(graphics);
        }
    }

    private void drawLinAxis(Graphics graphics) {
        graphics.setColor(this.lineColor);
        graphics.drawLine(-this.majorTickLength, this.chartSize.height - 1, this.chartSize.width - 1 + this.majorTickLength, this.chartSize.height - 1);
        graphics.drawLine(this.chartSize.width - 1, this.chartSize.height - 1, this.chartSize.width - 1, this.chartSize.height + this.majorTickLength - 2);
        if (this.chartSize.width < 20) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            graphics.drawLine((int)((double)(i + 1) * (double)this.chartSize.width / 10.0), this.chartSize.height - 1, (int)((double)(i + 1) * (double)this.chartSize.width / 10.0), this.chartSize.height - 2 + this.minorTickLength);
        }
        graphics.setColor(this.fontColor);
        graphics.setFont(this.font);
        String string = this.format(this.xScale.min());
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(string);
        graphics.drawString(string, (int)((double)(-n) / 2.0), this.chartSize.height + fontMetrics.getHeight() + this.textMargin.top);
        string = this.format(this.xScale.max());
        int n2 = fontMetrics.stringWidth(string);
        graphics.drawString(this.format(this.xScale.max()), this.chartSize.width - (int)((double)n2 / 2.0), this.chartSize.height + fontMetrics.getHeight() + this.textMargin.top);
        this.preferedHeight = fontMetrics.getHeight() + this.textMargin.bottom + this.textMargin.top + this.majorTickLength;
        this.preferedWidth = (n > n2 ? n : n2) + this.textMargin.left + this.textMargin.right + this.majorTickLength;
    }

    private void drawLogAxis(Graphics graphics) {
        graphics.drawLine(-this.majorTickLength, this.chartSize.height - 1, this.chartSize.width - 1 + this.majorTickLength, this.chartSize.height - 1);
        graphics.drawLine(this.chartSize.width - 1, this.chartSize.height - 1, this.chartSize.width - 1, this.chartSize.height + this.majorTickLength - 2);
        String string = this.format(this.xScale.min());
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(string);
        graphics.drawString(string, (int)((double)(-n) / 2.0) - 3, this.chartSize.height + fontMetrics.getHeight() + this.textMargin.top);
        string = this.format(this.xScale.max());
        int n2 = fontMetrics.stringWidth(string);
        graphics.drawString(this.format(this.xScale.max()), this.chartSize.width - (int)((double)n2 / 2.0) - 3, this.chartSize.height + fontMetrics.getHeight() + this.textMargin.top);
        this.preferedHeight = fontMetrics.getHeight() + this.textMargin.bottom + this.textMargin.top + this.majorTickLength;
        this.preferedWidth = (n > n2 ? n : n2) + this.textMargin.left + this.textMargin.right + this.majorTickLength;
        if (this.chartSize.width < 20) {
            return;
        }
        for (int i = 1; i < 10; ++i) {
            graphics.drawLine((int)(Math.log(i) * (double)this.chartSize.width), this.chartSize.height - 1, (int)(Math.log(i) * (double)this.chartSize.width), this.chartSize.height - 2 + this.minorTickLength);
        }
    }
}

