/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartDataListener;
import com.cosylab.gui.components.r2.chart.DataChange;
import com.cosylab.gui.components.r2.chart.DataManager;
import java.util.ArrayList;

public class DataManagerSupport
implements DataManager {
    private ArrayList list;

    public synchronized void addDataChartListener(ChartDataListener chartDataListener) {
        if (this.list == null) {
            this.list = new ArrayList(10);
        }
        this.list.add(chartDataListener);
    }

    public void fireAllPointsChanged() {
        this.fireDataChanged(DataChange.ALL_POINTS_CHANGED);
    }

    public void fireDataChanged(DataChange dataChange) {
        if (this.list == null) {
            return;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            try {
                ((ChartDataListener)this.list.get(i)).dataChanged(dataChange);
                continue;
            }
            catch (Throwable throwable) {
                System.out.println("Error DataChange event dispatching:");
                throwable.printStackTrace();
            }
        }
    }

    public void firePointsAdded() {
        this.fireDataChanged(DataChange.POINTS_ADDED);
    }

    public void firePointsChanged() {
        this.fireDataChanged(DataChange.POINTS_CHANGED);
    }

    public void firePointsRemoved() {
        this.fireDataChanged(DataChange.POINTS_REMOVED);
    }

    public void fireResetAll() {
        this.fireDataChanged(DataChange.RESET_ALL);
    }

    public synchronized void removeDataChartListener(ChartDataListener chartDataListener) {
        if (this.list != null) {
            this.list.remove(chartDataListener);
        }
    }
}

