/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartStyle;
import com.cosylab.gui.components.r2.chart.IntPointIterator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Chartics {
    private Graphics graphics;
    private BufferedImage image;
    private Color background = Color.white;

    public void drawGraph(IntPointIterator intPointIterator, ChartStyle chartStyle) {
        chartStyle.drawGraph(intPointIterator, this.graphics);
    }

    public Color getBackground() {
        return this.background;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        Graphics graphics = this.graphics = this.image != null ? this.image.getGraphics() : null;
        if (this.background != null && this.image != null) {
            ((Graphics2D)this.graphics).setBackground(this.background);
            this.graphics.setColor(this.background);
            this.graphics.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        }
    }

    public void shift(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.copyArea(n, n2, n3, n4, n5, n6);
        Color color = this.graphics.getColor();
        this.graphics.setColor(this.background);
        if (n5 < 0) {
            this.graphics.fillRect(n + n3 + n5, n2, -n5, n4);
        } else if (n5 > 0) {
            this.graphics.fillRect(n, n2, n5, n4);
        }
        if (n6 < 0) {
            this.graphics.fillRect(n, n2 + n4 + n6, n3, -n6);
        } else if (n6 > 0) {
            this.graphics.fillRect(n, n2, n3, n6);
        }
        this.graphics.setColor(color);
    }
}

