/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import java.util.Properties;

public class ChartProperties {
    private static ChartProperties prop;
    public static final String DEBUG_PERFORMANCE = "cosylab.chart.debug.performance";
    public static final String DEBUG_DATA = "cosylab.chart.debug.data";
    public static final String DEBUG_GRAPHICS = "cosylab.chart.debug.graphics";
    private boolean debugData = false;
    private boolean debugGraphics = false;
    private boolean debugPerformance = false;
    public static final String CHART_RESOURCES = "chart_properties.data";

    private ChartProperties() {
        Properties properties = new Properties();
        try {
            properties.load(ClassLoader.getSystemResourceAsStream(CHART_RESOURCES));
            this.loadProperties(properties);
        }
        catch (Throwable throwable) {
            System.out.println("[BaseChart] Debug chart properties not loaded.");
        }
    }

    private static synchronized void createChartProperties() {
        if (prop == null) {
            prop = new ChartProperties();
        }
    }

    public static ChartProperties getChartProperties() {
        if (prop == null) {
            ChartProperties.createChartProperties();
        }
        return prop;
    }

    public boolean isDebugData() {
        return this.debugData;
    }

    public boolean isDebugGraphics() {
        return this.debugGraphics;
    }

    public boolean isDebugPerformance() {
        return this.debugPerformance;
    }

    public void loadProperties(Properties properties) {
        if (properties.containsKey(DEBUG_DATA)) {
            this.debugData = Boolean.valueOf(properties.getProperty(DEBUG_DATA));
        }
        if (properties.containsKey(DEBUG_GRAPHICS)) {
            this.debugGraphics = Boolean.valueOf(properties.getProperty(DEBUG_GRAPHICS));
        }
        if (properties.containsKey(DEBUG_PERFORMANCE)) {
            this.debugPerformance = Boolean.valueOf(properties.getProperty(DEBUG_PERFORMANCE));
        }
    }

    public void saveProperties(Properties properties) {
        properties.setProperty(DEBUG_DATA, new Boolean(this.debugData).toString());
        properties.setProperty(DEBUG_GRAPHICS, new Boolean(this.debugGraphics).toString());
        properties.setProperty(DEBUG_PERFORMANCE, new Boolean(this.debugPerformance).toString());
    }

    public void setDebugData(boolean bl) {
        this.debugData = bl;
    }

    public void setDebugGraphics(boolean bl) {
        this.debugGraphics = bl;
    }

    public void setDebugPerformance(boolean bl) {
        this.debugPerformance = bl;
    }
}

