/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.BaseChart;
import com.cosylab.gui.components.r2.chart.ChartUpdateRequest;
import com.cosylab.gui.components.r2.chart.Interval;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BaseChartCustomizer
extends JFrame {
    private JButton ivjCancelButton = null;
    private JPanel ivjJFrameContentPane = null;
    private JLabel ivjJLabel1 = null;
    private JLabel ivjJLabel2 = null;
    private JLabel ivjJLabel3 = null;
    private JLabel ivjJLabel4 = null;
    private JLabel ivjMaxValueLabel = null;
    private JTextField ivjMaxXText = null;
    private JTextField ivjMaxYText = null;
    private JLabel ivjMinValueLabel = null;
    private JTextField ivjMinXText = null;
    private JTextField ivjMinYText = null;
    private JButton ivjOKButton = null;
    private BaseChart chart = null;
    private JCheckBox ivjPreferedXCheckBox = null;
    private JCheckBox ivjPreferedYCheckBox = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private DecimalFormat format = new DecimalFormat();

    public BaseChartCustomizer() {
        this.initialize();
    }

    public BaseChartCustomizer(BaseChart baseChart) {
        this();
        this.chart = baseChart;
    }

    private void connEtoM1(ActionEvent actionEvent) {
        try {
            this.getPreferedXCheckBox().setSelected(false);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM2(ActionEvent actionEvent) {
        try {
            this.getPreferedXCheckBox().setSelected(false);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM3(ActionEvent actionEvent) {
        try {
            this.getPreferedYCheckBox().setSelected(false);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM4(ActionEvent actionEvent) {
        try {
            this.getPreferedYCheckBox().setSelected(false);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM5(ActionEvent actionEvent) {
        try {
            this.oKButton_ActionPerformed(actionEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM6(ActionEvent actionEvent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM7(WindowEvent windowEvent) {
        try {
            this.updateCustomizer();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private String format(String string, double d) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return "Infinite";
        }
        this.format.applyPattern(string);
        return this.format.format(d);
    }

    private JButton getCancelButton() {
        if (this.ivjCancelButton == null) {
            try {
                this.ivjCancelButton = new JButton();
                this.ivjCancelButton.setName("CancelButton");
                this.ivjCancelButton.setText("Cancel");
                this.ivjCancelButton.setMaximumSize(new Dimension(59, 25));
                this.ivjCancelButton.setActionCommand("Cancel");
                this.ivjCancelButton.setMargin(new Insets(2, 7, 2, 7));
                this.ivjCancelButton.setMinimumSize(new Dimension(59, 25));
                this.ivjCancelButton.setBounds(210, 168, 70, 25);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCancelButton;
    }

    public BaseChart getChart() {
        return this.chart;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(null);
                this.ivjJFrameContentPane.setMinimumSize(new Dimension(0, 0));
                this.getJFrameContentPane().add((Component)this.getJLabel1(), this.getJLabel1().getName());
                this.getJFrameContentPane().add((Component)this.getMinXText(), this.getMinXText().getName());
                this.getJFrameContentPane().add((Component)this.getJLabel2(), this.getJLabel2().getName());
                this.getJFrameContentPane().add((Component)this.getMaxXText(), this.getMaxXText().getName());
                this.getJFrameContentPane().add((Component)this.getJLabel3(), this.getJLabel3().getName());
                this.getJFrameContentPane().add((Component)this.getJLabel4(), this.getJLabel4().getName());
                this.getJFrameContentPane().add((Component)this.getMinYText(), this.getMinYText().getName());
                this.getJFrameContentPane().add((Component)this.getMaxYText(), this.getMaxYText().getName());
                this.getJFrameContentPane().add((Component)this.getMinValueLabel(), this.getMinValueLabel().getName());
                this.getJFrameContentPane().add((Component)this.getMaxValueLabel(), this.getMaxValueLabel().getName());
                this.getJFrameContentPane().add((Component)this.getCancelButton(), this.getCancelButton().getName());
                this.getJFrameContentPane().add((Component)this.getOKButton(), this.getOKButton().getName());
                this.getJFrameContentPane().add((Component)this.getPreferedXCheckBox(), this.getPreferedXCheckBox().getName());
                this.getJFrameContentPane().add((Component)this.getPreferedYCheckBox(), this.getPreferedYCheckBox().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("X min");
                this.ivjJLabel1.setMaximumSize(new Dimension(32, 14));
                this.ivjJLabel1.setBounds(20, 17, 45, 21);
                this.ivjJLabel1.setMinimumSize(new Dimension(32, 14));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setText("X max");
                this.ivjJLabel2.setMaximumSize(new Dimension(36, 14));
                this.ivjJLabel2.setBounds(20, 43, 45, 21);
                this.ivjJLabel2.setMinimumSize(new Dimension(36, 14));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel2;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setText("Y min");
                this.ivjJLabel3.setMaximumSize(new Dimension(31, 14));
                this.ivjJLabel3.setBounds(190, 17, 45, 21);
                this.ivjJLabel3.setMinimumSize(new Dimension(31, 14));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel3;
    }

    private JLabel getJLabel4() {
        if (this.ivjJLabel4 == null) {
            try {
                this.ivjJLabel4 = new JLabel();
                this.ivjJLabel4.setName("JLabel4");
                this.ivjJLabel4.setText("Y max");
                this.ivjJLabel4.setMaximumSize(new Dimension(35, 14));
                this.ivjJLabel4.setBounds(190, 43, 45, 21);
                this.ivjJLabel4.setMinimumSize(new Dimension(35, 14));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel4;
    }

    private JLabel getMaxValueLabel() {
        if (this.ivjMaxValueLabel == null) {
            try {
                this.ivjMaxValueLabel = new JLabel();
                this.ivjMaxValueLabel.setName("MaxValueLabel");
                this.ivjMaxValueLabel.setText("Maximum (x,y)");
                this.ivjMaxValueLabel.setMaximumSize(new Dimension(89, 20));
                this.ivjMaxValueLabel.setBounds(5, 134, 340, 19);
                this.ivjMaxValueLabel.setMinimumSize(new Dimension(89, 20));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMaxValueLabel;
    }

    private JTextField getMaxXText() {
        if (this.ivjMaxXText == null) {
            try {
                this.ivjMaxXText = new JTextField();
                this.ivjMaxXText.setName("MaxXText");
                this.ivjMaxXText.setText("");
                this.ivjMaxXText.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
                this.ivjMaxXText.setFont(new Font("dialog", 0, 12));
                this.ivjMaxXText.setEditable(true);
                this.ivjMaxXText.setMinimumSize(new Dimension(120, 25));
                this.ivjMaxXText.setBounds(65, 43, 100, 21);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMaxXText;
    }

    private JTextField getMaxYText() {
        if (this.ivjMaxYText == null) {
            try {
                this.ivjMaxYText = new JTextField();
                this.ivjMaxYText.setName("MaxYText");
                this.ivjMaxYText.setText("");
                this.ivjMaxYText.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
                this.ivjMaxYText.setFont(new Font("dialog", 0, 12));
                this.ivjMaxYText.setEditable(true);
                this.ivjMaxYText.setMinimumSize(new Dimension(120, 25));
                this.ivjMaxYText.setBounds(235, 43, 100, 21);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMaxYText;
    }

    private JLabel getMinValueLabel() {
        if (this.ivjMinValueLabel == null) {
            try {
                this.ivjMinValueLabel = new JLabel();
                this.ivjMinValueLabel.setName("MinValueLabel");
                this.ivjMinValueLabel.setText("Minimum  (x.y)");
                this.ivjMinValueLabel.setMaximumSize(new Dimension(88, 20));
                this.ivjMinValueLabel.setBounds(5, 110, 340, 19);
                this.ivjMinValueLabel.setMinimumSize(new Dimension(88, 20));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMinValueLabel;
    }

    private JTextField getMinXText() {
        if (this.ivjMinXText == null) {
            try {
                this.ivjMinXText = new JTextField();
                this.ivjMinXText.setName("MinXText");
                this.ivjMinXText.setText("");
                this.ivjMinXText.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
                this.ivjMinXText.setFont(new Font("dialog", 0, 12));
                this.ivjMinXText.setEditable(true);
                this.ivjMinXText.setMinimumSize(new Dimension(120, 25));
                this.ivjMinXText.setBounds(65, 17, 100, 21);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMinXText;
    }

    private JTextField getMinYText() {
        if (this.ivjMinYText == null) {
            try {
                this.ivjMinYText = new JTextField();
                this.ivjMinYText.setName("MinYText");
                this.ivjMinYText.setText("");
                this.ivjMinYText.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
                this.ivjMinYText.setFont(new Font("dialog", 0, 12));
                this.ivjMinYText.setEditable(true);
                this.ivjMinYText.setMinimumSize(new Dimension(120, 25));
                this.ivjMinYText.setBounds(235, 17, 100, 21);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMinYText;
    }

    private JButton getOKButton() {
        if (this.ivjOKButton == null) {
            try {
                this.ivjOKButton = new JButton();
                this.ivjOKButton.setName("OKButton");
                this.ivjOKButton.setText("OK");
                this.ivjOKButton.setMaximumSize(new Dimension(37, 25));
                this.ivjOKButton.setActionCommand("OK");
                this.ivjOKButton.setMargin(new Insets(2, 7, 2, 7));
                this.ivjOKButton.setMinimumSize(new Dimension(37, 25));
                this.ivjOKButton.setBounds(70, 168, 70, 25);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjOKButton;
    }

    private JCheckBox getPreferedXCheckBox() {
        if (this.ivjPreferedXCheckBox == null) {
            try {
                this.ivjPreferedXCheckBox = new JCheckBox();
                this.ivjPreferedXCheckBox.setName("PreferedXCheckBox");
                this.ivjPreferedXCheckBox.setText("Prefered");
                this.ivjPreferedXCheckBox.setMaximumSize(new Dimension(75, 22));
                this.ivjPreferedXCheckBox.setActionCommand("Prefered");
                this.ivjPreferedXCheckBox.setSelected(true);
                this.ivjPreferedXCheckBox.setBounds(20, 74, 97, 21);
                this.ivjPreferedXCheckBox.setMinimumSize(new Dimension(75, 22));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjPreferedXCheckBox;
    }

    private JCheckBox getPreferedYCheckBox() {
        if (this.ivjPreferedYCheckBox == null) {
            try {
                this.ivjPreferedYCheckBox = new JCheckBox();
                this.ivjPreferedYCheckBox.setName("PreferedYCheckBox");
                this.ivjPreferedYCheckBox.setText("Prefered");
                this.ivjPreferedYCheckBox.setMaximumSize(new Dimension(75, 22));
                this.ivjPreferedYCheckBox.setActionCommand("Prefered");
                this.ivjPreferedYCheckBox.setSelected(true);
                this.ivjPreferedYCheckBox.setBounds(190, 74, 97, 21);
                this.ivjPreferedYCheckBox.setMinimumSize(new Dimension(75, 22));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjPreferedYCheckBox;
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getOKButton().addActionListener(this.ivjEventHandler);
        this.getCancelButton().addActionListener(this.ivjEventHandler);
        this.addWindowListener(this.ivjEventHandler);
        this.getMinXText().addActionListener(this.ivjEventHandler);
        this.getMaxXText().addActionListener(this.ivjEventHandler);
        this.getMinYText().addActionListener(this.ivjEventHandler);
        this.getMaxYText().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("BaseChartCustomizer");
            this.setDefaultCloseOperation(2);
            this.setTitle("Chart Customizer");
            this.setBounds(new Rectangle(0, 0, 356, 232));
            this.setSize(356, 232);
            this.setResizable(false);
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public static void main(String[] stringArray) {
        try {
            BaseChartCustomizer baseChartCustomizer = new BaseChartCustomizer();
            baseChartCustomizer.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            baseChartCustomizer.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }

    public void oKButton_ActionPerformed(ActionEvent actionEvent) {
        if (this.chart == null) {
            this.dispose();
        }
        try {
            if (this.getPreferedXCheckBox().isSelected()) {
                this.chart.getViewManager().setUserXScaleUsed(true);
            } else {
                this.chart.getViewManager().setXScale(new Interval(Double.valueOf(this.getMinXText().getText()), Double.valueOf(this.getMaxXText().getText())));
            }
            if (this.getPreferedYCheckBox().isSelected()) {
                this.chart.getViewManager().setUserYScaleUsed(true);
            } else {
                this.chart.getViewManager().setYScale(new Interval(Double.valueOf(this.getMinYText().getText()), Double.valueOf(this.getMaxYText().getText())));
            }
            this.chart.updateChart(ChartUpdateRequest.UPDATE_ALL);
            this.dispose();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showConfirmDialog(this, "Parsing number exception: " + numberFormatException.toString(), "Error", 0, 0);
        }
    }

    public void setChart(BaseChart baseChart) {
        this.chart = baseChart;
    }

    public void updateCustomizer() {
        if (this.chart == null) {
            return;
        }
        this.getMinXText().setText(Double.toString(this.chart.getViewManager().getXScale().min()));
        this.getMaxXText().setText(Double.toString(this.chart.getViewManager().getXScale().max()));
        this.getMinYText().setText(Double.toString(this.chart.getViewManager().getYScale().min()));
        this.getMaxYText().setText(Double.toString(this.chart.getViewManager().getYScale().max()));
        this.getPreferedXCheckBox().setSelected(this.chart.getViewManager().isUserXScaleUsed());
        this.getPreferedYCheckBox().setSelected(this.chart.getViewManager().isUserYScaleUsed());
        this.getMinValueLabel().setText("Min Value (" + this.format("#.####", this.chart.getChartArea().getMinValue().x) + "," + this.format("#.####", this.chart.getChartArea().getMinValue().y) + ")");
        this.getMaxValueLabel().setText("Max Value (" + this.format("#.####", this.chart.getChartArea().getMaxValue().x) + "," + this.format("#.####", this.chart.getChartArea().getMaxValue().y) + ")");
    }

    class IvjEventHandler
    implements ActionListener,
    WindowListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == BaseChartCustomizer.this.getOKButton()) {
                BaseChartCustomizer.this.connEtoM5(actionEvent);
            }
            if (actionEvent.getSource() == BaseChartCustomizer.this.getCancelButton()) {
                BaseChartCustomizer.this.connEtoM6(actionEvent);
            }
            if (actionEvent.getSource() == BaseChartCustomizer.this.getMinXText()) {
                BaseChartCustomizer.this.connEtoM1(actionEvent);
            }
            if (actionEvent.getSource() == BaseChartCustomizer.this.getMaxXText()) {
                BaseChartCustomizer.this.connEtoM2(actionEvent);
            }
            if (actionEvent.getSource() == BaseChartCustomizer.this.getMinYText()) {
                BaseChartCustomizer.this.connEtoM3(actionEvent);
            }
            if (actionEvent.getSource() == BaseChartCustomizer.this.getMaxYText()) {
                BaseChartCustomizer.this.connEtoM4(actionEvent);
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
            if (windowEvent.getSource() == BaseChartCustomizer.this) {
                BaseChartCustomizer.this.connEtoM7(windowEvent);
            }
        }
    }
}

