/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.BaseChartCustomizer;
import com.cosylab.gui.components.r2.chart.ChartArea;
import com.cosylab.gui.components.r2.chart.ChartDecorator;
import com.cosylab.gui.components.r2.chart.ChartProperties;
import com.cosylab.gui.components.r2.chart.ChartService;
import com.cosylab.gui.components.r2.chart.ChartStyleManager;
import com.cosylab.gui.components.r2.chart.ChartUpdateRequest;
import com.cosylab.gui.components.r2.chart.ChartViewManager;
import com.cosylab.gui.components.r2.chart.ChartXAxis;
import com.cosylab.gui.components.r2.chart.ChartYAxis;
import com.cosylab.gui.components.r2.chart.Chartics;
import com.cosylab.gui.components.r2.chart.DefaultChartDecorator;
import com.cosylab.gui.components.r2.chart.FunctionDataModel;
import com.cosylab.gui.components.r2.chart.Interval;
import com.cosylab.gui.components.r2.chart.SinusFunction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class BaseChart
extends JComponent
implements ChartService {
    private Rectangle chartRectangle;
    private Insets userMargin = new Insets(30, 10, 10, 40);
    public static final String PROPERTY_CHART = "chart";
    private BaseChartCustomizer chartCustomizer;
    private Chartics chartics;
    private ChartArea chartArea;
    private ChartStyleManager chartStyleManager;
    private ChartXAxis xAxis;
    private ChartYAxis yAxis;
    private ChartViewManager viewManager = null;
    private ChartDecorator chartDecorator;
    private ChartDecorator defaultChartDecorator = new DefaultChartDecorator();
    private int updateRequests = 0;
    private ChartUpdater updater = new ChartUpdater();

    public BaseChart() {
        this.updater.start();
        this.getViewManager().setXScale(new Interval(0.5, 1.5));
        this.getViewManager().setYScale(new Interval(0.0, 10.0));
        this.getViewManager().setUserXScaleUsed(true);
        this.getViewManager().setUserYScaleUsed(true);
        this.setSize(200, 150);
        this.setBackground(Color.white);
        this.updateLayout();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BaseChart.this._mouseClicked(mouseEvent);
            }
        });
    }

    private void _mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        this.getChartCustomizer().updateCustomizer();
        this.getChartCustomizer().show();
    }

    public void addNotify() {
        super.addNotify();
        this.updateLayout();
    }

    protected void drawAxis(Graphics graphics) {
        try {
            this.getXAxis().drawAxis(graphics);
            this.getYAxis().drawAxis(graphics);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    protected void drawData(Graphics graphics, ChartUpdateRequest chartUpdateRequest) {
        try {
            this.getChartArea().drawData(this.getChartics(), chartUpdateRequest);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartArea getChartArea() {
        if (this.chartArea == null) {
            BaseChart baseChart = this;
            synchronized (baseChart) {
                if (this.chartArea == null) {
                    this.chartArea = this.defaultChartDecorator.getDefultChartFlavor().getChartArea();
                    this.chartArea.setChartService(this);
                    this.updateLayout();
                }
            }
        }
        return this.chartArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseChartCustomizer getChartCustomizer() {
        if (this.chartCustomizer == null) {
            BaseChart baseChart = this;
            synchronized (baseChart) {
                if (this.chartCustomizer == null) {
                    try {
                        this.chartCustomizer = new BaseChartCustomizer(this);
                    }
                    catch (Throwable throwable) {
                        this.handleException(throwable);
                    }
                }
            }
        }
        return this.chartCustomizer;
    }

    public ChartDecorator getChartDecorator() {
        return this.chartDecorator;
    }

    public int getChartDisplayablePointCount() {
        return this.getChartArea().getChartRectangle().width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chartics getChartics() {
        if (this.chartics == null) {
            BaseChart baseChart = this;
            synchronized (baseChart) {
                if (this.chartics == null) {
                    this.chartics = new Chartics();
                    this.chartics.setBackground(this.getBackground());
                }
            }
        }
        return this.chartics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartStyleManager getChartStyleManager() {
        if (this.chartStyleManager == null) {
            BaseChart baseChart = this;
            synchronized (baseChart) {
                if (this.chartStyleManager == null) {
                    this.chartStyleManager = this.defaultChartDecorator.getDefultChartFlavor().getChartStyleManager();
                    this.getChartArea().setChartService(this);
                }
            }
        }
        return this.chartStyleManager;
    }

    public ChartDecorator getDefaultChartDecorator() {
        return this.defaultChartDecorator;
    }

    public Insets getMargin() {
        return this.userMargin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartViewManager getViewManager() {
        if (this.viewManager == null) {
            BaseChart baseChart = this;
            synchronized (baseChart) {
                if (this.viewManager == null) {
                    this.viewManager = this.defaultChartDecorator.getDefultChartFlavor().getViewManager();
                    this.getChartArea().setChartService(this);
                    this.getXAxis().setViewManager(this.viewManager);
                    this.getYAxis().setViewManager(this.viewManager);
                }
            }
        }
        return this.viewManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartXAxis getXAxis() {
        if (this.xAxis == null) {
            BaseChart baseChart = this;
            synchronized (baseChart) {
                if (this.xAxis == null) {
                    this.xAxis = this.defaultChartDecorator.getDefultChartFlavor().getXAxis();
                    this.xAxis.setChartSize(this.getChartArea().getChartRectangle().getSize());
                    this.xAxis.setViewManager(this.getViewManager());
                }
            }
        }
        return this.xAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartYAxis getYAxis() {
        if (this.yAxis == null) {
            BaseChart baseChart = this;
            synchronized (baseChart) {
                if (this.yAxis == null) {
                    this.yAxis = this.defaultChartDecorator.getDefultChartFlavor().getYAxis();
                    this.yAxis.setChartSize(this.getChartArea().getChartRectangle().getSize());
                    this.yAxis.setViewManager(this.getViewManager());
                }
            }
        }
        return this.yAxis;
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            BaseChart baseChart = new BaseChart();
            jFrame.setContentPane(baseChart);
            jFrame.setSize(baseChart.getSize());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.setVisible(true);
            class MyThread
            extends Thread {
                SinusFunction f = new SinusFunction();
                int speed = 50;
                boolean first = true;
                BaseChart c;

                public MyThread(BaseChart baseChart) {
                    this.c = baseChart;
                    this.c.getChartArea().addDataModel(new FunctionDataModel(this.f));
                }

                public synchronized void run() {
                    while (true) {
                        if (this.first) {
                            try {
                                this.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            this.first = false;
                        }
                        if (this.f.getPhase() == -1000000.0) {
                            this.f.setPhase(0.0);
                        }
                        this.f.setPhase(this.f.getPhase() - (double)this.speed / 3000.0);
                        this.c.updateChart(ChartUpdateRequest.RELOAD_ALL);
                        try {
                            this.wait(this.speed);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            }
            new MyThread(baseChart).start();
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            throwable.printStackTrace(System.out);
        }
    }

    protected void paintComponent(Graphics graphics) {
        this.updateRequests = 0;
        if (this.chartRectangle.width != this.getWidth() - this.userMargin.left - this.userMargin.right - this.getYAxis().getPreferedWidth() || this.chartRectangle.height != this.getHeight() - this.userMargin.top - this.userMargin.bottom - this.getXAxis().getPreferedHeight()) {
            this.updater.queueRequest(ChartUpdateRequest.UPDATE_ALL);
        }
        if (this.getChartics().getImage() != null) {
            graphics.drawImage(this.getChartics().getImage(), 0, 0, this);
        }
    }

    public void setBackground(Color color) {
        this.getChartics().setBackground(color);
        super.setBackground(color);
    }

    public void setChartArea(ChartArea chartArea) {
        this.chartArea = chartArea;
        this.getChartArea().setChartService(this);
        this.updateLayout();
    }

    public void setChartDecorator(ChartDecorator chartDecorator) {
        this.chartDecorator = chartDecorator;
    }

    public void setChartics(Chartics chartics) {
        this.chartics = chartics;
    }

    public void setChartStyleManager(ChartStyleManager chartStyleManager) {
        this.chartStyleManager = chartStyleManager;
        this.getChartArea().setChartService(this);
    }

    public void setDefaultChartDecorator(ChartDecorator chartDecorator) {
        this.defaultChartDecorator = chartDecorator;
    }

    public void setMargin(Insets insets) {
        this.userMargin = insets;
        this.updateLayout();
    }

    public void setViewManager(ChartViewManager chartViewManager) {
        this.viewManager = chartViewManager;
        this.getXAxis().setViewManager(this.getViewManager());
        this.getYAxis().setViewManager(this.getViewManager());
        this.getChartArea().setChartService(this);
    }

    public void setXAxis(ChartXAxis chartXAxis) {
        this.xAxis = chartXAxis;
        this.getXAxis().setChartSize(this.getChartArea().getChartRectangle().getSize());
        this.getXAxis().setViewManager(this.getViewManager());
    }

    public void setYAxis(ChartYAxis chartYAxis) {
        this.yAxis = chartYAxis;
        this.getYAxis().setChartSize(this.getChartArea().getChartRectangle().getSize());
        this.getYAxis().setViewManager(this.getViewManager());
    }

    public void updateChart(ChartUpdateRequest chartUpdateRequest) {
        ++this.updateRequests;
        this.updater.queueRequest(chartUpdateRequest);
    }

    protected void updateMainBuffer(ChartUpdateRequest chartUpdateRequest) {
        if (this.chartRectangle.width != this.getWidth() - this.userMargin.left - this.userMargin.right - this.getYAxis().getPreferedWidth() || this.chartRectangle.height != this.getHeight() - this.userMargin.top - this.userMargin.bottom - this.getXAxis().getPreferedHeight()) {
            this.updateLayout();
            this.getChartics().setImage((BufferedImage)this.createImage(this.getWidth(), this.getHeight()));
            chartUpdateRequest = ChartUpdateRequest.UPDATE_ALL;
        }
        if (chartUpdateRequest != null) {
            this.updateImageBuffer(chartUpdateRequest);
        }
    }

    protected synchronized void updateImageBuffer(ChartUpdateRequest chartUpdateRequest) {
        Dimension dimension;
        if (chartUpdateRequest == null) {
            return;
        }
        if (chartUpdateRequest == ChartUpdateRequest.RELOAD_ALL) {
            this.getViewManager().revalidate();
        }
        Graphics graphics = this.getChartics().getGraphics();
        Shape shape = graphics.getClip();
        graphics.setColor(this.getBackground());
        graphics.clearRect(0, 0, this.getChartics().getImage().getWidth(), this.getChartics().getImage().getHeight());
        graphics.setColor(this.getForeground());
        Dimension dimension2 = this.chartRectangle.getSize();
        graphics.translate(this.chartRectangle.x, this.chartRectangle.y);
        graphics.setClip(0, 0, dimension2.width, dimension2.height);
        this.drawData(graphics, chartUpdateRequest);
        if (ChartProperties.getChartProperties().isDebugGraphics()) {
            dimension = this.getChartArea().getChartRectangle().getSize();
            this.chartics.getGraphics().setColor(Color.red);
            this.chartics.getGraphics().drawRect(0, 0, dimension2.width - 1, dimension2.height - 1);
            this.chartics.getGraphics().drawLine(0, 0, dimension2.width - 1, dimension2.height - 1);
            this.chartics.getGraphics().drawLine(0, dimension2.height - 1, dimension2.width - 1, 0);
            this.chartics.getGraphics().setColor(Color.magenta);
            this.chartics.getGraphics().drawRect(this.getChartArea().getChartRectangle().x, this.getChartArea().getChartRectangle().y, dimension.width - 1, dimension.height - 1);
            this.chartics.getGraphics().drawLine(this.getChartArea().getChartRectangle().x, this.getChartArea().getChartRectangle().y, this.getChartArea().getChartRectangle().x + dimension.width - 1, this.getChartArea().getChartRectangle().y + dimension.height - 1);
            this.chartics.getGraphics().drawLine(this.getChartArea().getChartRectangle().x, this.getChartArea().getChartRectangle().y + dimension.height - 1, this.getChartArea().getChartRectangle().x + dimension.width - 1, this.getChartArea().getChartRectangle().y);
            this.chartics.getGraphics().setColor(this.getForeground());
        }
        graphics.setClip(shape);
        graphics.translate(this.getChartArea().getChartRectangle().x, this.getChartArea().getChartRectangle().y);
        this.drawAxis(graphics);
        if (ChartProperties.getChartProperties().isDebugGraphics()) {
            dimension = this.getChartArea().getChartRectangle().getSize();
            this.chartics.getGraphics().setColor(Color.green);
            this.chartics.getGraphics().drawRect(0, dimension.height - 1, dimension.width - 1, this.getXAxis().getPreferedHeight() - 1);
            this.chartics.getGraphics().drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1 + this.getXAxis().getPreferedHeight() - 1);
            this.chartics.getGraphics().drawLine(0, dimension.height - 1 + this.getXAxis().getPreferedHeight() - 1, dimension.width - 1, dimension.height - 1);
            this.chartics.getGraphics().drawRect(-this.getYAxis().getPreferedWidth() + 1, 0, this.getYAxis().getPreferedWidth() - 1, dimension.height - 1);
            this.chartics.getGraphics().drawLine(-this.getYAxis().getPreferedWidth() + 1, 0, 0, dimension.height - 1);
            this.chartics.getGraphics().drawLine(-this.getYAxis().getPreferedWidth() + 1, dimension.height - 1, 0, 0);
            this.chartics.getGraphics().setColor(this.getForeground());
        }
        graphics.translate(-this.chartRectangle.x - this.getChartArea().getChartRectangle().x, -this.chartRectangle.y - this.getChartArea().getChartRectangle().y);
    }

    protected synchronized void updateLayout() {
        Rectangle rectangle = new Rectangle(this.userMargin.left + this.getYAxis().getPreferedWidth(), this.userMargin.top, this.getSize().width - this.userMargin.left - this.userMargin.right - this.getYAxis().getPreferedWidth(), this.getSize().height - this.userMargin.top - this.userMargin.bottom - this.getXAxis().getPreferedHeight());
        this.chartRectangle = rectangle.width < 0 || rectangle.height < 0 ? new Rectangle(0, 0, 1, 1) : rectangle;
        this.getChartArea().setSize(this.chartRectangle.getSize());
        this.getXAxis().setChartSize(this.getChartArea().getChartRectangle().getSize());
        this.getYAxis().setChartSize(this.getChartArea().getChartRectangle().getSize());
    }

    class ChartUpdater
    extends Thread {
        private int frames = 30;
        private long rate = 33L;
        private ChartUpdateRequest request;
        private Runnable later = new Runnable(){

            public void run() {
                BaseChart.this.repaint();
            }
        };

        ChartUpdater() {
        }

        public synchronized void queueRequest(ChartUpdateRequest chartUpdateRequest) {
            if (this.request == null) {
                this.request = chartUpdateRequest;
            } else if (this.request.getCode() > chartUpdateRequest.getCode()) {
                this.request = chartUpdateRequest;
            }
            this.notify();
        }

        private synchronized ChartUpdateRequest pull() {
            ChartUpdateRequest chartUpdateRequest = this.request;
            this.request = null;
            return chartUpdateRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis() - (long)(1000.0 / (double)this.frames) - 1L;
            while (true) {
                ChartUpdateRequest chartUpdateRequest;
                if ((chartUpdateRequest = this.pull()) != null && System.currentTimeMillis() - l > (long)(1000.0 / (double)this.frames)) {
                    l = System.currentTimeMillis();
                    BaseChart.this.updateMainBuffer(chartUpdateRequest);
                    SwingUtilities.invokeLater(this.later);
                }
                ChartUpdater chartUpdater = this;
                synchronized (chartUpdater) {
                    try {
                        if (this.request == null) {
                            this.wait();
                        } else {
                            this.wait(System.currentTimeMillis() - l > (long)(1000.0 / (double)this.frames) ? (long)(1000.0 / (double)this.frames) : (long)(1000.0 / (double)this.frames) + l - System.currentTimeMillis());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public int getFrames() {
            return this.frames;
        }

        public synchronized void setFrames(int n) {
            this.frames = n;
            this.rate = (long)(1000.0 / (double)n);
            this.notify();
        }
    }
}

