/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.AbstractDataModel;
import com.cosylab.gui.components.r2.chart.Interval;
import com.cosylab.gui.components.r2.chart.Point;
import com.cosylab.gui.components.r2.chart.PointIterator;

public class ArrayDataModel
extends AbstractDataModel {
    public double[] x;
    public double[] y;
    private int index = 0;

    public ArrayDataModel(int n) {
        this.pointCount = n;
        this.x = new double[n];
        this.y = new double[n];
    }

    public PointIterator getPointIterator() {
        this.index = 0;
        return this;
    }

    public boolean hasNext() {
        return this.index < this.pointCount;
    }

    public Point next() {
        this.point.x = this.x[this.index];
        this.point.y = this.y[this.index];
        ++this.index;
        return this.point;
    }

    public void updateChart() {
        this.preferedXScale = new Interval(this.x[0] - 0.1 * (this.x[this.pointCount - 1] - this.x[0]), this.x[this.pointCount - 1] + 0.1 * (this.x[this.pointCount - 1] - this.x[0]));
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < this.pointCount; ++i) {
            if (Double.isInfinite(this.y[i]) || Double.isNaN(this.y[i])) continue;
            if (this.y[i] < d) {
                d = this.y[i];
            }
            if (!(this.y[i] > d2)) continue;
            d2 = this.y[i];
        }
        this.preferedYScale = new Interval(d - 0.1 * (d2 - d), d2 + 0.1 * (d2 - d));
        this.updateChartData();
    }
}

