/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartAxis;
import com.cosylab.gui.components.r2.chart.ChartViewManager;
import com.cosylab.gui.components.r2.chart.Interval;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.text.DecimalFormat;

public abstract class AbstractChartAxis
implements ChartAxis {
    protected int preferedHeight = 10;
    protected int preferedWidth = 10;
    protected Color lineColor;
    protected Font font;
    protected Color fontColor;
    protected Dimension chartSize;
    protected Interval xScale = new Interval(0.0, 1.0);
    protected Interval yScale = new Interval(0.0, 1.0);
    protected String format;
    protected DecimalFormat decFormat = new DecimalFormat();
    protected int minorTickLength = 3;
    protected int majorTickLength = 5;
    protected ChartViewManager viewManager;
    protected Insets textMargin = new Insets(5, 7, 5, 7);

    public AbstractChartAxis() {
        this.setFont(null);
        this.setFontColor(null);
        this.setLineColor(null);
        this.setFormat(null);
    }

    public String format(double d) {
        return this.decFormat.format(d);
    }

    public Dimension getChartSize() {
        return this.chartSize;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public String getFormat() {
        return this.format;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getMajorTickLength() {
        return this.majorTickLength;
    }

    public int getMinorTickLength() {
        return this.minorTickLength;
    }

    public int getPreferedHeight() {
        return this.preferedHeight;
    }

    public int getPreferedWidth() {
        return this.preferedWidth;
    }

    public Insets getTextMargin() {
        return this.textMargin;
    }

    public ChartViewManager getViewManager() {
        return this.viewManager;
    }

    public void setChartSize(Dimension dimension) {
        this.chartSize = dimension;
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.font == null) {
            this.font = new Font("SansSerif", 0, 11);
        }
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
        if (this.fontColor == null) {
            this.fontColor = Color.black;
        }
    }

    public void setFormat(String string) {
        this.format = string;
        if (this.format == null) {
            this.format = "0.00";
        }
        this.decFormat.applyPattern(this.format);
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
        if (this.lineColor == null) {
            this.lineColor = Color.black;
        }
    }

    public void setMajorTickLength(int n) {
        this.majorTickLength = n;
    }

    public void setMinorTickLength(int n) {
        this.minorTickLength = n;
    }

    public void setPreferedHeight(int n) {
        this.preferedHeight = n;
    }

    public void setPreferedWidth(int n) {
        this.preferedWidth = n;
    }

    public void setTextMargin(Insets insets) {
        this.textMargin = insets;
    }

    public void setViewManager(ChartViewManager chartViewManager) {
        this.xScale = (Interval)chartViewManager.extractedXScaleIterator().next();
        this.yScale = (Interval)chartViewManager.extractedYScaleIterator().next();
        this.viewManager = chartViewManager;
    }
}

