/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import com.cosylab.gui.components.r2.DataFormatter;
import com.cosylab.gui.components.r2.SmartPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;

public class SmartTextPane
extends JTextPane {
    private JFileChooser fileChooser = null;
    private JPopupMenu popup = null;
    private boolean auto_cut = true;
    private boolean auto_scroll = true;
    private int maxLines = 1000;
    private boolean popupInitialized = false;

    public SmartTextPane() {
        this.initialize();
    }

    public SmartTextPane(StyledDocument styledDocument) {
        super(styledDocument);
        this.initialize();
    }

    public void append(String string) {
        try {
            if (this.getText().length() == 0) {
                this.setText(string);
            } else {
                super.getDocument().insertString(this.getText().length(), string, null);
            }
            this.textInserted();
            return;
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = new JPopupMenu("Smart text pane");
            JMenuItem jMenuItem = new JMenuItem("Save");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SmartTextPane.this.saveTextToFile();
                }
            });
            this.popup.add(jMenuItem);
        }
        return this.popup;
    }

    private void initialize() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SmartTextPane.this.showPopup(mouseEvent);
            }
        });
        this.setEditable(false);
    }

    public boolean isAuto_cut() {
        return this.auto_cut;
    }

    public boolean isAuto_scroll() {
        return this.auto_scroll;
    }

    public static void main(String[] stringArray) {
        JPanel jPanel = new JPanel(new CardLayout(2, 2));
        SmartPanel smartPanel = new SmartPanel();
        smartPanel.setLayout(new CardLayout(2, 2));
        SmartTextPane smartTextPane = new SmartTextPane();
        smartTextPane.setEditable(false);
        smartTextPane.append("Krneki\nkaj pa zdej?");
        smartPanel.add((Component)smartTextPane, "Smart text pane");
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jPanel.add((Component)smartPanel, "panel");
        jFrame.setContentPane(jPanel);
        jFrame.show();
    }

    public void saveTextToFile() {
        this.getFileChooser().showSaveDialog(this);
        File file = this.getFileChooser().getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            String[] stringArray = DataFormatter.splitStringByLines(this.getText());
            for (int i = 0; i < stringArray.length; ++i) {
                bufferedWriter.write(stringArray[i]);
                bufferedWriter.newLine();
                System.out.println("written " + stringArray[i]);
            }
            bufferedWriter.close();
            System.out.println("written to:" + file + " text:" + this.getText());
        }
        catch (IOException iOException) {
            System.out.println("exception while writing " + iOException + " " + file + " " + this.getText());
            iOException.printStackTrace();
        }
    }

    public void setAuto_cut(boolean bl) {
        this.auto_cut = bl;
    }

    public void setAuto_scroll(boolean bl) {
        this.auto_scroll = bl;
    }

    public void setFileChooser(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
    }

    public void setMaxLines(int n) {
        this.maxLines = n;
    }

    public void setPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    private synchronized void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            if (this.getPopup().getComponents().length < 2) {
                Container container = this.getParent();
                if (container instanceof JViewport) {
                    container = container.getParent().getParent();
                }
                if (container instanceof SmartPanel) {
                    JMenuItem[] jMenuItemArray = ((SmartPanel)container).getNewMenuItems();
                    for (int i = 0; i < jMenuItemArray.length; ++i) {
                        this.getPopup().add(jMenuItemArray[i]);
                    }
                }
                this.popupInitialized = true;
            }
            this.getPopup().show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void textInserted() {
        if (this.auto_cut && DataFormatter.getLineCount(this.getText()) > this.maxLines) {
            this.setText(DataFormatter.cropFromEnd(this.getText(), this.maxLines));
        }
        if (this.auto_scroll) {
            this.setCaretPosition(this.getDocument().getLength());
        }
    }
}

