/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import com.cosylab.gui.components.r2.DataFormatter;
import com.cosylab.gui.components.r2.SmartPanel;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.text.Document;

public class SmartTextArea
extends JTextArea {
    private int max_no_lines = 500;
    private boolean auto_scroll = true;
    private boolean auto_cut = true;
    private JFileChooser fileChooser = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private boolean popupInitialized = false;
    private JMenuItem ivjJMenuItem1 = null;
    private JPopupMenu ivjJPopupMenu1 = null;

    public SmartTextArea() {
        this.initialize();
    }

    public SmartTextArea(int n, int n2) {
        super(n, n2);
    }

    public SmartTextArea(String string) {
        super(string);
    }

    public SmartTextArea(String string, int n, int n2) {
        super(string, n, n2);
    }

    public SmartTextArea(Document document) {
        super(document);
    }

    public SmartTextArea(Document document, String string, int n, int n2) {
        super(document, string, n, n2);
    }

    public void append(String string) {
        super.append(string);
        this.textInserted();
    }

    private void connEtoC1(MouseEvent mouseEvent) {
        try {
            this.showPopup(mouseEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(ActionEvent actionEvent) {
        try {
            this.saveTextToFile();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }

    private JMenuItem getJMenuItem1() {
        if (this.ivjJMenuItem1 == null) {
            try {
                this.ivjJMenuItem1 = new JMenuItem();
                this.ivjJMenuItem1.setName("JMenuItem1");
                this.ivjJMenuItem1.setText("Save...");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJMenuItem1;
    }

    public int getMaxLines() {
        return this.max_no_lines;
    }

    public JPopupMenu getPopup() {
        if (this.ivjJPopupMenu1 == null) {
            try {
                this.ivjJPopupMenu1 = new JPopupMenu();
                this.ivjJPopupMenu1.setName("JPopupMenu1");
                this.ivjJPopupMenu1.add(this.getJMenuItem1());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPopupMenu1;
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.addMouseListener(this.ivjEventHandler);
        this.getJMenuItem1().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setDisabledTextColor(this.getForeground());
            this.setName("SmartTextArea");
            this.setSize(160, 120);
            this.setEditable(true);
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public void insert(String string, int n) {
        super.insert(string, n);
        this.textInserted();
    }

    public boolean isAuto_cut() {
        return this.auto_cut;
    }

    public boolean isAuto_scroll() {
        return this.auto_scroll;
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            SmartTextArea smartTextArea = new SmartTextArea();
            jFrame.setContentPane(smartTextArea);
            jFrame.setSize(smartTextArea.getSize());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.show();
            Insets insets = jFrame.getInsets();
            jFrame.setSize(jFrame.getWidth() + insets.left + insets.right, jFrame.getHeight() + insets.top + insets.bottom);
            jFrame.setVisible(true);
            smartTextArea.append("TOLE PROBAVAMO\n");
            smartTextArea.append("TOLE PROBAVAMO\n");
            smartTextArea.append("TOLE PROBAVAMO\n");
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of si.ijs.acs.objectexplorer.SmartTextArea");
            throwable.printStackTrace(System.out);
        }
    }

    public void saveTextToFile() {
        this.getFileChooser().showSaveDialog(this);
        File file = this.getFileChooser().getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            String[] stringArray = DataFormatter.splitStringByLines(this.getText());
            for (int i = 0; i < stringArray.length; ++i) {
                bufferedWriter.write(stringArray[i]);
                bufferedWriter.newLine();
                System.out.println("written " + stringArray[i]);
            }
            bufferedWriter.close();
            System.out.println("written to:" + file + " text:" + this.getText());
        }
        catch (IOException iOException) {
            System.out.println("exception while writing " + iOException + " " + file + " " + this.getText());
            iOException.printStackTrace();
        }
    }

    public void setAuto_cut(boolean bl) {
        this.auto_cut = bl;
    }

    public void setAuto_scroll(boolean bl) {
        this.auto_scroll = bl;
    }

    public void setFileChooser(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
    }

    public void setMaxLines(int n) {
        this.max_no_lines = n;
    }

    public synchronized void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            if (this.getPopup().getComponents().length < 2) {
                Container container = this.getParent().getParent().getParent();
                if (container instanceof SmartPanel) {
                    JMenuItem[] jMenuItemArray = ((SmartPanel)container).getNewMenuItems();
                    for (int i = 0; i < jMenuItemArray.length; ++i) {
                        this.getPopup().add(jMenuItemArray[i]);
                    }
                }
                this.popupInitialized = true;
            }
            this.getPopup().show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void textInserted() {
        try {
            if (this.auto_cut && this.getLineCount() > this.max_no_lines) {
                this.replaceRange("", 0, this.getLineStartOffset(this.getLineCount() - this.max_no_lines + 1));
            }
            if (this.auto_scroll) {
                this.setCaretPosition(this.getDocument().getLength());
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    class IvjEventHandler
    implements ActionListener,
    MouseListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SmartTextArea.this.getJMenuItem1()) {
                SmartTextArea.this.connEtoC2(actionEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == SmartTextArea.this) {
                SmartTextArea.this.connEtoC1(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

