/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import com.cosylab.gui.components.r2.CheckListModel;
import com.cosylab.gui.components.r2.ListSearchListener;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class JCheckList
extends JList {
    public JCheckList() {
        this.setModel(new CheckListModel());
        this.addMouseListener(new CLMouseAdapter());
        this.addKeyListener(new CLKeyAdapter());
        this.addKeyListener(new ListSearchListener(this));
        this.setCellRenderer(new CheckListRenderer());
    }

    public JCheckList(Object[] objectArray) {
        super(objectArray);
    }

    public JCheckList(Vector vector) {
        super(vector);
    }

    protected void checkboxAction() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        ((CheckListModel)this.getModel()).toggleChecked(n);
    }

    public boolean[] getChecked() {
        CheckListModel checkListModel = (CheckListModel)this.getModel();
        int n = checkListModel.size();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = checkListModel.isChecked(i);
        }
        return blArray;
    }

    public Object[] getCheckedItems(boolean bl) {
        CheckListModel checkListModel = (CheckListModel)this.getModel();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = checkListModel.size();
        for (int i = 0; i < n; ++i) {
            if (checkListModel.isChecked(i) != bl) continue;
            arrayList.add(checkListModel.get(i));
        }
        return arrayList.toArray();
    }

    public void setChecked(boolean[] blArray) {
        CheckListModel checkListModel = (CheckListModel)this.getModel();
        int n = checkListModel.size();
        if (blArray.length != n) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            checkListModel.setChecked(i, blArray[i]);
        }
    }

    public class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        protected final EmptyBorder defaultBorder = new EmptyBorder(1, 1, 1, 1);

        public CheckListRenderer() {
            this.setOpaque(true);
            this.setBorder(this.defaultBorder);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            CheckListModel checkListModel = (CheckListModel)jList.getModel();
            if (checkListModel == null) {
                return this;
            }
            this.setSelected(checkListModel.isChecked(n));
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : this.defaultBorder);
            return this;
        }
    }

    public class CLMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getX() < 20) {
                JCheckList.this.checkboxAction();
            }
        }
    }

    public class CLKeyAdapter
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == ' ') {
                JCheckList.this.checkboxAction();
            }
        }
    }
}

