/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import alma.acs.util.UTCUtility;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class DataFormatter {
    public static int MAX_RECURSION_LEVEL = 25;
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSS");

    public static String arrayToString(Object object) {
        return DataFormatter.arrayToString(object, "");
    }

    public static String arrayToString(Object object, String string) {
        if (object.getClass().isArray()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append("Array of class: ");
            stringBuffer.append(object.getClass().getComponentType().getName());
            Object[] objectArray = object.getClass().getComponentType().isPrimitive() ? DataFormatter.convertPrimitiveArray(object) : (Object[])object;
            stringBuffer.append(" length: ");
            stringBuffer.append(objectArray.length);
            stringBuffer.append("\n");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(string);
                stringBuffer.append(" [");
                stringBuffer.append(i);
                stringBuffer.append("] ");
                stringBuffer.append(objectArray[i].toString());
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        throw new IllegalArgumentException("array parameter is not an array");
    }

    public static Object[] convertPrimitiveArray(Object object) {
        if (!object.getClass().isArray() || !object.getClass().getComponentType().isPrimitive()) {
            throw new IllegalArgumentException("value is not a primitive Array");
        }
        try {
            Class<?> clazz = object.getClass().getComponentType();
            Serializable[] serializableArray = null;
            if (clazz.toString().equals("int")) {
                int[] nArray = (int[])object;
                serializableArray = new Integer[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    serializableArray[i] = new Integer(nArray[i]);
                }
            } else if (clazz.toString().equals("double")) {
                double[] dArray = (double[])object;
                serializableArray = new Double[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    serializableArray[i] = new Double(dArray[i]);
                }
            } else if (clazz.toString().equals("long")) {
                long[] lArray = (long[])object;
                serializableArray = new Long[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    serializableArray[i] = new Long(lArray[i]);
                }
            } else if (clazz.toString().equals("short")) {
                short[] sArray = (short[])object;
                serializableArray = new Short[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    serializableArray[i] = new Short(sArray[i]);
                }
            } else if (clazz.toString().equals("byte")) {
                byte[] byArray = (byte[])object;
                serializableArray = new Byte[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    serializableArray[i] = new Byte(byArray[i]);
                }
            } else if (clazz.toString().equals("char")) {
                char[] cArray = (char[])object;
                serializableArray = new Character[cArray.length];
                for (int i = 0; i < cArray.length; ++i) {
                    serializableArray[i] = new Character(cArray[i]);
                }
            } else if (clazz.toString().equals("float")) {
                float[] fArray = (float[])object;
                serializableArray = new Float[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    serializableArray[i] = new Float(fArray[i]);
                }
            } else if (clazz.toString().equals("boolean")) {
                boolean[] blArray = (boolean[])object;
                serializableArray = new Boolean[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    serializableArray[i] = new Boolean(blArray[i]);
                }
            }
            return serializableArray;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("value could not be converted");
        }
    }

    public static String cropFromEnd(String string, int n) {
        String string2 = string.substring(DataFormatter.getLineStart(string, DataFormatter.getLineCount(string) - n), string.length() - 1);
        return string2;
    }

    public static int getLineCount(String string) {
        int n = 0;
        int n2 = -1;
        int n3 = string.length();
        do {
            n2 = string.indexOf(10, n2 + 1);
            ++n;
        } while (n2 > -1 && n2 < n3);
        return n;
    }

    public static int getLineStart(String string, int n) {
        int n2 = 0;
        int n3 = -1;
        int n4 = string.length();
        while ((n3 = string.indexOf(10, n3 + 1)) > -1 && n3 < n4 && ++n2 < n) {
        }
        return n3;
    }

    public static String[] splitString(String string, String string2) {
        int n = -1;
        int n2 = 0;
        int n3 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            n = string.indexOf(string2, n2);
            arrayList.add(string.substring(n2, n));
            n2 = n + 1;
        } while (n > -1 && n < n3);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] splitStringByLines(String string) {
        int n = -1;
        int n2 = 0;
        int n3 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            if ((n = string.indexOf(10, n2)) == -1) {
                n = n3 - 1;
            }
            if (n >= 0 && n < n3 && n2 >= 0 && n2 < n3) {
                arrayList.add(string.substring(n2, n));
            }
            n2 = n + 1;
        } while (n > -1 && n < n3 - 1);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String unpackArray(Object object) {
        return DataFormatter.unpackArray(object, "", 0, false);
    }

    public static String unpackArray(Object object, String string) {
        return DataFormatter.unpackArray(object, string, 0, false);
    }

    public static String unpackArray(Object object, String string, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = object.getClass().getComponentType();
        stringBuffer.append("[Array of " + clazz + "], length = " + Array.getLength(object));
        Object[] objectArray = null;
        objectArray = clazz.isPrimitive() ? DataFormatter.convertPrimitiveArray(object) : (Object[])object;
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("\n" + string + " (" + i + ") " + DataFormatter.unpackReturnValue(objectArray[i], string + "  ", n + 1, bl));
        }
        return stringBuffer.toString();
    }

    public static String unpackReturnValue(Object object, String string, int n) {
        return DataFormatter.unpackReturnValue(object, string, n, false);
    }

    public static String unpackReturnValue(Object object, String string, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(500);
        try {
            if (object != null) {
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    stringBuffer.append(DataFormatter.unpackArray(object, string, n, bl));
                } else if (object instanceof String || object instanceof Number || object instanceof Boolean) {
                    stringBuffer.append(object.toString());
                } else {
                    if (n > MAX_RECURSION_LEVEL) {
                        return object.getClass() + " (Recursion level exceeded)";
                    }
                    stringBuffer.append(object.toString());
                    if (bl) {
                        Object object2;
                        int n2;
                        stringBuffer.append('\n');
                        stringBuffer.append(string);
                        stringBuffer.append("  (" + clazz.getName() + ")");
                        Field[] fieldArray = clazz.getFields();
                        for (n2 = 0; n2 < fieldArray.length; ++n2) {
                            if (Modifier.isStatic(fieldArray[n2].getModifiers()) || !Modifier.isPublic(fieldArray[n2].getModifiers())) continue;
                            object2 = fieldArray[n2];
                            stringBuffer.append('\n');
                            stringBuffer.append(string);
                            stringBuffer.append(((Field)object2).getName());
                            stringBuffer.append(": ");
                            if (((Field)object2).getName().equals("timeStamp") && ((Field)object2).getDeclaringClass().getName().equals("alma.ACSErr.Completion")) {
                                long l = UTCUtility.utcOmgToJava((long)((Field)object2).getLong(object));
                                stringBuffer.append(df.format(new Date(l)));
                                continue;
                            }
                            stringBuffer.append(DataFormatter.unpackReturnValue(((Field)object2).get(object), string + " ", n + 1, bl));
                        }
                        n2 = object instanceof Throwable;
                        if (n2 == 0) {
                            object2 = clazz.getMethods();
                            for (int i = 0; i < ((Method[])object2).length; ++i) {
                                Method method;
                                if (!Modifier.isPublic(object2[i].getModifiers()) || (method = object2[i]).getParameterTypes().length != 0 || !method.getReturnType().isPrimitive() && n >= 1 || method.getReturnType().toString().equals("void") || method.getName().startsWith("_") || method.getName().equals("hashCode") || method.getName().equals("clone") || method.getName().equals("getClass") || method.getName().equals("toString")) continue;
                                stringBuffer.append("\n" + string + "  |" + method.getName() + ": " + DataFormatter.unpackReturnValue(method.invoke(object, null), string + "  |", n + 1, bl));
                            }
                        }
                    }
                }
                return stringBuffer.toString();
            }
            return "null";
        }
        catch (Exception exception) {
            return stringBuffer + "\n" + string + "N/A";
        }
    }

    public static String unpackValues(String[] stringArray, Object[] objectArray) {
        return DataFormatter.unpackValues(stringArray, objectArray, ":");
    }

    public static String unpackValues(String[] stringArray, Object[] objectArray, String string) {
        return DataFormatter.unpackValues(stringArray, objectArray, string, false);
    }

    public static String unpackValues(String[] stringArray, Object[] objectArray, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("    ");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(DataFormatter.unpackReturnValue(objectArray[i], "      ", 0, bl));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

