/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.secure;

import javax.security.jacc.EJBMethodPermission;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.Initializable;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.secure.JACCPermissions;
import org.hibernate.secure.JACCSecurityListener;

public class JACCPreDeleteEventListener
implements PreDeleteEventListener,
Initializable,
JACCSecurityListener {
    private String contextID;

    public boolean onPreDelete(PreDeleteEvent event) {
        EJBMethodPermission deletePermission = new EJBMethodPermission(event.getPersister().getEntityName(), "delete", null, null);
        JACCPermissions.checkPermission(event.getEntity().getClass(), this.contextID, deletePermission);
        return false;
    }

    public void initialize(Configuration cfg) {
        this.contextID = cfg.getProperty("hibernate.jacc_context_id");
    }
}

