/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2;

import java.util.ArrayList;
import java.util.List;
import org.openarchitectureware.expression.AbstractExpressionsUsingWorkflowAdvice;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.xpand2.Generator;

public class GeneratorAdvice
extends AbstractExpressionsUsingWorkflowAdvice {
    private static final String COMPONENT_NAME = "Xpand Generator Advice";
    private List<String> advices = new ArrayList<String>();
    private List<String> extensionAdvices = new ArrayList<String>();
    private String fileEncoding;

    @Deprecated
    public void addAdvices(String advices) {
        this.advices.add(advices);
    }

    @Deprecated
    public void addExtensionAdvices(String extensionAdvices) {
        this.addExtensionAdvice(extensionAdvices);
    }

    public void addAdvice(String advice) {
        this.advices.add(advice);
    }

    public void addExtensionAdvice(String extensionAdvice) {
        this.extensionAdvices.add(extensionAdvice);
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.advices.isEmpty() && this.extensionAdvices.isEmpty()) {
            issues.addError("Neither 'advices' nor 'extensionAdvices' configured.");
        }
    }

    public void weave(WorkflowComponent c, Issues issues) {
        super.weave(c, issues);
        if (!(c instanceof Generator)) {
            issues.addError((WorkflowComponent)this, "advice target is not a Generator component.");
        } else {
            Generator gen = (Generator)c;
            for (String advice : this.advices) {
                gen.addAdvice(advice);
            }
            for (String advice : this.extensionAdvices) {
                gen.addExtensionAdvice(advice);
            }
            if (this.fileEncoding != null) {
                gen.setFileEncoding(this.fileEncoding);
            }
        }
    }

    public String getLogMessage() {
        return "extension-advices: " + this.buildList(this.extensionAdvices) + "   template-advices: " + this.buildList(this.advices);
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

