/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openarchitectureware.compiler.runtime.Callable;
import org.openarchitectureware.compiler.runtime.util.ParamTypeListComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolymorphicResolver {
    private static final Comparator<Callable> _candidateComparator = new Comparator<Callable>(){

        @Override
        public int compare(Callable m1, Callable m2) {
            List<Class<?>> pt1 = Arrays.asList(m1.getParamTypes());
            List<Class<?>> pt2 = Arrays.asList(m2.getParamTypes());
            return _typeListComparator.compare(pt1, pt2);
        }
    };
    public static final Comparator<List<Class<?>>> _typeListComparator = new ParamTypeListComparator();

    public final Callable getMethod(String name, List<Callable> candidates, Class<?>[] paramTypes) {
        return this.getMethod(name, candidates, Arrays.asList(paramTypes));
    }

    public final Callable getMethod(String name, List<Callable> candidatesRaw, List<Class<?>> paramTypes) {
        ArrayList<Callable> candidates = new ArrayList<Callable>();
        for (Callable c : candidatesRaw) {
            boolean matchingParamTypes = true;
            int i = 0;
            while (i < paramTypes.size()) {
                if (!Void.TYPE.equals(paramTypes.get(i)) && !c.getParamTypes()[i].isAssignableFrom(paramTypes.get(i))) {
                    matchingParamTypes = false;
                }
                ++i;
            }
            if (!matchingParamTypes) continue;
            candidates.add(c);
        }
        if (candidates.size() == 1) {
            return (Callable)candidates.get(0);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        Collections.sort(candidates, _candidateComparator);
        if (_candidateComparator.compare((Callable)candidates.get(1), (Callable)candidates.get(0)) > 0) {
            return (Callable)candidates.get(0);
        }
        throw new IllegalArgumentException("ambiguous operation - no unique operation " + name + " for parameter types " + paramTypes);
    }
}

