/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto.perf;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.james.mime4j.ContentHandler;
import org.apache.james.mime4j.MimeStreamParser;
import org.buni.panto.MimeParser;
import org.buni.panto.ParseException;
import org.buni.panto.perf.Mime4JContentHandler;
import org.buni.panto.perf.PantoContentHandler;

public class TestPerformance
extends TestCase {
    static final int size = 20;

    private void timeMime4J(String file) throws IOException {
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < 20) {
            BufferedInputStream fIn = new BufferedInputStream(new FileInputStream(file));
            MimeStreamParser p = new MimeStreamParser();
            p.setContentHandler((ContentHandler)new Mime4JContentHandler());
            p.parse((InputStream)fIn);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        System.out.printf("Mime4J Time: %d, iterations %d\n", t1 - t0, 20);
    }

    private void timePanto(String file) throws IOException, ParseException {
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < 20) {
            FileInputStream fIn = new FileInputStream(file);
            MimeParser p = new MimeParser();
            p.setContentHandler(new PantoContentHandler());
            p.parse(fIn);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        System.out.printf("Panto Time: %d, iterations %d\n", t1 - t0, 20);
    }

    public void testLargePanto() throws Exception {
        this.timePanto("resources/test2.eml");
    }

    public void testLargeMime4J() throws Exception {
        this.timeMime4J("resources/test2.eml");
    }

    public void testNested() throws Exception {
        this.timeMime4J("m-attachment-image.msg");
        this.timePanto("m-attachment-image.msg");
    }

    public static int count(InputStream in) throws IOException {
        byte[] b = new byte[8192];
        int read = 0;
        int numRead = 0;
        while ((numRead = in.read(b)) != -1) {
            read += numRead;
        }
        return read;
    }
}

