/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import junit.framework.TestCase;
import org.buni.panto.BoundaryInputStream;
import org.buni.panto.MimeParser;
import org.buni.panto.SimpleBoyerMoore;

public class TestSimpleBoyerMoore
extends TestCase {
    public void test01() {
        byte[] pattern = new byte[]{97, 98, 99};
        byte[] data = new byte[]{120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 97, 98};
        SimpleBoyerMoore sbm = new SimpleBoyerMoore(pattern);
        System.out.println(sbm.patternSearch(data, 0, data.length));
    }

    public void test02() {
        byte[] pattern = new byte[]{97, 98, 99};
        byte[] data = new byte[]{120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 97, 98, 99};
        SimpleBoyerMoore sbm = new SimpleBoyerMoore(pattern);
        System.out.println(sbm.patternSearch(data, 5, data.length));
    }

    public void test02a() {
        byte[] pattern = new byte[]{97, 98, 99};
        byte[] data = new byte[]{120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 97, 98, 99};
        SimpleBoyerMoore sbm = new SimpleBoyerMoore(pattern);
        TestSimpleBoyerMoore.assertEquals((int)11, (int)sbm.patternSearch(data, 0, data.length));
    }

    public void test03() {
        byte[] pattern = new byte[]{97, 98, 99};
        byte[] data = new byte[]{120, 97, 98, 99, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120};
        SimpleBoyerMoore sbm = new SimpleBoyerMoore(pattern);
        System.out.println(sbm.patternSearch(data, 0, data.length));
    }

    public void testStream01() throws Exception {
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < 20) {
            this.readBoyerMoore();
            ++i;
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Time: " + (t1 - t0));
    }

    public void testParser() throws Exception {
        FileInputStream fIn = new FileInputStream("mail/mailtest/etc/layout/test5.msg");
        MimeParser p = new MimeParser();
        p.parse(fIn);
    }

    private void readBoyerMoore() throws IOException {
        FileInputStream fIn = new FileInputStream("mail/mailtest/etc/layout/test5.msg");
        int bufSize = 2048;
        PushbackInputStream pIn = new PushbackInputStream(fIn, bufSize);
        byte[] pattern = "--=-k+vuDacfryJTg0XDCrrz".getBytes();
        byte[] data = new byte[bufSize];
        BoundaryInputStream bIn = new BoundaryInputStream(pIn, pattern, bufSize);
        while (((InputStream)bIn).read(data) != -1) {
        }
        bIn = new BoundaryInputStream(pIn, pattern, bufSize);
        while (((InputStream)bIn).read(data) != -1) {
        }
        bIn = new BoundaryInputStream(pIn, pattern, bufSize);
        while (((InputStream)bIn).read(data) != -1) {
        }
    }
}

