/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.IOException;
import java.io.InputStream;
import org.buni.panto.BodyHeader;
import org.buni.panto.ContentHandler;
import org.buni.panto.IOUtil;

public class PantoContentHandler
implements ContentHandler {
    StringBuilder sb = new StringBuilder();

    public void body(BodyHeader header, InputStream in) throws IOException {
        String t = String.valueOf(header.getContentType().getType()) + "/" + header.getContentType().getSubType();
        this.sb.append(String.format("body:{contentType:\"%s\";size:%d;};", t, this.count(in)));
    }

    public long count(InputStream in) throws IOException {
        long i = IOUtil.count(in);
        return i;
    }

    public void endBodyPart() {
        this.sb.append("};");
    }

    public void endHeader() {
        this.sb.append("];");
    }

    public void endMessage() {
        this.sb.append("};");
    }

    public void endMultipart() {
        this.sb.append("};");
    }

    public void epilogue(InputStream in) throws IOException {
        this.sb.append(String.format("epilogue:{size:%d;};", IOUtil.count(in)));
    }

    public void field(String fieldData) {
        this.sb.append(fieldData);
        this.sb.append(";");
    }

    public void preamble(InputStream in) throws IOException {
        this.sb.append(String.format("preamble:{size:%d;};", this.count(in)));
    }

    public void startBodyPart() {
        this.sb.append("bodyPart:{");
    }

    public void startHeader() {
        this.sb.append("header:[");
    }

    public void startMessage() {
        this.sb.append("message:{");
    }

    public void startMultipart(BodyHeader header) {
        System.out.println("** Boundary = " + header.getContentType().getBoundary());
        String t = String.valueOf(header.getContentType().getType()) + "/" + header.getContentType().getSubType();
        String b = header.getContentType().getBoundary();
        this.sb.append(String.format("multipart:{contentType:\"%s\";boundary:\"%s\";", t, b));
    }

    public String toString() {
        return this.sb.toString();
    }
}

