/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.BodyDescriptor;
import org.apache.james.mime4j.ContentHandler;
import org.buni.panto.IOUtil;

public class Mime4JContentHandler
implements ContentHandler {
    StringBuilder sb = new StringBuilder();

    public void body(BodyDescriptor bd, InputStream in) throws IOException {
        this.sb.append(String.format("body:{contentType:\"%s\";size:%d;};", bd.getMimeType(), IOUtil.count(in)));
    }

    public void startMultipart(BodyDescriptor arg0) {
        String t = arg0.getMimeType();
        String b = arg0.getBoundary();
        this.sb.append(String.format("multipart:{contentType:\"%s\";boundary:\"%s\";", t, b));
    }

    public String toString() {
        return this.sb.toString();
    }

    public void endBodyPart() {
        this.sb.append("};");
    }

    public void endHeader() {
        this.sb.append("];");
    }

    public void endMessage() {
        this.sb.append("};");
    }

    public void endMultipart() {
        this.sb.append("};");
    }

    public void epilogue(InputStream in) throws IOException {
        this.sb.append(String.format("epilogue:{size:%d;};", IOUtil.count(in)));
    }

    public void field(String s) {
        System.out.println("Field: " + s);
        this.sb.append(s);
        this.sb.append(";");
    }

    public void preamble(InputStream in) throws IOException {
        this.sb.append(String.format("preamble:{size:%d;};", IOUtil.count(in)));
    }

    public void raw(InputStream arg0) throws IOException {
    }

    public void startBodyPart() {
        this.sb.append("bodyPart:{");
    }

    public void startHeader() {
        this.sb.append("header:[");
    }

    public void startMessage() {
        this.sb.append("message:{");
    }
}

