/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.buni.panto.ContentHeader;
import org.buni.panto.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentType
extends ContentHeader {
    private static final Pattern PATTERN = Pattern.compile("Content-Type:(.*)", 34);
    public static final ContentType DEFAULT = new ContentType();
    public static final ContentType DIGEST_DEFAULT = new ContentType("message", "rfc822");

    public ContentType(String type, String subType, Map<String, String> parameters) {
        super(type, subType, parameters);
    }

    public ContentType() {
        this("text", "plain");
        this.getParameters().put("charset", "us-ascii");
    }

    public ContentType(String type, String subType) {
        this(type, subType, new HashMap<String, String>(0));
    }

    protected ContentType(String line) throws ParseException {
        super(line);
    }

    public static ContentType parse(String line) throws ParseException {
        Matcher m = PATTERN.matcher(line);
        if (m.matches() && m.groupCount() == 1) {
            return new ContentType(m.group(1));
        }
        return null;
    }

    public boolean isMulitpart() {
        return this.getType().toLowerCase().equals("multipart") && this.getBoundary() != null;
    }

    public boolean isMessage() {
        return this.getType().toLowerCase().equals("message");
    }

    public String getBoundary() {
        return this.getParameters().get("boundary");
    }

    public byte[] getPattern(boolean includeNL) throws UnsupportedEncodingException {
        String boundary = this.getBoundary();
        if (boundary != null) {
            if (includeNL) {
                return ("\r\n--" + boundary).getBytes("US-ASCII");
            }
            return ("--" + boundary).getBytes("US-ASCII");
        }
        return null;
    }

    public ContentType getDefault() {
        if ("multipart".equals(this.getType()) && "digest".equals(this.getSubType())) {
            return DIGEST_DEFAULT;
        }
        return DEFAULT;
    }

    @Override
    public String getSubType() {
        String subType = super.getSubType();
        if (subType == null) {
            String type = this.getType();
            subType = "message".equals(type) ? "rfc822" : "plain";
        }
        return subType;
    }
}

