/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.buni.panto.SimpleBoyerMoore;

public class BoundaryInputStream
extends InputStream {
    private final PushbackInputStream in;
    private final SimpleBoyerMoore sbm;
    private final byte[] buffer;
    private int pos;
    private int limit;
    private int capacity;
    private boolean eof = false;
    private byte[] option;

    public BoundaryInputStream(PushbackInputStream in, byte[] pattern, int size) {
        this(in, pattern, new byte[0], size);
    }

    public BoundaryInputStream(PushbackInputStream in, byte[] pattern, byte[] option, int size) {
        this.in = in;
        this.buffer = new byte[size + pattern.length + option.length];
        this.pos = 0;
        this.limit = 0;
        this.sbm = new SimpleBoyerMoore(pattern);
        this.option = option;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.eof && this.limit <= this.pos) {
            return -1;
        }
        int numBytes = 0;
        do {
            if (this.limit <= this.pos) {
                this.eof = this.loadBuffer();
            }
            if (this.limit - this.pos <= 0) continue;
            int toRead = Math.min(len - numBytes, this.limit - this.pos);
            System.arraycopy(this.buffer, this.pos, buf, numBytes + off, toRead);
            this.pos += toRead;
            numBytes += toRead;
        } while (!this.eof && numBytes < len);
        return numBytes;
    }

    private boolean loadBuffer() throws IOException {
        int tailLength = this.capacity - this.pos;
        System.arraycopy(this.buffer, this.pos, this.buffer, 0, tailLength);
        this.capacity = tailLength;
        this.pos = 0;
        int numBytes = this.in.read(this.buffer, tailLength, this.buffer.length - tailLength);
        if (numBytes == -1) {
            this.limit = tailLength;
            return true;
        }
        this.capacity += numBytes;
        int idx = this.sbm.patternSearch(this.buffer, 0, this.capacity);
        if (idx == -1) {
            this.limit = this.capacity - (this.sbm.length() + this.option.length);
            return false;
        }
        this.limit = idx;
        int i = this.option.length - 1;
        while (i >= 0 && this.limit > this.pos) {
            if (this.option[i] != this.buffer[this.limit - 1]) break;
            --this.limit;
            --i;
        }
        this.in.unread(this.buffer, idx + this.sbm.length(), this.capacity - (idx + this.sbm.length()));
        return true;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int num = this.read(b);
        if (num == -1 || num == 0) {
            return -1;
        }
        return b[0];
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }
}

