/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.timer;

import ahc.util.timer.BigIntegerStopWatchCycle;
import ahc.util.timer.LongStopWatchCycle;
import java.text.NumberFormat;

abstract class StopWatchCycle {
    private static final long NO_TIME = -1L;
    private long _startTime = -1L;
    private boolean _lostFirstCycle = false;
    private int _minTime = Integer.MAX_VALUE;
    private int _maxTime = Integer.MIN_VALUE;
    private final String _name;
    private final NumberFormat _numberFormat;
    private int _numCycles = 0;

    public static StopWatchCycle create(String name, NumberFormat numberFormat, boolean hasUnlimitedPrecision) {
        return hasUnlimitedPrecision ? new BigIntegerStopWatchCycle(name, numberFormat) : new LongStopWatchCycle(name, numberFormat);
    }

    protected StopWatchCycle(NumberFormat numberFormat, String name) {
        this._numberFormat = numberFormat;
        this._name = name;
    }

    public void begin() {
        this._startTime = System.currentTimeMillis();
    }

    public void end() {
        if (this._startTime == -1L) {
            this._lostFirstCycle = true;
        } else {
            int cycleTime = (int)(System.currentTimeMillis() - this._startTime);
            this.rememberCycleTime(cycleTime);
            ++this._numCycles;
            if (cycleTime > this._maxTime) {
                this._maxTime = cycleTime;
            }
            if (cycleTime < this._minTime) {
                this._minTime = cycleTime;
            }
        }
        this.begin();
    }

    protected abstract void rememberCycleTime(int var1);

    protected abstract int averageSquareSum();

    protected abstract int average();

    protected int numCycles() {
        return this._numCycles;
    }

    private int stdDeviation() {
        if (this.numCycles() < 1) {
            return 0;
        }
        long rawResult = this.averageSquareSum() - this.square(this.average());
        return (int)Math.sqrt(rawResult);
    }

    protected int square(int n) {
        return n * n;
    }

    private String format(int time) {
        return this._numberFormat.format(time) + "ms";
    }

    public String toString() {
        StringBuffer result = new StringBuffer("cycle " + this._name + ": ");
        if (this._lostFirstCycle) {
            result.append("(first cycle was lost because beginCycle() was not called) ");
        }
        result.append("" + this.numCycles() + " cycles");
        if (this.numCycles() > 0) {
            result.append(", min=" + this.format(this._minTime) + ", max=" + this.format(this._maxTime) + ", avg=" + this.format(this.average()) + ", std.dev=" + this.format(this.stdDeviation()));
        }
        return result.toString();
    }
}

