/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string.sprintf;

class FlagParser {
    private final boolean _hasThousandsSeparator;
    private final boolean _isLeftJustified;
    private final boolean _hasPositiveSign;
    private final boolean _hasSpaceSign;
    private final boolean _hasZeroPadding;
    private final int _minWidth;
    private final int _precision;
    private String _pattern;
    private int _curOffs = 1;

    public FlagParser(String pattern) {
        this._pattern = pattern;
        this._hasThousandsSeparator = this.parseBoolean('\'');
        this._isLeftJustified = this.parseBoolean('-');
        this._hasPositiveSign = this.parseBoolean('+');
        this._hasSpaceSign = this.parseBoolean(' ');
        this._hasZeroPadding = this.parseBoolean('0');
        this._minWidth = this.parseInt();
        this._precision = this.parseBoolean('.') ? this.parseInt() : -1;
    }

    private int parseInt() {
        int result = 0;
        while (this._curOffs < this._pattern.length() && Character.isDigit(this._pattern.charAt(this._curOffs))) {
            result = result * 10 + this._pattern.charAt(this._curOffs++) - 48;
        }
        return result;
    }

    private boolean parseBoolean(char ch) {
        if (this._curOffs >= this._pattern.length() || this._pattern.charAt(this._curOffs) != ch) {
            return false;
        }
        ++this._curOffs;
        return true;
    }

    public int indConversionSpecifier() {
        return this._curOffs;
    }

    public boolean hasThousandsSeparator() {
        return this._hasThousandsSeparator;
    }

    public boolean isLeftJustified() {
        return this._isLeftJustified;
    }

    public boolean hasPositiveSign() {
        return this._hasPositiveSign;
    }

    public boolean hasSpaceSign() {
        return this._hasSpaceSign;
    }

    public boolean hasZeroPadding() {
        return this._hasZeroPadding;
    }

    public int minWidth() {
        return this._minWidth;
    }

    public int precision() {
        return this._precision;
    }
}

