/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string;

import ahc.collection.ForwardIterator;
import ahc.collection.List;
import ahc.collection.ListHelper;
import java.util.NoSuchElementException;

public class StringSplitter
implements ForwardIterator {
    private final boolean _mergeDelims;
    private final String _str;
    private String _delims;
    private boolean _hasEmptyPostToken = false;
    private boolean _preFirst = true;
    private int _curPos = 0;
    private char _maxDelim = '\u0000';
    private String _curElement = null;
    private int _curIndex = -1;
    private boolean _isFinished = false;

    private StringSplitter(boolean mergeDelims, String str, String delims, boolean isBefore, boolean returnDelims) {
        if (returnDelims) {
            throw new UnsupportedOperationException();
        }
        this._mergeDelims = mergeDelims;
        this._str = str;
        this.setDelims(delims);
        if (!isBefore) {
            this.next();
        }
    }

    public static StringSplitter createSplitter(boolean mergeDelims, String str, String delim, boolean isBefore, boolean returnDelims) {
        return new StringSplitter(mergeDelims, str, delim, isBefore, returnDelims);
    }

    public static StringSplitter createTabberBefore(String str, String delim) {
        return StringSplitter.createSplitter(false, str, delim, true, false);
    }

    public static StringSplitter createTabberBegin(String str, String delim) {
        return StringSplitter.createSplitter(false, str, delim, false, false);
    }

    public static StringSplitter createTokenizerBefore(String str, String delim, boolean returnDelims) {
        return StringSplitter.createSplitter(true, str, delim, true, returnDelims);
    }

    public static StringSplitter createTokenizerBegin(String str, String delim, boolean returnDelims) {
        return StringSplitter.createSplitter(true, str, delim, false, returnDelims);
    }

    public static StringSplitter createTokenizerBefore(String str, String delim) {
        return StringSplitter.createTokenizerBefore(str, delim, false);
    }

    public static StringSplitter createTokenizerBegin(String str, String delim) {
        return StringSplitter.createTokenizerBegin(str, delim, false);
    }

    public static StringSplitter createTokenizerBefore(String str) {
        return StringSplitter.createTokenizerBefore(str, " \t\n\r\f");
    }

    public static StringSplitter createTokenizerBegin(String str) {
        return StringSplitter.createTokenizerBegin(str, " \t\n\r\f");
    }

    public List asList() {
        List result = ListHelper.createList();
        if (!this.hasCurrent()) {
            this.next();
        }
        while (this.hasCurrent()) {
            result.add(this.current());
            this.next();
        }
        return result;
    }

    public boolean hasMoreTokens() {
        if (this._mergeDelims) {
            for (int i = this._curPos; i < this._str.length(); ++i) {
                if (this.isDelimiter(i)) continue;
                return true;
            }
            return false;
        }
        if (this._hasEmptyPostToken) {
            return true;
        }
        return this._curPos < this._str.length();
    }

    public String nextToken() {
        if (this._isFinished) {
            return null;
        }
        try {
            String result;
            this._curElement = result = this._nextToken();
            ++this._curIndex;
            return result;
        }
        catch (NoSuchElementException e) {
            this._isFinished = true;
            this._curElement = null;
            return null;
        }
    }

    private String _nextToken() {
        if (!this._mergeDelims && this._preFirst && this.isDelimiter()) {
            this._preFirst = false;
            return "";
        }
        this._preFirst = false;
        this.swallowDelimiters();
        if (this._hasEmptyPostToken) {
            this._hasEmptyPostToken = false;
            return "";
        }
        this.checkEnd();
        int start = this._curPos;
        return this._str.substring(start, this.endOfToken());
    }

    private void swallowDelimiters() {
        if (this._curPos >= this._str.length()) {
            return;
        }
        if (this.isDelimiter()) {
            if (this._curPos < this._str.length()) {
                ++this._curPos;
            }
            if (this._curPos == this._str.length() && !this._mergeDelims) {
                this._hasEmptyPostToken = true;
            }
        }
        if (!this._mergeDelims) {
            return;
        }
        while (this._curPos < this._str.length() && this.isDelimiter()) {
            ++this._curPos;
        }
    }

    private int endOfToken() {
        while (this._curPos < this._str.length() && !this.isDelimiter()) {
            ++this._curPos;
        }
        return this._curPos;
    }

    private void checkEnd() {
        if (this._curPos >= this._str.length()) {
            throw new NoSuchElementException();
        }
    }

    private boolean isDelimiter() {
        return this.isDelimiter(this._curPos);
    }

    private boolean isDelimiter(int pos) {
        char curChar = this._str.charAt(pos);
        if (curChar > this._maxDelim) {
            return false;
        }
        for (int i = 0; i < this._delims.length(); ++i) {
            if (curChar != this._delims.charAt(i)) continue;
            return true;
        }
        return false;
    }

    private void setDelims(String delims) {
        this._delims = delims;
        for (int i = 0; i < delims.length(); ++i) {
            if (delims.charAt(i) <= this._maxDelim) continue;
            this._maxDelim = delims.charAt(i);
        }
    }

    public String nextToken(String delims) {
        this.setDelims(delims);
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public boolean hasCurrent() {
        return this._curElement != null;
    }

    public Object current() {
        return this._curElement;
    }

    public int currentIndex() {
        return this._curIndex;
    }

    public Object next(int n) {
        for (int i = 0; i < n - 1; ++i) {
            this.nextElement();
        }
        return this.nextElement();
    }

    public boolean replace(Object o) {
        throw new UnsupportedOperationException("StringSplitter does not allow modifiactions");
    }

    public boolean hasNext() {
        return this.hasMoreElements();
    }

    public Object next() {
        return this.nextElement();
    }

    public void remove() {
        throw new UnsupportedOperationException("StringSplitter does not allow modifiactions");
    }
}

