/*
 * Decompiled with CFR 0.152.
 */
package ahc.generic.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class AccessorHelper {
    public static Method getSetMethod(Class firstClass, List getMethods, String accessPath, Class paramType) throws NoSuchMethodException {
        Class cls = AccessorHelper.getLastClass(firstClass, getMethods);
        String attName = AccessorHelper.getAttName(accessPath);
        String methodName = AccessorHelper.asSetMethod(attName);
        Method[] allMethods = cls.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method curMethod = allMethods[i];
            if (!curMethod.getName().equals(methodName) || curMethod.getParameterTypes().length != 1 || paramType != null && !curMethod.getParameterTypes()[0].isAssignableFrom(paramType)) continue;
            return curMethod;
        }
        throw new NoSuchMethodException(methodName);
    }

    private static Class getLastClass(Class firstClass, List getMethods) {
        Class<?> cls = firstClass;
        if (getMethods.size() > 0) {
            Method lastMethod = (Method)getMethods.get(getMethods.size() - 1);
            cls = lastMethod.getReturnType();
        }
        return cls;
    }

    private static String getAttName(String accessPath) {
        int lastSeparator = accessPath.lastIndexOf("/");
        String attName = lastSeparator == -1 ? accessPath : accessPath.substring(lastSeparator + 1);
        return attName;
    }

    public static List getGetMethodsForSet(Class firstClass, String accessPath) throws NoSuchMethodException {
        int lastSeparator = accessPath.lastIndexOf("/");
        if (lastSeparator == -1) {
            return new ArrayList();
        }
        return AccessorHelper.getGetMethods(firstClass, accessPath.substring(0, lastSeparator));
    }

    public static List getGetMethods(Class firstClass, String accessPath) throws NoSuchMethodException {
        ArrayList<Method> result = new ArrayList<Method>();
        StringTokenizer tokenizer = new StringTokenizer(accessPath, "/");
        Class<?> curClass = firstClass;
        while (tokenizer.hasMoreTokens()) {
            String curElement = tokenizer.nextToken();
            String curMethodName = AccessorHelper.asGetMethod(curElement);
            Method curMethod = curClass.getMethod(curMethodName, new Class[0]);
            result.add(curMethod);
            curClass = curMethod.getReturnType();
        }
        return result;
    }

    public static Object invokeGetMethods(Object obj, List methods) {
        Object result = obj;
        try {
            Iterator iter = methods.iterator();
            while (iter.hasNext()) {
                Method curMethod = (Method)iter.next();
                result = curMethod.invoke(result, new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.toString());
        }
        return result;
    }

    private static String asSetMethod(String attName) {
        return "set" + attName.substring(0, 1).toUpperCase() + attName.substring(1);
    }

    private static String asGetMethod(String attName) {
        return "get" + attName.substring(0, 1).toUpperCase() + attName.substring(1);
    }
}

