/*
 * Decompiled with CFR 0.152.
 */
package ahc.generic;

import ahc.collection.DoubleKeyCache;
import ahc.collection.TripleKeyCache;
import ahc.generic.AttributeSetter;
import ahc.generic.util.AccessorHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

class CachingSetter
implements AttributeSetter {
    private final DoubleKeyCache _getterSetterCache = new DoubleKeyCache(){

        protected Object createNew(Object key1, Object key2) {
            try {
                Class firstClass = (Class)key1;
                String accessPath = (String)key2;
                return AccessorHelper.getGetMethodsForSet(firstClass, accessPath);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("no such method " + e);
            }
        }
    };
    private final TripleKeyCache _setterCache = new TripleKeyCache(){

        protected Object createNew(Object key1, Object key2, Object key3) {
            try {
                Class firstClass = (Class)key1;
                String accessPath = (String)key2;
                Class paramType = (Class)key3;
                return AccessorHelper.getSetMethod(firstClass, (List)CachingSetter.this._getterSetterCache.get(firstClass, accessPath), accessPath, paramType);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("no such method " + e);
            }
        }
    };

    CachingSetter() {
    }

    public void set(Object obj, String accessPath, Object value) {
        try {
            List getMethods = (List)this._getterSetterCache.get(obj.getClass(), accessPath);
            Class<?> paramType = value != null ? value.getClass() : null;
            Method setMethod = (Method)this._setterCache.get(obj.getClass(), accessPath, paramType);
            Object lastObject = AccessorHelper.invokeGetMethods(obj, getMethods);
            setMethod.invoke(lastObject, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.toString());
        }
    }
}

