/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.GenericCollection;
import ahc.collection.List;
import ahc.collection.SynchronizedList;
import ahc.collection.access.AccessStrategy;
import ahc.collection.access.GenericAccessStrategy;
import ahc.collection.access.TransparentAccessStrategy;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.equality.EqualsEqualityStrategy;
import ahc.collection.equality.IdentityEqualityStrategy;
import ahc.collection.store.ArrayStore;
import ahc.collection.store.DlinkedStore;
import ahc.collection.store.Store;
import java.util.Collection;
import java.util.Comparator;

public class ListHelper {
    public static final EqualityStrategy EQ_EQUALS = new EqualsEqualityStrategy();
    public static final EqualityStrategy EQ_IDENTITY = new IdentityEqualityStrategy();
    public static final AccessStrategy ACCESS_TRANSPARENT = TransparentAccessStrategy.INSTANCE;
    public static final List EMPTY = ListHelper.createList().immutableListView();

    public static List synchronizedList(List list) {
        return SynchronizedList.create(list);
    }

    public static List createList() {
        return ListHelper.createArrayList();
    }

    public static List createList(Collection initValues) {
        return ListHelper.initialize(ListHelper.createArrayList(), initValues);
    }

    public static List createList(Object[] initValues) {
        return ListHelper.initialize(ListHelper.createArrayList(), initValues);
    }

    private static List initialize(List list, Collection initValues) {
        list.addAll(initValues);
        return list;
    }

    private static List initialize(List list, Object[] initValues) {
        if (initValues != null) {
            for (int i = 0; i < initValues.length; ++i) {
                list.add(initValues[i]);
            }
        }
        return list;
    }

    public static List createArrayList() {
        return ListHelper.createArrayList(EQ_EQUALS, ACCESS_TRANSPARENT);
    }

    public static List createArrayList(Collection initValues) {
        return ListHelper.initialize(ListHelper.createArrayList(EQ_EQUALS, ACCESS_TRANSPARENT), initValues);
    }

    public static List createArrayList(Object[] initValues) {
        return ListHelper.initialize(ListHelper.createArrayList(EQ_EQUALS, ACCESS_TRANSPARENT), initValues);
    }

    public static List createArrayList(int initialSize) {
        return ListHelper.createArrayList(EQ_EQUALS, ACCESS_TRANSPARENT, initialSize);
    }

    public static List createArrayList(Comparator comp) {
        return ListHelper.createArrayList(comp, false);
    }

    public static List createArrayList(Comparator comp, int initialSize) {
        return ListHelper.createArrayList(comp, false, initialSize);
    }

    public static List createArrayList(Comparator comp, boolean ensureUniqueness) {
        return ListHelper.createArrayList(EQ_EQUALS, GenericAccessStrategy.create(comp, ensureUniqueness));
    }

    public static List createArrayList(Comparator comp, boolean ensureUniqueness, int initialSize) {
        return ListHelper.createArrayList(EQ_EQUALS, GenericAccessStrategy.create(comp, ensureUniqueness), initialSize);
    }

    public static List createArrayList(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return ListHelper.createList(new ArrayStore(eqStrat), accessStrat);
    }

    public static List createArrayList(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize) {
        return ListHelper.createList(new ArrayStore(eqStrat, initialSize), accessStrat);
    }

    public static List createDlinkedList() {
        return ListHelper.createDlinkedList(EQ_EQUALS, ACCESS_TRANSPARENT);
    }

    public static List createDlinkedList(Collection initValues) {
        return ListHelper.initialize(ListHelper.createDlinkedList(EQ_EQUALS, ACCESS_TRANSPARENT), initValues);
    }

    public static List createDlinkedList(Object[] initValues) {
        return ListHelper.initialize(ListHelper.createDlinkedList(EQ_EQUALS, ACCESS_TRANSPARENT), initValues);
    }

    public static List createDlinkedList(Comparator comp) {
        return ListHelper.createDlinkedList(comp, false);
    }

    public static List createDlinkedList(Comparator comp, boolean ensureUniqueness) {
        return ListHelper.createDlinkedList(EQ_EQUALS, GenericAccessStrategy.create(comp, ensureUniqueness));
    }

    public static List createDlinkedList(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return ListHelper.createList(new DlinkedStore(eqStrat), accessStrat);
    }

    public static List createList(Store store, AccessStrategy accessStrategy) {
        return new GenericCollection(store, accessStrategy);
    }
}

