/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.Iterator;
import ahc.collection.Stack;
import ahc.collection.access.AccessStrategy;
import ahc.collection.access.TransparentAccessStrategy;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.equality.EqualsEqualityStrategy;
import ahc.collection.store.ArrayStore;
import ahc.collection.store.Store;
import java.util.EmptyStackException;

public class GenericStack
implements Stack {
    private static final EqualityStrategy _eqStrat = new EqualsEqualityStrategy();
    private static final AccessStrategy _transparentAccess = TransparentAccessStrategy.INSTANCE;
    private final Store _store;
    private final AccessStrategy _accessStrategy;

    public GenericStack(Store store, AccessStrategy accessStrategy) {
        if (!store.preservesOrdering()) {
            throw new IllegalArgumentException("The store for a stack must preserve element ordering");
        }
        this._store = store;
        this._accessStrategy = accessStrategy;
    }

    public GenericStack(int initialSize) {
        this._store = new ArrayStore(_eqStrat, initialSize);
        this._accessStrategy = _transparentAccess;
    }

    public GenericStack() {
        this._store = new ArrayStore(_eqStrat);
        this._accessStrategy = _transparentAccess;
    }

    public void push(Object o) {
        this._accessStrategy.add(this._store, o);
    }

    public Object pop() {
        if (this.size() < 1) {
            throw new EmptyStackException();
        }
        Iterator iter = this._accessStrategy.end(this._store);
        Object result = iter.current();
        iter.remove();
        return result;
    }

    public Object peek() {
        return this._accessStrategy.end(this._store).current();
    }

    public boolean isEmpty() {
        return this._store.isEmpty();
    }

    public int size() {
        return this._store.size();
    }

    public void clear() {
        this._store.clear();
    }

    public Object pop(int n) {
        if (this.size() < n) {
            throw new EmptyStackException();
        }
        Object result = null;
        for (int i = 0; i < n; ++i) {
            result = this.pop();
        }
        return result;
    }

    public Object peek(int n) {
        Iterator iter = this._accessStrategy.end(this._store);
        iter.previous(n);
        return iter.current();
    }

    public Stack cloneEmpty() {
        return new GenericStack(this._store.cloneEmpty(), this._accessStrategy);
    }

    public Object clone() {
        return new GenericStack((Store)this._store.clone(), this._accessStrategy);
    }
}

