/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.util.uml2ecore;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.openarchitectureware.workflow.ConfigurationException;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uml2EcoreXmiWriter
extends AbstractWorkflowComponent {
    private static final String COMPONENT_NAME = "UML2Ecore XMI Writer";
    private String inputSlot = "default";
    private String outputPath;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void setInputSlot(String inputSlot) {
        this.inputSlot = inputSlot;
    }

    public String getLogMessage() {
        return "slot " + this.inputSlot;
    }

    public void setOutputPath(String path) {
        this.outputPath = path;
    }

    public void checkConfiguration(Issues issues) {
    }

    public void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        Object slotContent = ctx.get(this.inputSlot);
        if (slotContent == null) {
            issues.addError((WorkflowComponent)this, "slot '" + this.inputSlot + "' is empty.");
            return;
        }
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl rsImpl = new ResourceSetImpl();
        XmiWriterURIConverter uriConverter = new XmiWriterURIConverter(this.outputPath);
        rsImpl.setURIConverter((URIConverter)uriConverter);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ArrayList<String> resourceNames = new ArrayList<String>();
        if (slotContent instanceof List) {
            List list = (List)slotContent;
            for (Object object : list) {
                if (object instanceof EObject) {
                    this.createResource(rsImpl, uriConverter, (EObject)object, resources, resourceNames);
                    continue;
                }
                issues.addError((WorkflowComponent)this, "slot '" + this.inputSlot + "' contains non-EObject elements in the list!", object);
            }
        } else if (slotContent instanceof EObject) {
            EObject model = (EObject)slotContent;
            this.createResource(rsImpl, uriConverter, model, resources, resourceNames);
        } else {
            issues.addError((WorkflowComponent)this, "slot '" + this.inputSlot + "' neither contains an EList nor an EObject", slotContent);
            return;
        }
        int i = 0;
        while (i < resources.size()) {
            Resource res = (Resource)resources.get(i);
            String name = (String)resourceNames.get(i);
            try {
                res.save(null);
                this.removeAbsoluteFileRefs(uriConverter, res, name);
            }
            catch (IOException e) {
                throw new ConfigurationException((Throwable)e);
            }
            ++i;
        }
    }

    private void createResource(ResourceSetImpl rsImpl, XmiWriterURIConverter uriConverter, EObject model, List<Resource> resources, List<String> resourceNames) {
        String filename = String.valueOf(this.getName(model)) + ".ecore";
        URI fileURI = URI.createURI((String)filename);
        Resource r = rsImpl.createResource(fileURI);
        this.log.info((Object)("writing to '" + filename + "': " + model.eClass().getName() + " named " + this.getName(model)));
        r.getContents().add((Object)model);
        resources.add(r);
        resourceNames.add(filename);
    }

    private String getName(EObject model) {
        return (String)model.eGet(model.eClass().getEStructuralFeature("name"));
    }

    private void removeAbsoluteFileRefs(XmiWriterURIConverter uriConverter, Resource r, String filename) {
        try {
            Object s;
            StringBuffer newFile = new StringBuffer();
            InputStream stream = uriConverter.createInputStream(r.getURI());
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            while (br.ready()) {
                s = br.readLine();
                s = ((String)s).replaceAll(String.valueOf(filename) + "#//", "#//");
                newFile.append(String.valueOf(s) + "\n");
            }
            br.close();
            stream.close();
            s = uriConverter.createOutputStream(r.getURI());
            PrintStream ps = new PrintStream((OutputStream)s);
            ps.print(newFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    class XmiWriterURIConverter
    extends URIConverterImpl {
        private String pathPrefix;

        public XmiWriterURIConverter(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        protected OutputStream createFileOutputStream(String filename) throws IOException {
            return super.createFileOutputStream(this.tweakFilename(filename));
        }

        protected InputStream createFileInputStream(String filename) throws IOException {
            return super.createFileInputStream(this.tweakFilename(filename));
        }

        private String tweakFilename(String filename) {
            if (this.pathPrefix != null) {
                int lastSlashPos;
                this.pathPrefix = this.pathPrefix.replace('\\', '/');
                if (!this.pathPrefix.endsWith("/")) {
                    this.pathPrefix = String.valueOf(this.pathPrefix) + "/";
                }
                if ((lastSlashPos = (filename = filename.replace('\\', '/')).lastIndexOf("/")) >= 0) {
                    filename = String.valueOf(filename.substring(0, lastSlashPos + 1)) + this.pathPrefix + filename.substring(lastSlashPos + 1);
                }
            }
            return filename;
        }
    }
}

