/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer.engine;

import si.ijs.acs.objectexplorer.engine.Invocation;
import si.ijs.acs.objectexplorer.engine.RemoteCall;
import si.ijs.acs.objectexplorer.engine.RemoteResponseCallback;
import si.ijs.acs.objectexplorer.engine.SimpleIntrospectable;

public abstract class Operation {
    private String name = null;
    private SimpleIntrospectable introspectable = null;
    private String[] parameterNames = null;
    private Class[] parameterTypes = null;
    private boolean[] mask = null;
    private boolean special = false;
    private boolean invocation = false;
    private Class returnClass = null;

    public Operation(String string, SimpleIntrospectable simpleIntrospectable, Class clazz, String[] stringArray, Class[] classArray, boolean[] blArray, boolean bl, boolean bl2) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (simpleIntrospectable == null) {
            throw new NullPointerException("introspectable");
        }
        if (stringArray == null) {
            throw new NullPointerException("parameterNames");
        }
        if (classArray == null) {
            throw new NullPointerException("parameterTypes");
        }
        if (blArray == null) {
            throw new NullPointerException("mask");
        }
        if (blArray.length != stringArray.length) {
            throw new IllegalArgumentException("parameterNames.length != mask.length");
        }
        if (blArray.length != classArray.length) {
            throw new IllegalArgumentException("mask.length != parameterTypes.length");
        }
        this.name = string;
        this.mask = blArray;
        this.introspectable = simpleIntrospectable;
        this.parameterNames = stringArray;
        this.parameterTypes = classArray;
        this.special = bl2;
        this.invocation = bl;
        this.returnClass = clazz;
    }

    public SimpleIntrospectable getIntrospectable() {
        return this.introspectable;
    }

    public boolean[] getMask() {
        return this.mask;
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class getReturnType() {
        return this.returnClass;
    }

    private String getShortParamName(Class clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1);
    }

    private String getStringParamTypes() {
        StringBuffer stringBuffer = new StringBuffer(" ");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (!this.mask[i]) {
                stringBuffer.append("<");
            }
            if (this.parameterTypes[i].isArray()) {
                stringBuffer.append(this.getShortParamName(this.parameterTypes[i].getComponentType()));
                for (int j = 0; j <= this.parameterTypes[i].getName().lastIndexOf("[") - this.parameterTypes[i].getName().indexOf("["); ++j) {
                    stringBuffer.append("[ ]");
                }
            } else {
                stringBuffer.append(this.getShortParamName(this.parameterTypes[i]));
            }
            if (this.mask[i]) continue;
            stringBuffer.append(">");
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    public abstract RemoteCall invoke(Object[] var1);

    public abstract Invocation invokeAsync(Object[] var1, RemoteResponseCallback var2);

    public boolean isInvocation() {
        return this.invocation;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public String toString() {
        return this.name + " (" + this.getStringParamTypes() + ")";
    }
}

