/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer.engine.BACI;

import alma.ACS.CBDescIn;
import alma.ACSErr.Completion;
import alma.ACSErrTypeCommon.wrappers.AcsJCORBAProblemEx;
import alma.ACSErrTypeCommon.wrappers.AcsJNullPointerEx;
import alma.ACSErrTypeCommon.wrappers.AcsJUnexpectedExceptionEx;
import alma.acs.exceptions.AcsJCompletion;
import alma.acs.exceptions.AcsJException;
import alma.acs.logging.ClientLogManager;
import alma.acs.util.UTCUtility;
import alma.maciErrType.NoPermissionEx;
import alma.maciErrType.wrappers.AcsJNoPermissionEx;
import alma.objexpErrType.wrappers.AcsJObjectExplorerConnectEx;
import alma.objexpErrType.wrappers.AcsJObjectExplorerInterfaceRepositoryAccessEx;
import alma.objexpErrType.wrappers.AcsJObjectExplorerReportEx;
import java.awt.Dialog;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import org.omg.CORBA.Any;
import org.omg.CORBA.AttributeDescription;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ExceptionDescription;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription;
import org.omg.CORBA.NVList;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.OperationDefHelper;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.OperationMode;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.Request;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.Servant;
import si.ijs.acs.objectexplorer.NotificationBean;
import si.ijs.acs.objectexplorer.OETreeNode;
import si.ijs.acs.objectexplorer.TreeHandlerBean;
import si.ijs.acs.objectexplorer.engine.Attribute;
import si.ijs.acs.objectexplorer.engine.BACI.BACIAttribute;
import si.ijs.acs.objectexplorer.engine.BACI.BACICURLResolver;
import si.ijs.acs.objectexplorer.engine.BACI.BACIIntrospector;
import si.ijs.acs.objectexplorer.engine.BACI.BACIInvocation;
import si.ijs.acs.objectexplorer.engine.BACI.BACILogger;
import si.ijs.acs.objectexplorer.engine.BACI.BACIMenu;
import si.ijs.acs.objectexplorer.engine.BACI.BACIOperation;
import si.ijs.acs.objectexplorer.engine.BACI.BACIRemote;
import si.ijs.acs.objectexplorer.engine.BACI.BACIRemoteCall;
import si.ijs.acs.objectexplorer.engine.BACI.BACIRemoteNode;
import si.ijs.acs.objectexplorer.engine.BACI.BACIRemoteResponse;
import si.ijs.acs.objectexplorer.engine.BACI.BACITreeDataNode;
import si.ijs.acs.objectexplorer.engine.BACI.CorbalocDialog;
import si.ijs.acs.objectexplorer.engine.BACI.DelegateRemoteNode;
import si.ijs.acs.objectexplorer.engine.BACI.JavaIDLIntrospectionException;
import si.ijs.acs.objectexplorer.engine.BACI.RemoteNodeCouple;
import si.ijs.acs.objectexplorer.engine.Introspectable;
import si.ijs.acs.objectexplorer.engine.IntrospectionInconsistentException;
import si.ijs.acs.objectexplorer.engine.Invocation;
import si.ijs.acs.objectexplorer.engine.NonStickyComponentReleased;
import si.ijs.acs.objectexplorer.engine.NonStickyConnectFailedRemoteException;
import si.ijs.acs.objectexplorer.engine.Operation;
import si.ijs.acs.objectexplorer.engine.RemoteAccess;
import si.ijs.acs.objectexplorer.engine.RemoteException;
import si.ijs.acs.objectexplorer.engine.RemoteResponseCallback;
import si.ijs.maci.AuthenticationData;
import si.ijs.maci.Client;
import si.ijs.maci.ClientInfo;
import si.ijs.maci.ClientPOA;
import si.ijs.maci.ClientType;
import si.ijs.maci.ComponentInfo;
import si.ijs.maci.ImplLangType;
import si.ijs.maci.Manager;
import si.ijs.maci.ManagerHelper;

public class BACIRemoteAccess
implements Runnable,
RemoteAccess {
    private TreeHandlerBean parent = null;
    private BACIMenu baciEngineMenu = null;
    private NotificationBean notifier = null;
    private ArrayList invocations = new ArrayList();
    private Dispatcher dispatcher = null;
    private ArrayList<String> connected = new ArrayList();
    private BACIIntrospector baciIntrospector = new BACIIntrospector(this);
    private boolean ORBdebug = false;
    private String managerLoc = null;
    private ORB orb = null;
    private Thread orbThread = null;
    private Manager manager = null;
    private int handle = 0;
    private ComponentInfo[] infos = null;
    private ClientImpl client = null;
    private Repository rep = null;
    public static final short DOMAIN = 0;
    public static final short TYPE = 1;
    public static final short DEVICE = 2;
    public static final short PROPERTY = 3;
    public static final short ATTRIBUTE = 4;
    public static final short TRANSIENT = 5;
    public static final short DUMMY = 6;
    public static int POLL_TIMEOUT = 5000;
    public static final int POLL_SLEEP = 50;
    public static final String MANAGER_CORBALOC = "ACS.manager";
    public static final String IR_CORBALOC = "ACS.repository";
    public static final String PROPERTY_POOL_TIMEOUT = "objexp.pool_timeout";
    public static final String CONNECT_NON_STICKY_FLAG = "objexp.connect_non_sticky";
    public static final String strict = "false";
    private static HashMap descriptions = new HashMap();
    private static HashMap operationListDescriptions = new HashMap();
    private HashMap interfaceDescriptions = new HashMap();
    private HashMap attributeIntrospected = new HashMap();
    private HashMap operationsIntrospected = new HashMap();
    private boolean bufferDescs = true;
    private Hashtable devices = null;
    private boolean destroyed = false;
    private boolean connectNonSticky = false;
    private static final Comparator<Attribute> ATTRIBUTE_COMPARATOR = new BACIAttributeNameComparator();
    private static final Comparator<Operation> OPERATION_COMPARATOR = new BACIOperationNameComparator();

    public BACIRemoteAccess(TreeHandlerBean treeHandlerBean, NotificationBean notificationBean, Hashtable hashtable) {
        if (treeHandlerBean == null) {
            throw new NullPointerException("treeHandler*");
        }
        if (notificationBean == null) {
            throw new NullPointerException("notifier");
        }
        if (hashtable == null) {
            throw new NullPointerException("devices");
        }
        this.parent = treeHandlerBean;
        this.notifier = notificationBean;
        this.devices = hashtable;
        notificationBean.reportDebug("BACIRemoteAccess::BACIRemoteAccess", "Constructed remote access.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void connect(Introspectable introspectable) {
        if (introspectable == null) {
            throw new NullPointerException("target");
        }
        BACIRemoteNode bACIRemoteNode = null;
        try {
            bACIRemoteNode = (BACIRemoteNode)introspectable;
            if (bACIRemoteNode.getCORBARef() != null) {
                return;
            }
            if (!(bACIRemoteNode.getParent() instanceof Introspectable)) {
                this.internalManagerConnect(bACIRemoteNode);
                ArrayList<String> arrayList = this.connected;
                synchronized (arrayList) {
                    if (!bACIRemoteNode.isNonSticky() && bACIRemoteNode.getUserObject() instanceof String) {
                        this.connected.add((String)bACIRemoteNode.getUserObject());
                    }
                }
            } else {
                this.internalParentConnect(bACIRemoteNode);
            }
            if (bACIRemoteNode.getCORBARef() == null) {
                throw new AcsJNullPointerEx();
            }
        }
        catch (AcsJObjectExplorerConnectEx acsJObjectExplorerConnectEx) {
            if (!this.connectNonSticky) {
                this.logACSException((Exception)((java.lang.Object)acsJObjectExplorerConnectEx));
                throw new RemoteException("Failed to connect to '" + bACIRemoteNode + "'");
            }
            throw new NonStickyConnectFailedRemoteException(acsJObjectExplorerConnectEx.getMessage());
        }
        catch (AcsJNullPointerEx acsJNullPointerEx) {
            this.logACSException((Exception)((java.lang.Object)acsJNullPointerEx));
            throw new RemoteException("Failed to connect to '" + bACIRemoteNode + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        POA pOA = this.invocations;
        synchronized (pOA) {
            for (BACIInvocation object : this.invocations) {
                try {
                    if (!object.isControllable()) continue;
                    BACIIntrospector.destroyInvocation(object);
                }
                catch (Exception exception) {}
            }
            this.invocations.clear();
        }
        this.notifier.reportMessage("Logging out from the Manager.");
        pOA = this.connected;
        synchronized (pOA) {
            this.notifier.reportDebug("BACIRemoteAccess::destroy", "Releasing Components on Manager, " + this.connected.size() + " Components total.");
            for (String string : this.connected) {
                try {
                    this.manager.release_component(this.handle, string);
                }
                catch (Exception exception) {
                    this.notifier.reportError("Cannot release component " + string, exception);
                }
            }
            this.connected.clear();
        }
        pOA = descriptions;
        synchronized (pOA) {
            descriptions.clear();
            this.notifier.reportDebug("BACIRemoveAccess::destroy", "Cleared IF descriptions list for CallbackImpl.");
        }
        pOA = operationListDescriptions;
        synchronized (pOA) {
            operationListDescriptions.clear();
            this.notifier.reportDebug("BACIRemoveAccess::destroy", "Cleared IF operation descriptions list for CallbackImpl.");
        }
        pOA = this.interfaceDescriptions;
        synchronized (pOA) {
            this.interfaceDescriptions.clear();
        }
        pOA = this.operationsIntrospected;
        synchronized (pOA) {
            this.operationsIntrospected.clear();
        }
        pOA = this.attributeIntrospected;
        synchronized (pOA) {
            this.attributeIntrospected.clear();
        }
        if (this.manager != null) {
            try {
                this.manager.logout(this.handle);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifier.reportDebug("BACIRemoteAccess::destroy", "ObjectExplorer logout OK.");
        }
        pOA = this.client._default_POA();
        try {
            java.lang.Object object = pOA.servant_to_id((Servant)this.client);
            pOA.deactivate_object((byte[])object);
        }
        catch (Exception exception) {
            this.notifier.reportError("Error while deactivating Client servant.", exception);
        }
        this.orb.destroy();
        this.notifier.reportDebug("BACIRemoteAccess::destroy", "ORB shutdown complete.");
        this.notifier.reportMessage("Shutting down CORBA.");
        this.notifier.reportDebug("BACIRemoteAccess::destroy", "Sending dispatcher termination signal.");
        this.dispatcher.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void disconnect(Introspectable introspectable) {
        java.lang.Object object;
        if (introspectable == null) {
            throw new NullPointerException("target");
        }
        BACIRemoteNode bACIRemoteNode = (BACIRemoteNode)introspectable;
        if (bACIRemoteNode.getCORBARef() == null) {
            return;
        }
        this.notifier.reportMessage("Disconnecting from '" + introspectable.getName() + "'.");
        Enumeration<TreeNode> enumeration = bACIRemoteNode.children();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof Introspectable)) continue;
            ((Introspectable)object).disconnect();
        }
        object = this.invocations;
        synchronized (object) {
            Iterator iterator = this.invocations.iterator();
            ArrayList<BACIInvocation> arrayList = new ArrayList<BACIInvocation>();
            while (iterator.hasNext()) {
                BACIInvocation bACIInvocation = (BACIInvocation)iterator.next();
                if (bACIInvocation.getInvocationRequest().getIntrospectable() != introspectable) continue;
                BACIIntrospector.destroyInvocation(bACIInvocation);
                arrayList.add(bACIInvocation);
            }
            this.invocations.removeAll(arrayList);
        }
        object = this.connected;
        synchronized (object) {
            if (bACIRemoteNode.getUserObject() instanceof String) {
                this.connected.remove(bACIRemoteNode.getUserObject());
            }
        }
        if (bACIRemoteNode.isDevice() && !bACIRemoteNode.isNonSticky()) {
            if (this.manager == null) {
                this.resolveManager();
            }
            this.notifier.reportDebug("BACIRemoteAccess::disconnect", "Releasing component '" + introspectable.getName() + "'.");
            try {
                this.manager.release_component(this.handle, (String)bACIRemoteNode.getUserObject());
                this.notifier.reportDebug("BACIRemoteAccess::disconnect", "Component '" + introspectable.getName() + "' released.");
            }
            catch (NoPermissionEx noPermissionEx) {
                this.notifier.reportError("No permission to release component", noPermissionEx);
            }
        }
        this.notifier.reportMessage("Disconnected from '" + introspectable.getName() + "'.");
    }

    private synchronized OETreeNode[] explodeDeviceNode(BACIRemoteNode bACIRemoteNode) {
        if (bACIRemoteNode == null) {
            throw new NullPointerException("node");
        }
        if (this.manager == null) {
            this.resolveManager();
        }
        BACIRemoteNode bACIRemoteNode2 = bACIRemoteNode;
        this.connect(bACIRemoteNode2);
        AttributeDescription[] attributeDescriptionArray = this.baciIntrospector.getProperties(bACIRemoteNode2.getIFDesc().attributes);
        OETreeNode[] oETreeNodeArray = new BACIRemoteNode[attributeDescriptionArray.length];
        for (int i = 0; i < attributeDescriptionArray.length; ++i) {
            oETreeNodeArray[i] = new BACIRemoteNode(4, attributeDescriptionArray[i].name, (java.lang.Object)attributeDescriptionArray[i], this.parent.getTree(), this);
        }
        this.notifier.reportDebug("BACIRemoteAccess::explodeDeviceNode", "Processing for node '" + bACIRemoteNode + "' complete.");
        return oETreeNodeArray;
    }

    private synchronized BACITreeDataNode[] explodeDomainNode(BACITreeDataNode bACITreeDataNode) {
        java.lang.Object object;
        java.lang.Object object2;
        if (bACITreeDataNode == null) {
            throw new NullPointerException("node");
        }
        if (bACITreeDataNode.childrenHolder == null) {
            return new BACITreeDataNode[0];
        }
        ComponentInfo[] componentInfoArray = new ComponentInfo[bACITreeDataNode.childrenHolder.size()];
        bACITreeDataNode.childrenHolder.toArray(componentInfoArray);
        TreeMap<String, java.lang.Object> treeMap = new TreeMap<String, java.lang.Object>();
        TreeMap<java.lang.Object, BACITreeDataNode> treeMap2 = new TreeMap<java.lang.Object, BACITreeDataNode>();
        for (int i = 0; i < componentInfoArray.length; ++i) {
            BACITreeDataNode bACITreeDataNode2;
            java.lang.Object object3;
            object2 = null;
            object = BACICURLResolver.resolveDomain(componentInfoArray[i].name);
            object2 = ((String)object).endsWith("/") ? object : (String)object + "/";
            if (bACITreeDataNode.domainRemainder.equals(object2)) {
                object3 = (BACITreeDataNode)treeMap.get(componentInfoArray[i]);
                if (object3 != null) {
                    ((BACITreeDataNode)object3).childrenHolder.add(componentInfoArray[i].name);
                    continue;
                }
                try {
                    object3 = new BACITreeDataNode(1, BACIIntrospector.fullTypeToType(componentInfoArray[i].type), BACIIntrospector.fullTypeToType(componentInfoArray[i].type), this.parent.getTree(), this.getIcon((short)0));
                }
                catch (IntrospectionInconsistentException introspectionInconsistentException) {
                    this.notifier.reportError("Invalid IDL type '" + componentInfoArray[i].type + "'.", introspectionInconsistentException);
                    continue;
                }
                ((BACITreeDataNode)object3).childrenHolder = new ArrayList();
                ((BACITreeDataNode)object3).childrenHolder.add(componentInfoArray[i].name);
                treeMap.put(componentInfoArray[i].type, object3);
                continue;
            }
            if (((String)object).startsWith("/")) {
                object = ((String)object).substring(1);
            }
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            if ((bACITreeDataNode2 = (BACITreeDataNode)treeMap2.get(object3 = ((String)object).substring(bACITreeDataNode.domainRemainder.length(), ((String)object).indexOf(47)))) != null) {
                bACITreeDataNode2.childrenHolder.add(componentInfoArray[i]);
                continue;
            }
            bACITreeDataNode2 = new BACITreeDataNode(0, (String)object3, componentInfoArray[i], this.parent.getTree(), this.getIcon((short)0));
            bACITreeDataNode2.childrenHolder = new ArrayList();
            bACITreeDataNode2.childrenHolder.add(componentInfoArray[i]);
            bACITreeDataNode2.domainRemainder = bACITreeDataNode.domainRemainder + (String)object3 + "/";
            treeMap2.put(object3, bACITreeDataNode2);
        }
        BACITreeDataNode[] bACITreeDataNodeArray = new BACITreeDataNode[treeMap.size()];
        treeMap.values().toArray(bACITreeDataNodeArray);
        object2 = new BACITreeDataNode[treeMap2.size()];
        treeMap2.values().toArray((T[])object2);
        object = new BACITreeDataNode[bACITreeDataNodeArray.length + ((BACITreeDataNode[])object2).length];
        System.arraycopy(object2, 0, object, 0, ((BACITreeDataNode[])object2).length);
        System.arraycopy(bACITreeDataNodeArray, 0, object, ((BACITreeDataNode[])object2).length, bACITreeDataNodeArray.length);
        this.notifier.reportDebug("BACIRemoteAccess::explodeDomainNode", "Processing for node '" + bACITreeDataNode + "' complete.");
        return object;
    }

    private synchronized BACITreeDataNode[] explodeDomainNodeByName(BACITreeDataNode bACITreeDataNode) {
        if (bACITreeDataNode == null) {
            throw new NullPointerException("node");
        }
        if (bACITreeDataNode.childrenHolder == null) {
            return new BACITreeDataNode[0];
        }
        BACITreeDataNode[] bACITreeDataNodeArray = new BACITreeDataNode[bACITreeDataNode.childrenHolder.size()];
        for (int i = 0; i < bACITreeDataNodeArray.length; ++i) {
            bACITreeDataNodeArray[i] = (BACITreeDataNode)bACITreeDataNode.childrenHolder.get(i);
        }
        this.notifier.reportDebug("BACIRemoteAccess::explodeDomainNodeByName", "Processing for node '" + bACITreeDataNode + "' complete.");
        return bACITreeDataNodeArray;
    }

    private synchronized OETreeNode[] explodeRootNodeByType() {
        BACITreeDataNode bACITreeDataNode;
        java.lang.Object object;
        java.lang.Object object2;
        int n;
        if (this.manager == null) {
            this.resolveManager();
        }
        this.notifier.reportDebug("BACIRemoteAccess::explodeRootNodeByType", "Querying manager for all instances of all types...");
        long l = System.currentTimeMillis();
        int[] nArray = new int[]{};
        try {
            this.infos = this.manager.get_component_info(this.handle, nArray, "*", "*", false);
        }
        catch (NoPermissionEx noPermissionEx) {
            this.notifier.reportError("Nopermission to get component info", noPermissionEx);
        }
        long l2 = System.currentTimeMillis();
        this.notifier.reportDebug("BACIRemoteAccess::explodeRootNodeByType", "Query OK. Completed in " + (l2 - l) + " ms.");
        TreeMap<String, BACITreeDataNode> treeMap = new TreeMap<String, BACITreeDataNode>();
        TreeMap<java.lang.Object, BACIRemoteNode> treeMap2 = new TreeMap<java.lang.Object, BACIRemoteNode>();
        this.devices.clear();
        for (n = 0; n < this.infos.length; ++n) {
            object2 = this.infos[n].name;
            RemoteNodeCouple remoteNodeCouple = (RemoteNodeCouple)this.devices.get(object2);
            if (remoteNodeCouple != null) continue;
            object = BACICURLResolver.resolveName((String)object2);
            bACITreeDataNode = new BACIRemoteNode(2, (String)object, object2, this.parent.getTree(), this);
            bACITreeDataNode.childrenHolder = new ArrayList();
            remoteNodeCouple = new RemoteNodeCouple((BACIRemoteNode)bACITreeDataNode, null);
            String[] stringArray = ((String)object).split("/");
            String string = stringArray[stringArray.length - 1];
            remoteNodeCouple.deviceByName = new DelegateRemoteNode(string, this.parent, (BACIRemoteNode)bACITreeDataNode);
            this.devices.put(object2, remoteNodeCouple);
        }
        for (n = 0; n < this.infos.length; ++n) {
            object2 = BACICURLResolver.resolveDomain(this.infos[n].name);
            if (((String)object2).equals("Root")) {
                BACITreeDataNode bACITreeDataNode2 = (BACITreeDataNode)treeMap.get(this.infos[n].type);
                if (bACITreeDataNode2 != null) {
                    bACITreeDataNode2.childrenHolder.add(this.infos[n].name);
                    continue;
                }
                try {
                    bACITreeDataNode2 = new BACITreeDataNode(1, BACIIntrospector.fullTypeToType(this.infos[n].type), BACIIntrospector.fullTypeToType(this.infos[n].type), this.parent.getTree(), this.getIcon((short)1));
                }
                catch (IntrospectionInconsistentException introspectionInconsistentException) {
                    this.notifier.reportError("Invalid IDL type '" + this.infos[n].type + "'.", introspectionInconsistentException);
                    continue;
                }
                bACITreeDataNode2.childrenHolder = new ArrayList();
                bACITreeDataNode2.childrenHolder.add(this.infos[n].name);
                treeMap.put(this.infos[n].type, bACITreeDataNode2);
                continue;
            }
            if (((String)object2).startsWith("/")) {
                object2 = ((String)object2).substring(1);
            }
            int n2 = ((String)object2).indexOf(47);
            object = null;
            object = n2 != -1 ? ((String)object2).substring(0, ((String)object2).indexOf(47)) : object2;
            bACITreeDataNode = (BACITreeDataNode)treeMap2.get(object);
            if (bACITreeDataNode != null) {
                bACITreeDataNode.childrenHolder.add(this.infos[n]);
                continue;
            }
            bACITreeDataNode = new BACITreeDataNode(0, (String)object, this.infos[n], this.parent.getTree(), this.getIcon((short)0));
            bACITreeDataNode.childrenHolder = new ArrayList();
            bACITreeDataNode.childrenHolder.add(this.infos[n]);
            bACITreeDataNode.domainRemainder = n2 != -1 ? (String)object + "/" : object;
            treeMap2.put(object, (BACIRemoteNode)bACITreeDataNode);
        }
        BACITreeDataNode[] bACITreeDataNodeArray = new BACITreeDataNode[treeMap.size()];
        treeMap.values().toArray(bACITreeDataNodeArray);
        object2 = new BACITreeDataNode[treeMap2.size()];
        treeMap2.values().toArray((T[])object2);
        OETreeNode[] oETreeNodeArray = new BACITreeDataNode[bACITreeDataNodeArray.length + ((BACITreeDataNode[])object2).length];
        System.arraycopy(object2, 0, oETreeNodeArray, 0, ((java.lang.Object)object2).length);
        System.arraycopy(bACITreeDataNodeArray, 0, oETreeNodeArray, ((java.lang.Object)object2).length, bACITreeDataNodeArray.length);
        Arrays.sort(oETreeNodeArray, new Comparator(){

            public int compare(java.lang.Object object, java.lang.Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        this.notifier.reportDebug("BACIRemoteAccess::explodeRootNodeByType", "Root nodes processing complete.");
        return oETreeNodeArray;
    }

    public synchronized OETreeNode[] explodeRootNodeByName() {
        BACITreeDataNode[] bACITreeDataNodeArray;
        int n;
        if (this.manager == null) {
            this.resolveManager();
        }
        this.notifier.reportDebug("BACIRemoteAccess::explodeRootNodeByName", "Querying manager for all instances of all types...");
        long l = System.currentTimeMillis();
        int[] nArray = new int[]{};
        try {
            this.infos = this.manager.get_component_info(this.handle, nArray, "*", "*", false);
        }
        catch (NoPermissionEx noPermissionEx) {
            this.notifier.reportError("Nopermission to get component info", noPermissionEx);
        }
        long l2 = System.currentTimeMillis();
        this.notifier.reportDebug("BACIRemoteAccess::explodeRootNodeByName", "Query OK. Completed in " + (l2 - l) + " ms.");
        TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>();
        TreeMap<String, java.lang.Object> treeMap2 = new TreeMap<String, java.lang.Object>();
        Vector<java.lang.Object> vector = new Vector<java.lang.Object>();
        for (n = 0; n < this.infos.length; ++n) {
            java.lang.Object object;
            bACITreeDataNodeArray = this.infos[n].name;
            String string = BACICURLResolver.resolveDomain((String)bACITreeDataNodeArray);
            String string2 = BACICURLResolver.resolveName((String)bACITreeDataNodeArray);
            RemoteNodeCouple remoteNodeCouple = (RemoteNodeCouple)this.devices.get(bACITreeDataNodeArray);
            if (remoteNodeCouple == null) {
                this.notifier.reportError("BACIRemoteAccess::explodeRootNodeByName - Unexpected null pointer (rnc).");
                continue;
            }
            if (remoteNodeCouple.deviceByName == null) {
                this.notifier.reportError("BACIRemoteAccess::explodeRootNodeByName - Unexpected null pointer (rnc.deviceByName).");
                continue;
            }
            String[] stringArray = string2.split("/", 2);
            if (string.equals("Root")) {
                java.lang.Object object2 = (String[])treeMap2.get(stringArray[0]);
                if (stringArray.length > 1) {
                    boolean bl = object2 instanceof BACIRemoteNode;
                    if (object2 == null || bl) {
                        object = object2;
                        object2 = new BACITreeDataNode(6, stringArray[0], BACICURLResolver.getFirstLevelCurl((String)bACITreeDataNodeArray), this.parent.getTreeByName(), this.getIcon((short)0));
                        object2.childrenHolder = new ArrayList();
                        treeMap2.put(stringArray[0], object2);
                        vector.add(object2);
                        if (bl) {
                            object2.childrenHolder.add(object);
                        }
                    }
                    object = stringArray[1].split("/");
                    this.getTreeForName((BACITreeDataNode)object2, 0, (String[])object);
                    continue;
                }
                if (object2 == null) {
                    treeMap2.put(stringArray[0], remoteNodeCouple.deviceByName);
                    continue;
                }
                object2.childrenHolder.add(0, remoteNodeCouple.deviceByName);
                continue;
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            int n2 = string.indexOf(47);
            String string3 = null;
            string3 = n2 != -1 ? string.substring(0, n2) : string;
            object = (BACITreeDataNode)treeMap.get(string3);
            if (object == null) {
                object = new BACITreeDataNode(0, string3, this.infos[n], this.parent.getTreeByName(), this.getIcon((short)0));
                object.childrenHolder = new ArrayList();
                object.domainRemainder = n2 != -1 ? string3 + "/" : string3;
                treeMap.put(string3, (String[])object);
            }
            BACITreeDataNode bACITreeDataNode = (BACITreeDataNode)treeMap2.get(stringArray[0]);
            if (stringArray.length > 1) {
                if (bACITreeDataNode == null) {
                    bACITreeDataNode = new BACITreeDataNode(6, stringArray[0], BACICURLResolver.getFirstLevelCurl((String)bACITreeDataNodeArray), this.parent.getTree(), this.getIcon((short)0));
                    bACITreeDataNode.childrenHolder = new ArrayList();
                    object.childrenHolder.add(0, remoteNodeCouple.deviceByName);
                    vector.add(bACITreeDataNode);
                }
                String[] stringArray2 = stringArray[1].split("/");
                this.getTreeForName(bACITreeDataNode, 0, stringArray2);
                continue;
            }
            if (bACITreeDataNode == null) {
                object.childrenHolder.add(0, remoteNodeCouple.deviceByName);
                continue;
            }
            bACITreeDataNode.childrenHolder.add(0, remoteNodeCouple.deviceByName);
        }
        for (n = 0; n < vector.size(); ++n) {
            bACITreeDataNodeArray = (BACITreeDataNode)vector.get(n);
            for (int i = 0; i < bACITreeDataNodeArray.childrenHolder.size(); ++i) {
                if (bACITreeDataNodeArray.childrenHolder.get(i) instanceof BACIRemoteNode) continue;
                this.removeSingleDeviceDummies((BACITreeDataNode)bACITreeDataNodeArray, i, (BACITreeDataNode)bACITreeDataNodeArray.childrenHolder.get(i));
            }
        }
        BACITreeDataNode[] bACITreeDataNodeArray2 = new BACITreeDataNode[treeMap2.size()];
        treeMap2.values().toArray(bACITreeDataNodeArray2);
        bACITreeDataNodeArray = new BACITreeDataNode[treeMap.size()];
        treeMap.values().toArray(bACITreeDataNodeArray);
        OETreeNode[] oETreeNodeArray = new BACITreeDataNode[bACITreeDataNodeArray2.length + bACITreeDataNodeArray.length];
        System.arraycopy(bACITreeDataNodeArray, 0, oETreeNodeArray, 0, bACITreeDataNodeArray.length);
        System.arraycopy(bACITreeDataNodeArray2, 0, oETreeNodeArray, bACITreeDataNodeArray.length, bACITreeDataNodeArray2.length);
        this.notifier.reportDebug("BACIRemoteAccess::explodeRootNodeByName", "Root nodes processing complete.");
        return oETreeNodeArray;
    }

    public BACITreeDataNode getTreeForName(BACITreeDataNode bACITreeDataNode, int n, String[] stringArray) {
        java.lang.Object object;
        if (stringArray == null) {
            return null;
        }
        if (n == stringArray.length) {
            return bACITreeDataNode;
        }
        for (int i = 0; i < bACITreeDataNode.childrenHolder.size(); ++i) {
            object = (BACITreeDataNode)bACITreeDataNode.childrenHolder.get(i);
            if (object instanceof BACIRemoteNode || ((OETreeNode)object).getName().compareTo(stringArray[n]) != 0) continue;
            return this.getTreeForName((BACITreeDataNode)object, ++n, stringArray);
        }
        String string = (String)bACITreeDataNode.getUserObject() + "/" + stringArray[n];
        object = (RemoteNodeCouple)this.devices.get(string);
        BACITreeDataNode bACITreeDataNode2 = new BACITreeDataNode(6, stringArray[n], string, this.parent.getTreeByName(), this.getIcon((short)0));
        bACITreeDataNode2.childrenHolder = new ArrayList();
        if (object != null && ((RemoteNodeCouple)object).deviceByName != null) {
            bACITreeDataNode2.childrenHolder.add(((RemoteNodeCouple)object).deviceByName);
        }
        bACITreeDataNode.childrenHolder.add(bACITreeDataNode2);
        return this.getTreeForName(bACITreeDataNode2, ++n, stringArray);
    }

    public void removeSingleDeviceDummies(BACITreeDataNode bACITreeDataNode, int n, BACITreeDataNode bACITreeDataNode2) {
        if (bACITreeDataNode2.childrenHolder.size() > 1) {
            for (int i = 0; i < bACITreeDataNode2.childrenHolder.size(); ++i) {
                BACITreeDataNode bACITreeDataNode3 = (BACITreeDataNode)bACITreeDataNode2.childrenHolder.get(0);
                if (bACITreeDataNode3 instanceof BACIRemoteNode) continue;
                this.removeSingleDeviceDummies(bACITreeDataNode2, i, bACITreeDataNode3);
            }
        } else if (bACITreeDataNode2.childrenHolder.size() == 1) {
            BACITreeDataNode bACITreeDataNode4 = (BACITreeDataNode)bACITreeDataNode2.childrenHolder.get(0);
            if (bACITreeDataNode4 instanceof BACIRemoteNode) {
                bACITreeDataNode.childrenHolder.remove(n);
                bACITreeDataNode.childrenHolder.add(n, bACITreeDataNode4);
                return;
            }
            this.removeSingleDeviceDummies(bACITreeDataNode2, 0, bACITreeDataNode4);
            return;
        }
    }

    @Override
    public OETreeNode[] explodeTreeNode(OETreeNode oETreeNode) {
        if (oETreeNode == null) {
            this.notifier.reportMessage("Querying root nodes.");
            return this.explodeRootNodeByType();
        }
        switch (oETreeNode.getNodeType()) {
            case 0: {
                this.notifier.reportMessage("Querying domain node children of '" + oETreeNode.getName() + "'.");
                return this.explodeDomainNode((BACITreeDataNode)oETreeNode);
            }
            case 1: {
                this.notifier.reportMessage("Querying type node children of '" + oETreeNode.getName() + "'.");
                return this.explodeTypeNode((BACITreeDataNode)oETreeNode);
            }
            case 2: {
                this.notifier.reportMessage("Querying device node children of '" + oETreeNode.getName() + "'.");
                return this.explodeDeviceNode((BACIRemoteNode)oETreeNode);
            }
            case 6: {
                this.notifier.reportMessage("Querying device node children of '" + oETreeNode.getName() + "'.");
                return this.explodeDummyNode((BACITreeDataNode)oETreeNode);
            }
        }
        return new OETreeNode[0];
    }

    private synchronized OETreeNode[] explodeTypeNode(BACITreeDataNode bACITreeDataNode) {
        if (bACITreeDataNode == null) {
            throw new NullPointerException("node");
        }
        if (bACITreeDataNode.childrenHolder == null || bACITreeDataNode.childrenHolder.size() == 0) {
            return new BACITreeDataNode[0];
        }
        OETreeNode[] oETreeNodeArray = new BACIRemoteNode[bACITreeDataNode.childrenHolder.size()];
        Collections.sort(bACITreeDataNode.childrenHolder);
        for (int i = 0; i < oETreeNodeArray.length; ++i) {
            String string = (String)bACITreeDataNode.childrenHolder.get(i);
            String string2 = BACICURLResolver.resolveName(string);
            if (string2 == null) {
                throw new IllegalArgumentException("component name is null " + string);
            }
            RemoteNodeCouple remoteNodeCouple = (RemoteNodeCouple)this.devices.get(string);
            if (remoteNodeCouple != null) {
                oETreeNodeArray[i] = remoteNodeCouple.deviceByType;
                continue;
            }
            oETreeNodeArray[i] = null;
            this.notifier.reportError("BACIRemoteAccess::explodeTypeNode - Unexpected null pointer (rnc).");
        }
        this.notifier.reportDebug("BACIRemoteAccess::explodeTypeNode", "Processing for node '" + bACITreeDataNode + "' complete.");
        return oETreeNodeArray;
    }

    public synchronized OETreeNode[] explodeDummyNode(BACITreeDataNode bACITreeDataNode) {
        if (bACITreeDataNode == null) {
            throw new NullPointerException("node");
        }
        if (bACITreeDataNode.childrenHolder == null) {
            return new BACITreeDataNode[0];
        }
        OETreeNode[] oETreeNodeArray = new BACITreeDataNode[bACITreeDataNode.childrenHolder.size()];
        for (int i = 0; i < oETreeNodeArray.length; ++i) {
            oETreeNodeArray[i] = (BACITreeDataNode)bACITreeDataNode.childrenHolder.get(i);
        }
        this.notifier.reportDebug("BACIRemoteAccess::explodeDummyNode", "Processing for node '" + bACITreeDataNode + "' complete.");
        return oETreeNodeArray;
    }

    Attribute[] getAttributes(BACIRemote bACIRemote) {
        String string = bACIRemote.getIFDesc().id;
        Attribute[] attributeArray = null;
        if (this.bufferDescs) {
            attributeArray = (Attribute[])this.attributeIntrospected.get(string);
        }
        if (attributeArray == null) {
            this.notifier.reportMessage("Analysing attributes for '" + bACIRemote.getName() + "'.");
            attributeArray = this.baciIntrospector.getAttributes(bACIRemote);
            if (this.bufferDescs) {
                this.attributeIntrospected.put(string, attributeArray);
            }
        } else {
            this.notifier.reportDebug("BACIRemoteAccess::getAttributes", "Found attribute descriptions for '" + bACIRemote.getName() + "' in attribute cache...");
        }
        Attribute[] attributeArray2 = new Attribute[attributeArray.length];
        for (int i = 0; i < attributeArray2.length; ++i) {
            attributeArray2[i] = attributeArray[i].getIntrospectable() == bACIRemote ? attributeArray[i] : new BACIAttribute((BACIAttribute)attributeArray[i], bACIRemote);
        }
        Arrays.sort(attributeArray2, 0, attributeArray2.length, ATTRIBUTE_COMPARATOR);
        return attributeArray2;
    }

    public boolean getCaching() {
        return this.bufferDescs;
    }

    Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public JMenu getEngineMenu() {
        BACIMenu bACIMenu = new BACIMenu(this);
        bACIMenu.setVisible(true);
        this.baciEngineMenu = bACIMenu;
        return bACIMenu;
    }

    Icon getIcon(short s) {
        ImageIcon imageIcon = null;
        URL uRL = null;
        if (s == 0 || s == 1) {
            uRL = this.getClass().getClassLoader().getResource("domain.gif");
        }
        if (s == 2) {
            uRL = this.getClass().getClassLoader().getResource("device.gif");
        }
        if (s == 3) {
            uRL = this.getClass().getClassLoader().getResource("property.gif");
        }
        if (s == 5) {
            uRL = this.getClass().getClassLoader().getResource("invocation.gif");
        }
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon;
    }

    private FullInterfaceDescription getIFDesc(String string) {
        FullInterfaceDescription fullInterfaceDescription = null;
        if (this.bufferDescs) {
            fullInterfaceDescription = (FullInterfaceDescription)this.interfaceDescriptions.get(string);
        }
        if (fullInterfaceDescription == null) {
            this.notifier.reportDebug("BACIRemoteAccess::getIFDesc", "Querying IR for full interface description for id '" + string + "'.");
            InterfaceDef interfaceDef = InterfaceDefHelper.narrow((Object)this.rep.lookup_id(string));
            if (interfaceDef == null) {
                throw new IllegalStateException("ID '" + string + "' was not found in the Repository.");
            }
            fullInterfaceDescription = interfaceDef.describe_interface();
            if (this.bufferDescs) {
                this.interfaceDescriptions.put(string, fullInterfaceDescription);
            }
        } else {
            this.notifier.reportDebug("BACIRemoteAccess::getIFDesc", "Full interface description for id '" + string + "' was found in interface cache.");
        }
        return fullInterfaceDescription;
    }

    BACIIntrospector getIntrospector() {
        return this.baciIntrospector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invocation[] getInvocations() {
        ArrayList arrayList = this.invocations;
        synchronized (arrayList) {
            Invocation[] invocationArray = new Invocation[this.invocations.size()];
            this.invocations.toArray(invocationArray);
            return invocationArray;
        }
    }

    NotificationBean getNotifier() {
        return this.notifier;
    }

    Operation[] getOperations(BACIRemote bACIRemote) {
        if (bACIRemote == null) {
            throw new NullPointerException("target");
        }
        String string = bACIRemote.getIFDesc().id;
        Operation[] operationArray = null;
        if (this.bufferDescs) {
            operationArray = (Operation[])this.operationsIntrospected.get(string);
        }
        if (operationArray == null) {
            this.notifier.reportMessage("Analysing operations for '" + bACIRemote.getName() + "'.");
            operationArray = this.baciIntrospector.getOperations(bACIRemote);
            if (this.bufferDescs) {
                this.operationsIntrospected.put(string, operationArray);
            }
        } else {
            this.notifier.reportDebug("BACIRemoteAccess::getOperations", "Found operation descriptions for '" + bACIRemote.getName() + "' in operation cache...");
        }
        Operation[] operationArray2 = new Operation[operationArray.length];
        for (int i = 0; i < operationArray2.length; ++i) {
            operationArray2[i] = operationArray[i].getIntrospectable() == bACIRemote ? operationArray[i] : new BACIOperation((BACIOperation)operationArray[i], bACIRemote);
        }
        Arrays.sort(operationArray2, 0, operationArray2.length, OPERATION_COMPARATOR);
        return operationArray2;
    }

    @Override
    public OETreeNode[] getTreeRoots() {
        return this.explodeTreeNode(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        java.lang.Object object;
        this.notifier.reportMessage("Starting engine initialization...");
        Properties properties = System.getProperties();
        this.managerLoc = properties.getProperty(MANAGER_CORBALOC);
        String string = properties.getProperty(IR_CORBALOC);
        if (this.managerLoc == null || string == null) {
            object = new CorbalocDialog();
            if (this.managerLoc != null) {
                ((CorbalocDialog)object).setManagerFieldText(this.managerLoc);
            }
            if (string != null) {
                ((CorbalocDialog)object).setRepositoryFieldText(string);
            }
            ((Dialog)object).show();
            if (((CorbalocDialog)object).isOKed()) {
                this.managerLoc = ((CorbalocDialog)object).getManagerFieldText();
                string = ((CorbalocDialog)object).getRepositoryFieldText();
                this.ORBdebug = ((CorbalocDialog)object).getDebugSelected();
            }
        }
        if (string == null || "".equals(string)) {
            throw new IllegalStateException("'ACS.repository' property is not set. Aborting...");
        }
        if (this.managerLoc == null || "".equals(this.managerLoc)) {
            throw new IllegalStateException("'ACS.manager' property is not set. Aborting...");
        }
        this.notifier.reportDebug("BACIRemoteAccess::initialize", "Startup using 'ACS.manager' = '" + this.managerLoc + "'.");
        this.notifier.reportDebug("BACIRemoteAccess::initialize", "Startup using 'ACS.repository' = '" + string + "'.");
        object = properties.getProperty(PROPERTY_POOL_TIMEOUT);
        this.notifier.reportDebug("BACIRemoteAccess::initialize", "Startup using 'objexp.pool_timeout' = '" + (String)object + "'.");
        if (object != null) {
            try {
                int n = Integer.parseInt((String)object);
                if (n >= 50) {
                    POLL_TIMEOUT = n;
                }
            }
            catch (Exception exception) {
                this.notifier.reportDebug("BACIRemoteAccess::initialize", "Failed to parse 'objexp.pool_timeout' property value '" + (String)object + "' as integer.");
            }
        }
        this.notifier.reportDebug("BACIRemoteAccess::initialize", "Configuration: STRICT flag = false");
        this.notifier.reportDebug("BACIRemoteAccess::initialize", "Configuration: POOL_TIMEOUT = " + POLL_TIMEOUT + " ms.");
        Properties properties2 = System.getProperties();
        this.orb = ORB.init((String[])new String[0], (Properties)properties2);
        this.notifier.reportDebug("BACIRemoteAccess::initialize", "ORB initialized.");
        POA pOA = null;
        try {
            pOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
        }
        catch (InvalidName invalidName) {
            throw new IllegalStateException("Cannot resolve RootPOA: " + (java.lang.Object)((java.lang.Object)invalidName));
        }
        POAManager pOAManager = pOA.the_POAManager();
        this.notifier.reportDebug("BACIRemoteAccess::initialize", "POA initialized.");
        try {
            pOAManager.activate();
            this.orbThread = new Thread(this);
            this.orbThread.start();
        }
        catch (Exception exception) {
            throw new IllegalStateException("POAManager activation failed: " + exception);
        }
        Object object2 = null;
        this.notifier.reportDebug("BACIRemoteAccess::initialize", "Trying to resolve 'Repository'.");
        try {
            object2 = this.orb.string_to_object(string);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Cannot access orb initial reference 'InterfaceRepository'.");
        }
        if (object2 == null) {
            throw new IllegalStateException("Cannot resolve Interface Repository");
        }
        this.rep = RepositoryHelper.narrow((Object)object2);
        this.notifier.reportDebug("BACIRemoteAccess::initialize", "Obtained reference to 'Repository'.");
        this.notifier.reportMessage("Obtained reference to 'Repository'.");
        HashMap hashMap = descriptions;
        synchronized (hashMap) {
            descriptions.clear();
            this.notifier.reportDebug("BACIRemoveAccess::destroy", "Cleared IF descriptions list for CallbackImpl.");
        }
        hashMap = operationListDescriptions;
        synchronized (hashMap) {
            operationListDescriptions.clear();
            this.notifier.reportDebug("BACIRemoveAccess::destroy", "Cleared IF operation descriptions list for CallbackImpl.");
        }
        this.dispatcher = new Dispatcher();
        this.dispatcher.start();
        this.notifier.reportDebug("BACIRemoteAccess::initialize", "Started callback dispatcher thread.");
        this.resolveManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Invocation internalInvokeInvocation(BACIRemote bACIRemote, BACIOperation bACIOperation, java.lang.Object[] objectArray, RemoteResponseCallback remoteResponseCallback) {
        int n = this.baciIntrospector.getCallbackLocation(bACIOperation);
        if (n == -1) {
            throw new IntrospectionInconsistentException("Asynchronous operation '" + bACIOperation + "' must take exactly one callback parameter.");
        }
        CallbackImpl callbackImpl = null;
        try {
            callbackImpl = new CallbackImpl(bACIOperation.getOperationDesc().parameters[n].type.id(), remoteResponseCallback);
        }
        catch (BadKind badKind) {
            throw new RemoteException("Error while trying to analyze typecode: " + (java.lang.Object)((java.lang.Object)badKind));
        }
        Object object = callbackImpl._this_object(this.orb);
        this.notifier.reportDebug("BACIRemoteAccess::internalInvokeInvocation", "Activated callback object for '" + bACIOperation + "'.");
        CBDescIn cBDescIn = new CBDescIn(1000000L, 5000000L, 0);
        objectArray[n] = object;
        if (n == objectArray.length - 1) {
            if (this.isStrict()) throw new IntrospectionInconsistentException("Callback cannot be the last argument, because it must be followed by the descriptor.");
            this.notifier.reportDebug("BACIRemoteAccess::internalInvokeInvocation", "Non-strict BACI invocation signature: callback is not followed by a descriptor.");
        } else {
            objectArray[n + 1] = cBDescIn;
        }
        BACIInvocation bACIInvocation = new BACIInvocation(5, bACIOperation.getName(), null, remoteResponseCallback, this.parent.getTree(), this);
        callbackImpl.setInvocation(bACIInvocation);
        bACIInvocation.setRemoteCall(this.internalInvokeTrivial(bACIRemote, bACIOperation, objectArray));
        ArrayList arrayList = this.invocations;
        synchronized (arrayList) {
            this.invocations.add(bACIInvocation);
        }
        this.notifier.reportDebug("BACIRemoteAccess::internalInvokeInvocation", "Remote call ended, constructed Invocation. Returning...");
        return bACIInvocation;
    }

    private static BACIRemoteNode getDeviceFromTarget(java.lang.Object object) {
        if (object instanceof BACIRemoteNode) {
            BACIRemoteNode bACIRemoteNode = (BACIRemoteNode)object;
            if (bACIRemoteNode.isDevice()) {
                return bACIRemoteNode;
            }
            return BACIRemoteAccess.getDeviceFromTarget(bACIRemoteNode.getParent());
        }
        if (object instanceof BACIInvocation) {
            BACIInvocation bACIInvocation = (BACIInvocation)object;
            return BACIRemoteAccess.getDeviceFromTarget(bACIInvocation.getParent());
        }
        return null;
    }

    private BACIRemoteCall internalInvokeTrivial(BACIRemote bACIRemote, Operation operation, java.lang.Object[] objectArray) {
        java.lang.Object[] objectArray2;
        String string;
        java.lang.Object object;
        int n;
        if (bACIRemote.getCORBARef() == null) {
            throw new RemoteException("Cannot invoke operation '" + operation.getName() + "' on object '" + bACIRemote.getName() + "' because it is not connected.");
        }
        this.notifier.reportDebug("BACIRemoteAccess::internalInvokeTrivial", "Preparing DII parameters for '" + bACIRemote.getName() + "." + operation.getName() + "()'.");
        java.lang.Object[] objectArray3 = this.baciIntrospector.prepareDIIparameters(((BACIOperation)operation).getOperationDesc(), objectArray);
        Object object2 = bACIRemote.getCORBARef();
        OperationDescription operationDescription = ((BACIOperation)operation).getOperationDesc();
        if (objectArray3.length != operationDescription.parameters.length) {
            throw new IllegalStateException("BACI introspector returned an array of values the length of which does not match CORBA parameter list, object = '" + bACIRemote.getName() + "', operation = '" + operation.getName() + "'.");
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("'");
            stringBuffer.append(operation.getParameterNames()[i]);
            stringBuffer.append("' = '");
            stringBuffer.append(objectArray[i]);
            stringBuffer.append("' ");
        }
        this.notifier.reportDebug("BACIRemoteAccess::internalInvokeTrivial", "Parameters for '" + operation.getName() + "': " + stringBuffer.toString());
        this.notifier.reportMessage("Invoking '" + bACIRemote.getName() + "." + operation.getName() + "()', parameters: " + stringBuffer.toString());
        Request request = object2._request(operation.getName());
        request.set_return_type(operationDescription.result);
        ExceptionList exceptionList = request.exceptions();
        ExceptionDescription[] exceptionDescriptionArray = operationDescription.exceptions;
        for (n = 0; n < exceptionDescriptionArray.length; ++n) {
            if (exceptionDescriptionArray[n].type.kind().value() != 22) {
                object = null;
                string = null;
                try {
                    string = this.baciIntrospector.IDtoClassName(exceptionDescriptionArray[n].type.id()) + "Helper";
                    object = Class.forName(string);
                }
                catch (Exception exception) {
                    throw new JavaIDLIntrospectionException("Failed to load class '" + string + "'. Introspection failed on typedef argument: " + exception);
                }
                Class[] classArray = new Class[]{};
                objectArray2 = new java.lang.Object[]{};
                try {
                    java.lang.Object object3 = ((Class)object).getMethod("type", classArray).invoke(null, objectArray2);
                    exceptionList.add((TypeCode)object3);
                    continue;
                }
                catch (Exception exception) {
                    throw new JavaIDLIntrospectionException("Dynamic invocation of 'internalInvokeTrivial' failed on a typedef argument. Class instance: " + ((Class)object).getName() + ". Exception:" + exception);
                }
            }
            exceptionList.add(exceptionDescriptionArray[n].type);
        }
        block31: for (n = 0; n < objectArray3.length; ++n) {
            object = null;
            if (operationDescription.parameters[n].mode == ParameterMode.PARAM_IN) {
                object = request.add_named_in_arg(operationDescription.parameters[n].name);
            } else if (operationDescription.parameters[n].mode == ParameterMode.PARAM_OUT) {
                object = request.add_named_out_arg(operationDescription.parameters[n].name);
                object.type(operationDescription.parameters[n].type);
            } else {
                object = request.add_named_inout_arg(operationDescription.parameters[n].name);
                object.type(operationDescription.parameters[n].type);
            }
            if (operationDescription.parameters[n].mode == ParameterMode.PARAM_OUT) continue;
            string = operationDescription.parameters[n].type;
            while (string.kind() == TCKind.tk_alias) {
                try {
                    string = string.content_type();
                }
                catch (BadKind badKind) {
                    throw new IntrospectionInconsistentException("BadKind thrown wile analysing alias typecode. Should be allowed by CORBA. Exception: " + (java.lang.Object)((java.lang.Object)badKind));
                }
            }
            int n2 = string.kind().value();
            switch (n2) {
                case 14: {
                    object.insert_Object((Object)objectArray3[n]);
                    continue block31;
                }
                case 15: 
                case 17: 
                case 21: {
                    this.baciIntrospector.insertTypedef(operationDescription.parameters[n], objectArray3[n], (Any)object);
                    continue block31;
                }
                case 7: {
                    object.insert_double(((Double)objectArray3[n]).doubleValue());
                    continue block31;
                }
                case 6: {
                    object.insert_float(((Float)objectArray3[n]).floatValue());
                    continue block31;
                }
                case 10: {
                    object.insert_octet(((Byte)objectArray3[n]).byteValue());
                    continue block31;
                }
                case 23: {
                    object.insert_longlong(((Long)objectArray3[n]).longValue());
                    continue block31;
                }
                case 24: {
                    object.insert_ulonglong(((Long)objectArray3[n]).longValue());
                    continue block31;
                }
                case 3: {
                    object.insert_long(((Integer)objectArray3[n]).intValue());
                    continue block31;
                }
                case 5: {
                    object.insert_ulong(((Integer)objectArray3[n]).intValue());
                    continue block31;
                }
                case 2: {
                    object.insert_short(((Short)objectArray3[n]).shortValue());
                    continue block31;
                }
                case 4: {
                    object.insert_ushort(((Short)objectArray3[n]).shortValue());
                    continue block31;
                }
                case 18: {
                    object.insert_string((String)objectArray3[n]);
                    continue block31;
                }
                case 9: {
                    object.insert_char(((Character)objectArray3[n]).charValue());
                    continue block31;
                }
                case 8: {
                    object.insert_boolean(((Boolean)objectArray3[n]).booleanValue());
                    continue block31;
                }
                case 19: 
                case 20: {
                    this.baciIntrospector.insertTypedef(operationDescription.parameters[n], objectArray3[n], (Any)object);
                    continue block31;
                }
                default: {
                    throw new IllegalArgumentException("Argument typecode '" + operationDescription.parameters[n].type.kind().value() + "' is not supported.");
                }
            }
        }
        if (operationDescription.mode == OperationMode.OP_ONEWAY) {
            this.notifier.reportDebug("BACIRemoteAccess::internalInvokeTrivial", "Sending oneway request '" + bACIRemote.getName() + "." + operation.getName() + "()'...");
            try {
                request.send_oneway();
                return new BACIRemoteCall(bACIRemote, (BACIOperation)operation, objectArray, null, null);
            }
            catch (Exception exception) {
                this.notifier.reportError("Exception during oneway remote invocation.", exception);
                return new BACIRemoteCall(bACIRemote, (BACIOperation)operation, objectArray, exception);
            }
        }
        n = 0;
        boolean bl = false;
        this.notifier.reportDebug("BACIRemoteAccess::internalInvokeTrivial", "Sending deferred request '" + bACIRemote.getName() + "." + operation.getName() + "()'.");
        try {
            request.send_deferred();
            while (!request.poll_response()) {
                try {
                    Thread.sleep(50L);
                    n += 50;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n <= POLL_TIMEOUT) continue;
                this.notifier.reportError("Timeout (" + POLL_TIMEOUT + " ms) while polling for response from '" + operation.getName() + "' on '" + bACIRemote.getName() + "'.");
                return new BACIRemoteCall(bACIRemote, (BACIOperation)operation, objectArray, true);
            }
            this.checkException(bACIRemote, request);
            this.notifier.reportDebug("BACIRemoteAccess::internalInvokeTrivial", "Received response for '" + bACIRemote.getName() + "." + operation.getName() + "()'.");
            string = request.return_value();
            java.lang.Object object4 = null;
            if (string != null) {
                object4 = this.baciIntrospector.extractAny((Any)string);
            }
            objectArray2 = this.baciIntrospector.extractOuts(request, operationDescription);
            bl = this.checkFromACSCompletion(object4);
            for (int i = 0; i < objectArray2.length; ++i) {
                bl |= this.checkFromACSCompletion(objectArray2[i]);
            }
            if (bACIRemote instanceof Invocation && this.baciIntrospector.isInvocationDestroyMethod(operation.getName())) {
                new CBTimer((BACIInvocation)bACIRemote).start();
            }
            this.notifier.reportDebug("BACIRemoteAccess::internalInvokeTrivial", "Successfully unpacked response for '" + bACIRemote.getName() + "." + operation.getName() + "()'.");
            BACIRemoteCall bACIRemoteCall = new BACIRemoteCall(bACIRemote, (BACIOperation)operation, objectArray, object4, objectArray2);
            bACIRemoteCall.setErrorResponse(bl);
            return bACIRemoteCall;
        }
        catch (Exception exception) {
            this.notifier.reportError("Exception during deferred remote invocation.", exception);
            return new BACIRemoteCall(bACIRemote, (BACIOperation)operation, objectArray, exception);
        }
    }

    private void logACSException(Exception exception) {
        if (exception instanceof UserException) {
            String string;
            String string2 = exception.getClass().getName();
            int n = string2.lastIndexOf(".");
            if (n < 0) {
                string = string2;
                string2 = "wrappers." + string2;
            } else {
                string = string2.substring(n + 1);
                string2 = string2.substring(0, n + 1) + "wrappers.AcsJ" + string;
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string2);
                Method method = clazz.getMethod("from" + string, exception.getClass());
                java.lang.Object object = method.invoke(null, exception);
                AcsJObjectExplorerReportEx acsJObjectExplorerReportEx = new AcsJObjectExplorerReportEx((Throwable)exception);
                acsJObjectExplorerReportEx.log(BACILogger.getLogger());
            }
            catch (Throwable throwable) {
                AcsJObjectExplorerReportEx acsJObjectExplorerReportEx = new AcsJObjectExplorerReportEx((Throwable)exception);
                acsJObjectExplorerReportEx.setContext("Logging a User Exception that is NOT an ACS Exception");
                acsJObjectExplorerReportEx.log(BACILogger.getLogger());
                this.notifier.reportDebug("BACIRemoteAccess::logACSExcpetion", "Failed to wrap user exception into native ACS Error System exception: " + throwable.getMessage() + " for '" + exception.getClass().getName() + "'.");
            }
        } else if (exception instanceof AcsJException) {
            AcsJObjectExplorerReportEx acsJObjectExplorerReportEx = new AcsJObjectExplorerReportEx((Throwable)exception);
            acsJObjectExplorerReportEx.log(BACILogger.getLogger());
        } else if (exception instanceof SystemException) {
            SystemException systemException = (SystemException)exception;
            AcsJCORBAProblemEx acsJCORBAProblemEx = new AcsJCORBAProblemEx((Throwable)exception);
            acsJCORBAProblemEx.setMinor(systemException.minor);
            acsJCORBAProblemEx.setCompletionStatus(systemException.completed.value());
            acsJCORBAProblemEx.setInfo(systemException.toString());
            AcsJObjectExplorerReportEx acsJObjectExplorerReportEx = new AcsJObjectExplorerReportEx((Throwable)acsJCORBAProblemEx);
            acsJObjectExplorerReportEx.log(BACILogger.getLogger());
        } else {
            AcsJUnexpectedExceptionEx acsJUnexpectedExceptionEx = new AcsJUnexpectedExceptionEx((Throwable)exception);
            AcsJObjectExplorerReportEx acsJObjectExplorerReportEx = new AcsJObjectExplorerReportEx((Throwable)acsJUnexpectedExceptionEx);
            acsJObjectExplorerReportEx.log(BACILogger.getLogger());
            this.notifier.reportDebug("BACIRemoteAccess::logACSException", "Received an unexpected exception:  '" + exception.getClass().getName() + "'.");
        }
    }

    private boolean checkFromACSCompletion(java.lang.Object object) {
        if (object instanceof Completion) {
            AcsJCompletion acsJCompletion;
            Completion completion = (Completion)object;
            if (completion.type != 0 && (acsJCompletion = AcsJCompletion.fromCorbaCompletion((Completion)completion)).getAcsJException() != null) {
                acsJCompletion.getAcsJException().log(BACILogger.getLogger());
                return true;
            }
        }
        return false;
    }

    private int choiceForNonStickyComponentConnection(String string) {
        java.lang.Object[] objectArray = new String[]{"get a \"sticky references\" for just this component", "switch to \"sticky mode\" from now on", "cancel the operation"};
        int n = JOptionPane.showOptionDialog(this.notifier.getParent(), string, "Non-Sticky reference", -1, 2, null, objectArray, objectArray[0]);
        return n;
    }

    private void internalManagerConnect(BACIRemoteNode bACIRemoteNode) throws AcsJObjectExplorerConnectEx {
        java.lang.Object object;
        String string = (String)bACIRemoteNode.getUserObject();
        this.notifier.reportDebug("BACIRemoteAccess::internalManagerConnect", "Requesting component: '" + string + "', activate = true");
        this.notifier.reportMessage("Connecting to '" + string + "'.");
        bACIRemoteNode.setNonSticky(this.connectNonSticky);
        Object object2 = null;
        if (this.connectNonSticky) {
            try {
                object2 = this.manager.get_component_non_sticky(this.handle, string);
            }
            catch (Throwable throwable) {
                object = "Connection to component '" + string + "' failed. \n" + "'Connect as non-sticky' mode is enabled: in this mode component will not be activated by ObjectExplorer,\n" + "only already activated components can be accessed.";
                int n = this.choiceForNonStickyComponentConnection((String)object);
                switch (n) {
                    case 0: {
                        bACIRemoteNode.setNonSticky(false);
                        System.out.println("BACIRemoteAccess.internalManagerConnect setNonSticky to " + bACIRemoteNode.isNonSticky() + " @ " + bACIRemoteNode.hashCode());
                        break;
                    }
                    case 1: {
                        this.baciEngineMenu.setNonSticky(false);
                        bACIRemoteNode.setNonSticky(false);
                        break;
                    }
                    case 2: {
                        AcsJObjectExplorerConnectEx acsJObjectExplorerConnectEx = new AcsJObjectExplorerConnectEx(throwable);
                        acsJObjectExplorerConnectEx.setCurl(string);
                        throw acsJObjectExplorerConnectEx;
                    }
                    default: {
                        this.notifier.reportError("Unexpected choice.");
                        AcsJObjectExplorerConnectEx acsJObjectExplorerConnectEx = new AcsJObjectExplorerConnectEx(throwable);
                        acsJObjectExplorerConnectEx.setCurl(string);
                        throw acsJObjectExplorerConnectEx;
                    }
                }
            }
        }
        try {
            if (object2 == null) {
                object2 = this.manager.get_component(this.handle, string, true);
            }
            this.notifier.reportDebug("BACIRemoteAccess::internalManagerConnect", "Manager returns OK");
        }
        catch (Throwable throwable) {
            this.notifier.reportError("Connection to component '" + string + "' failed.");
            object = new AcsJObjectExplorerConnectEx(throwable);
            object.setCurl(string);
            throw object;
        }
        String string2 = null;
        try {
            this.notifier.reportDebug("BACIRemoteAccess::internalManagerConnect", "Querying component '" + string + "' for CORBA type id.");
            object = this.manager.get_component_info(this.handle, new int[0], string, "*", true);
            if (((ComponentInfo[])object).length != 1) {
                AcsJObjectExplorerConnectEx acsJObjectExplorerConnectEx = new AcsJObjectExplorerConnectEx();
                acsJObjectExplorerConnectEx.setReason("Manager did not return valid ComponentInfo for '" + string + "'.");
                throw acsJObjectExplorerConnectEx;
            }
            string2 = object[0].type;
            this.notifier.reportDebug("BACIRemoteAccess::internalManagerConnect", "component '" + string + "' has id: " + string2);
        }
        catch (Exception exception) {
            this.notifier.reportError("Cannot retrieve Interface Repository ID for component '" + string + "'", exception);
            AcsJObjectExplorerConnectEx acsJObjectExplorerConnectEx = new AcsJObjectExplorerConnectEx((Throwable)exception);
            acsJObjectExplorerConnectEx.setCurl(string);
            throw acsJObjectExplorerConnectEx;
        }
        bACIRemoteNode.setCORBARef(object2);
        try {
            bACIRemoteNode.setIFDesc(this.getIFDesc(string2));
            if (bACIRemoteNode.getIFDesc() == null) {
                object = new AcsJObjectExplorerConnectEx();
                object.setCurl(string);
                object.setReason("Cannot retrieve Interface Repository description for component for '" + string + "'.");
                throw object;
            }
            this.notifier.reportDebug("BACIRemoteAccess::internalManagerConnect", "IR Query OK.");
        }
        catch (Exception exception) {
            java.lang.Object object3;
            bACIRemoteNode.setCORBARef(null);
            this.notifier.reportError("Failed to retrieve interface description from IR, releasing component on Manager, if needed.", exception);
            try {
                if (this.manager != null && object2 != null && !bACIRemoteNode.isNonSticky()) {
                    this.manager.release_component(this.handle, string);
                }
            }
            catch (NoPermissionEx noPermissionEx) {
                this.notifier.reportError("No permission to release component", noPermissionEx);
                object3 = new AcsJNoPermissionEx((Throwable)noPermissionEx);
                this.logACSException((Exception)object3);
            }
            AcsJObjectExplorerInterfaceRepositoryAccessEx acsJObjectExplorerInterfaceRepositoryAccessEx = new AcsJObjectExplorerInterfaceRepositoryAccessEx((Throwable)exception);
            acsJObjectExplorerInterfaceRepositoryAccessEx.setCurl(string);
            acsJObjectExplorerInterfaceRepositoryAccessEx.setIRid(string2);
            object3 = new AcsJObjectExplorerConnectEx((Throwable)acsJObjectExplorerInterfaceRepositoryAccessEx);
            object3.setCurl(string);
            throw object3;
        }
        this.notifier.reportMessage("Connected to '" + string + "'.");
    }

    public void synchronizeInternalParentConnect(BACIRemoteNode bACIRemoteNode) {
        this.internalParentConnect(bACIRemoteNode, false);
    }

    private void internalParentConnect(BACIRemoteNode bACIRemoteNode) {
        this.internalParentConnect(bACIRemoteNode, true);
    }

    private void internalParentConnect(BACIRemoteNode bACIRemoteNode, boolean bl) {
        java.lang.Object object;
        String string = null;
        TypeCode typeCode = null;
        String string2 = null;
        if (bACIRemoteNode.getNodeType() == 4) {
            object = (AttributeDescription)bACIRemoteNode.getUserObject();
            try {
                string2 = ((AttributeDescription)object).type.id();
            }
            catch (BadKind badKind) {
                throw new RemoteException("IDL: BadKind thrown on type id lookup for PROPERTY child of the remote node: " + (java.lang.Object)((java.lang.Object)badKind));
            }
            string = BACIIntrospector.attributeNameToMethodName(((AttributeDescription)object).name);
            typeCode = ((AttributeDescription)object).type;
            this.notifier.reportDebug("BACIRemoteAccess::internalParentConnect", "Obtaining IDL attribute reference for '" + ((AttributeDescription)object).name + "'.");
        } else if (bACIRemoteNode.getNodeType() == 3) {
            object = (OperationDescription)bACIRemoteNode.getUserObject();
            try {
                string2 = ((OperationDescription)object).result.id();
            }
            catch (BadKind badKind) {
                throw new RemoteException("IDL: BadKind thrown on type id lookup for PROPERTY child of the remote node: " + (java.lang.Object)((java.lang.Object)badKind));
            }
            string = ((OperationDescription)object).name;
            typeCode = ((OperationDescription)object).result;
            this.notifier.reportDebug("BACIRemoteAccess::internalParentConnect", "Obtaining reference to contained object through property accessor design pattern for '" + ((OperationDescription)object).name + ".");
        } else {
            throw new IntrospectionInconsistentException("Devices can contain objects only as IDL attributes or property accessor design patterns. Failed on '" + bACIRemoteNode + "'.");
        }
        object = (BACIRemoteNode)bACIRemoteNode.getParent();
        if (((BACIRemoteNode)object).getCORBARef() == null) {
            ((BACIRemoteNode)object).connect();
            if (((BACIRemoteNode)object).getCORBARef() == null) {
                throw new RemoteException("Child node is accessible although the parent node CORBA reference is null. Failed on '" + bACIRemoteNode + ".");
            }
        }
        Request request = ((BACIRemoteNode)object).getCORBARef()._request(string);
        request.set_return_type(typeCode);
        this.notifier.reportDebug("BACIRemoteAccess::internalParentConnect", "Invoking remote call...");
        request.invoke();
        Any any = request.return_value();
        if (any.type().kind() != TCKind.tk_objref) {
            throw new IntrospectionInconsistentException("Return type of '" + string + "' is not of type object reference, expected object reference because of BACI containment specifications.");
        }
        bACIRemoteNode.setCORBARef(any.extract_Object());
        bACIRemoteNode.setIFDesc(this.getIFDesc(string2));
        if (bACIRemoteNode.getCORBARef() != null) {
            this.notifier.reportDebug("BACIRemoteAccess::internalParentConnect", "Connection to contained object OK.");
        } else {
            this.notifier.reportError("Reference returned when resolving contained object '" + string + "' is null.");
        }
    }

    java.lang.Object invoke(BACIRemote bACIRemote, BACIOperation bACIOperation, java.lang.Object[] objectArray, RemoteResponseCallback remoteResponseCallback) {
        if (bACIRemote == null) {
            throw new NullPointerException("node");
        }
        if (bACIOperation == null) {
            throw new NullPointerException("op");
        }
        if (objectArray == null) {
            throw new NullPointerException("explicitParams: must not be null, for void argument type return new Object[0]");
        }
        if (!bACIOperation.isInvocation()) {
            return this.internalInvokeTrivial(bACIRemote, bACIOperation, objectArray);
        }
        if (remoteResponseCallback == null) {
            throw new NullPointerException("cb");
        }
        return this.internalInvokeInvocation(bACIRemote, bACIOperation, objectArray, remoteResponseCallback);
    }

    BACIRemoteCall invokeAccessor(BACIAttribute bACIAttribute) {
        if (bACIAttribute == null) {
            throw new NullPointerException("att");
        }
        BACIRemote bACIRemote = (BACIRemote)bACIAttribute.getIntrospectable();
        if (bACIRemote.getCORBARef() == null) {
            throw new RemoteException("Cannot invoke attribute accessor '" + bACIAttribute + "' on object '" + bACIRemote.getName() + "' because it is not connected.");
        }
        Object object = bACIRemote.getCORBARef();
        AttributeDescription attributeDescription = bACIAttribute.getAttributeDesc();
        Request request = object._request(BACIIntrospector.attributeNameToMethodName(attributeDescription.name));
        request.set_return_type(attributeDescription.type);
        java.lang.Object[] objectArray = new java.lang.Object[]{};
        int n = 0;
        this.notifier.reportMessage("Invoking accessor '" + bACIRemote.getName() + "." + bACIAttribute + "()'.");
        this.notifier.reportDebug("BACIRemoteAccess::invokeAccessor", "Sending deferred attribute accessor '" + bACIRemote.getName() + "." + bACIAttribute + "()'.");
        try {
            request.send_deferred();
            while (!request.poll_response()) {
                try {
                    Thread.sleep(50L);
                    n += 50;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n <= POLL_TIMEOUT) continue;
                this.notifier.reportError("Timeout (" + POLL_TIMEOUT + " ms) while polling for response from '" + bACIAttribute + "' on '" + bACIRemote.getName() + "'.");
                return new BACIRemoteCall(bACIRemote, bACIAttribute, objectArray, null, true, null);
            }
            this.checkException(bACIRemote, request);
            this.notifier.reportDebug("BACIRemoteAccess::invokeAccessor", "Received response for '" + bACIRemote.getName() + "." + bACIAttribute + "()'.");
            Any any = request.return_value();
            java.lang.Object object2 = null;
            if (any != null) {
                object2 = this.baciIntrospector.extractAny(any);
            }
            this.notifier.reportDebug("BACIRemoteAccess::invokeAccessor", "Successfully unpacked response for '" + bACIRemote.getName() + "." + bACIAttribute + "()'.");
            return new BACIRemoteCall(bACIRemote, bACIAttribute, objectArray, object2, false, null);
        }
        catch (Exception exception) {
            this.notifier.reportError("Exception during deferred remote invocation.", exception);
            return new BACIRemoteCall(bACIRemote, bACIAttribute, objectArray, null, false, exception);
        }
    }

    private void checkException(java.lang.Object object, Request request) throws Exception {
        Exception exception = request.env().exception();
        if (exception != null) {
            BACIRemoteNode bACIRemoteNode = BACIRemoteAccess.getDeviceFromTarget(object);
            if (bACIRemoteNode != null && bACIRemoteNode.isNonSticky() && exception instanceof OBJECT_NOT_EXIST) {
                try {
                    bACIRemoteNode.disconnect();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                throw new NonStickyComponentReleased("Non-sticky component released, disconnecting it automatically.");
            }
            if (exception instanceof UnknownUserException) {
                Any any = ((UnknownUserException)exception).except;
                java.lang.Object object2 = this.baciIntrospector.extractAny(any);
                exception = (UserException)object2;
            }
            this.logACSException(exception);
            throw exception;
        }
    }

    BACIRemoteCall invokeMutator(BACIAttribute bACIAttribute) {
        this.notifier.reportError("Attribute mutators are not implemented yet: BACI does not specify any design pattern with mutable attributes.");
        return null;
    }

    boolean isStrict() {
        return "true".equals(strict);
    }

    public Contained lookupId(String string) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        return this.rep.lookup_id(string);
    }

    private void resolveManager() {
        Object object;
        if (this.managerLoc == null) {
            throw new IllegalStateException("Cannot resolve manager corbaloc when it is null.");
        }
        try {
            object = this.orb.string_to_object(this.managerLoc);
            this.notifier.reportDebug("BACIRemoteAccess::resolveManager", "Manager reference string_to_object OK with managerLoc = '" + this.managerLoc + "'.");
            this.manager = ManagerHelper.narrow((Object)object);
            this.notifier.reportDebug("BACIRemoteAccess::resolveManager", "Manager reference narrowing OK.");
            this.notifier.reportMessage("Obtained reference to 'Manager'.");
            if (this.manager == null) {
                throw new NullPointerException("Manager is null after ManagerHelper.narrow()");
            }
        }
        catch (Exception exception) {
            throw new RemoteException("Could not resolve manager reference: " + exception);
        }
        try {
            this.client = new ClientImpl();
            object = this.client._this(this.orb);
            this.notifier.reportDebug("BACIRemoteAccess::resolveManager", "Instantiated Client servant.");
            ClientInfo clientInfo = this.manager.login((Client)object);
            if (clientInfo == null) {
                throw new Exception("Failed to login to the manager when returned ClientInfo is null.");
            }
            this.handle = clientInfo.h;
            this.notifier.reportDebug("BACIRemoteAccess::resolveManager", "Manager login OK.");
        }
        catch (Exception exception) {
            throw new RemoteException("Cannot login to the manager: " + exception);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                BACIRemoteAccess.this.notifier.reportDebug("BACIRemoteAccess::resolveManager", "Initializing remote logging...");
                ClientLogManager.getAcsLogManager().initRemoteLogging(BACIRemoteAccess.this.orb, BACIRemoteAccess.this.manager, BACIRemoteAccess.this.handle, true);
                BACIRemoteAccess.this.notifier.reportDebug("BACIRemoteAccess::resolveManager", "Remote logging initialized.");
            }
        }, "InitRemoteLogging").start();
    }

    @Override
    public void run() {
        this.notifier.reportDebug("BACIRemoteAccess::run", "Starting ORB thread...");
        this.orb.run();
    }

    public void setCaching(boolean bl) {
        this.bufferDescs = bl;
    }

    public void setConnectNonSticky(boolean bl) {
        this.connectNonSticky = bl;
    }

    private static final class BACIOperationNameComparator
    implements Comparator<Operation> {
        private BACIOperationNameComparator() {
        }

        @Override
        public int compare(Operation operation, Operation operation2) {
            return operation.getName().compareTo(operation2.getName());
        }
    }

    private static final class BACIAttributeNameComparator
    implements Comparator<Attribute> {
        private BACIAttributeNameComparator() {
        }

        @Override
        public int compare(Attribute attribute, Attribute attribute2) {
            return attribute.toString().compareTo(attribute2.toString());
        }
    }

    public class Dispatcher
    extends Thread {
        private static final int MAX_QUEUE = 100;
        private LinkedList queue;
        private boolean working;

        public Dispatcher() {
            super("ObjectExplorerDispatcher");
            this.queue = new LinkedList();
            this.working = true;
            this.setPriority(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(BACIRemoteResponse bACIRemoteResponse) {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                boolean bl = false;
                if (this.queue.size() >= 100) {
                    for (int i = 0; i < this.queue.size(); ++i) {
                        if (((BACIRemoteResponse)this.queue.get(i)).getInvocation() != bACIRemoteResponse.getInvocation()) continue;
                        this.queue.set(i, bACIRemoteResponse);
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    this.queue.addLast(bACIRemoteResponse);
                }
                this.queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.working = false;
                this.queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.working) {
                try {
                    BACIRemoteResponse bACIRemoteResponse = null;
                    AbstractList abstractList = this.queue;
                    synchronized (abstractList) {
                        while (this.queue.isEmpty()) {
                            try {
                                this.queue.wait(100L);
                                if (this.working) continue;
                                BACIRemoteAccess.this.notifier.reportDebug("BACIRemoteAccess$Dispatcher::run", "Dispatcher thread returning gracefully.");
                                return;
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                        if (!this.working) {
                            return;
                        }
                        bACIRemoteResponse = (BACIRemoteResponse)this.queue.getFirst();
                        if (bACIRemoteResponse.getInvocation().getInvocationRequest() == null) {
                            this.queue.removeFirst();
                            this.queue.addLast(bACIRemoteResponse);
                            try {
                                if (this.queue.size() == 1) {
                                    Dispatcher.sleep(25L);
                                }
                                Dispatcher.yield();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                        bACIRemoteResponse = (BACIRemoteResponse)this.queue.removeFirst();
                    }
                    bACIRemoteResponse.cb.responseReceived(bACIRemoteResponse);
                    if (!bACIRemoteResponse.destroy) continue;
                    bACIRemoteResponse.cb.invocationDestroyed();
                    abstractList = BACIRemoteAccess.this.invocations;
                    synchronized (abstractList) {
                        BACIRemoteAccess.this.invocations.remove(bACIRemoteResponse.getInvocation());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private class CallbackImpl
    extends DynamicImplementation {
        private String[] allIDs = new String[1];
        private RemoteResponseCallback cb = null;
        private InterfaceDef def = null;
        private String callbackID = null;
        private BACIInvocation invoc = null;
        public static final int MAX_CB_HASH = 1000;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CallbackImpl(String string, RemoteResponseCallback remoteResponseCallback) {
            if (string == null) {
                throw new NullPointerException("callbackID");
            }
            if (remoteResponseCallback == null) {
                throw new NullPointerException("cb");
            }
            this.callbackID = string;
            this.cb = remoteResponseCallback;
            this.allIDs[0] = string;
            this.def = (InterfaceDef)descriptions.get(string);
            if (this.def == null) {
                HashMap hashMap = descriptions;
                synchronized (hashMap) {
                    if (descriptions.size() > 1000) {
                        descriptions.clear();
                    }
                }
                this.def = InterfaceDefHelper.narrow((Object)BACIRemoteAccess.this.rep.lookup_id(string));
                if (this.def == null) {
                    throw new RemoteException("Cannot lookup IR record for callback '" + string + "'.");
                }
                hashMap = descriptions;
                synchronized (hashMap) {
                    BACIRemoteAccess.this.notifier.reportDebug("BACIRemoteAccess$CallbackImpl::CallbackImpl", "Added 'InterfaceDef' for '" + string + "' to cache.");
                    descriptions.put(string, this.def);
                }
            }
        }

        public void setInvocation(BACIInvocation bACIInvocation) {
            if (bACIInvocation == null) {
                throw new NullPointerException("invoc");
            }
            this.invoc = bACIInvocation;
        }

        public String[] _all_interfaces(POA pOA, byte[] byArray) {
            return this.allIDs;
        }

        private String createHashKey(String string, String string2) {
            return string + "#" + string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(ServerRequest serverRequest) {
            NVList nVList;
            HashMap hashMap;
            java.lang.Object object;
            if (serverRequest == null) {
                BACIRemoteAccess.this.getNotifier().reportError("Callback implementation has received a 'null' ServerRequest object from CORBA DSI skeleton.");
                return;
            }
            String string = serverRequest.operation();
            String string2 = this.createHashKey(this.callbackID, string);
            OperationDef operationDef = (OperationDef)descriptions.get(string2);
            if (operationDef == null) {
                try {
                    BACIRemoteAccess.this.notifier.reportDebug("BACIRemoteAccess$CallbackImpl::invoke", "Looking up operation definition for '" + this.def.name() + "." + serverRequest.operation() + "()' from IR.");
                    operationDef = OperationDefHelper.narrow((Object)this.def.lookup(serverRequest.operation()));
                    object = operationDef.params();
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        if (((ParameterDescription)object[i]).mode == ParameterMode.PARAM_IN) continue;
                        BACIRemoteAccess.this.getNotifier().reportError("Operation '" + this.callbackID + "::" + operationDef.name() + "()' declares other parameters than CORBA IN. BACI does not allow such callbacks. Skipping.");
                        return;
                    }
                }
                catch (Exception exception) {
                    BACIRemoteAccess.this.getNotifier().reportError("Lookup for operation '" + string + "' failed in Interface Repository.", exception);
                    return;
                }
                object = descriptions;
                synchronized (object) {
                    BACIRemoteAccess.this.notifier.reportDebug("BACIRemoteAccess$CallbackImpl::invoke", "Added 'OperationDef' for '" + this.callbackID + "::" + string + "()' to cache.");
                    descriptions.put(string2, operationDef);
                }
            }
            object = null;
            java.lang.Object[] objectArray = null;
            boolean bl = false;
            try {
                hashMap = operationListDescriptions;
                synchronized (hashMap) {
                    int n;
                    nVList = (NVList)operationListDescriptions.get(string2);
                    if (nVList == null) {
                        nVList = BACIRemoteAccess.this.orb.create_operation_list((Object)operationDef);
                        HashMap hashMap2 = operationListDescriptions;
                        synchronized (hashMap2) {
                            BACIRemoteAccess.this.notifier.reportDebug("BACIRemoteAccess$CallbackImpl::invoke", "Added 'NVList' for '" + this.callbackID + "::" + string + "()' to cache.");
                            operationListDescriptions.put(string2, nVList);
                        }
                    }
                    serverRequest.arguments(nVList);
                    int n2 = nVList.count();
                    objectArray = new java.lang.Object[n2];
                    object = new String[n2];
                    for (n = 0; n < n2; ++n) {
                        objectArray[n] = BACIRemoteAccess.this.getIntrospector().extractAny(nVList.item(n).value());
                        object[n] = nVList.item(n).name();
                    }
                    for (n = 0; n < n2; ++n) {
                        bl |= BACIRemoteAccess.this.checkFromACSCompletion(objectArray[n]);
                    }
                }
            }
            catch (Bounds bounds) {
                BACIRemoteAccess.this.getNotifier().reportError("The callback parameter list returned by the server and the IR data do not agree in length. Skipping.", bounds);
                return;
            }
            catch (Exception exception) {
                BACIRemoteAccess.this.getNotifier().reportError("Exception while unpacking callback parameter list.", exception);
            }
            hashMap = BACIRemoteAccess.this.orb.get_primitive_tc(TCKind.tk_void);
            nVList = BACIRemoteAccess.this.orb.create_any();
            nVList.type((TypeCode)hashMap);
            serverRequest.set_result((Any)nVList);
            BACIRemoteResponse bACIRemoteResponse = new BACIRemoteResponse(this.invoc, string, (String[])object, objectArray);
            bACIRemoteResponse.setErrorResponse(bl);
            bACIRemoteResponse.cb = this.cb;
            if (BACIRemoteAccess.this.baciIntrospector.isInvocationDoneMethod(string) || this.invoc.isDestroyRequested()) {
                bACIRemoteResponse.destroy = true;
                POA pOA = this._default_POA();
                try {
                    byte[] byArray = pOA.servant_to_id((Servant)this);
                    pOA.deactivate_object(byArray);
                    BACIRemoteAccess.this.notifier.reportDebug("BACIRemoteAccess$CallbackImpl::invoke", "Destroyed callback implementation.");
                }
                catch (Exception exception) {
                    BACIRemoteAccess.this.notifier.reportError("POA cannot deactivate callback: " + exception);
                }
            }
            BACIRemoteAccess.this.getDispatcher().add(bACIRemoteResponse);
        }
    }

    private class ClientImpl
    extends ClientPOA {
        private final long startTimeUTClong = UTCUtility.utcJavaToOmg((long)System.currentTimeMillis());
        private long executionId = -1L;

        private ClientImpl() {
        }

        public void disconnect() {
            new ServerMessage(new ServerMessageHolder(1, "Disconnect requested by the manager. Destroying RemoteAccess.", true)).start();
            BACIRemoteAccess.this.destroy();
        }

        public String name() {
            return "ObjectExplorer";
        }

        public AuthenticationData authenticate(long l, String string) {
            if (this.executionId < 0L) {
                this.executionId = l;
            }
            AuthenticationData authenticationData = new AuthenticationData("C", ClientType.CLIENT_TYPE, ImplLangType.JAVA, false, this.startTimeUTClong, this.executionId);
            return authenticationData;
        }

        public void message(short s, String string) {
            new ServerMessage(new ServerMessageHolder(0, "Manager message: '" + string + "' (code " + s + ").", false)).start();
        }

        public void taggedmessage(short s, short s2, String string) {
        }

        public void components_unavailable(String[] stringArray) {
        }

        public void components_available(ComponentInfo[] componentInfoArray) {
        }

        public boolean ping() {
            return true;
        }
    }

    private class CBTimer
    extends Thread {
        private BACIInvocation invoc = null;

        public CBTimer(BACIInvocation bACIInvocation) {
            if (bACIInvocation == null) {
                throw new NullPointerException("Invoc");
            }
            this.invoc = bACIInvocation;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(POLL_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.invoc.destroyDueToTimeout();
        }
    }

    private class ServerMessage
    extends Thread {
        private ServerMessageHolder hldr = null;

        public ServerMessage(ServerMessageHolder serverMessageHolder) {
            this.hldr = serverMessageHolder;
        }

        @Override
        public void run() {
            if (this.hldr == null) {
                return;
            }
            if (this.hldr.code == 0) {
                BACIRemoteAccess.this.notifier.reportMessage(this.hldr.message);
            } else if (this.hldr.code == 1) {
                BACIRemoteAccess.this.notifier.reportError(this.hldr.message);
            }
        }
    }

    private class ServerMessageHolder {
        public static final short MSG = 0;
        public static final short ERR = 1;
        public boolean shutdown = false;
        public short code = 0;
        public String message = null;

        public ServerMessageHolder(short s, String string, boolean bl) {
            this.code = s;
            this.shutdown = bl;
            this.message = string;
        }
    }
}

