/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer.engine.BACI;

import alma.ACS.CBDescIn;
import alma.ACS.Callback;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.omg.CORBA.Any;
import org.omg.CORBA.AttributeDescription;
import org.omg.CORBA.AttributeMode;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.Contained;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.Request;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import si.ijs.acs.objectexplorer.engine.BACI.BACIAttribute;
import si.ijs.acs.objectexplorer.engine.BACI.BACIInvocation;
import si.ijs.acs.objectexplorer.engine.BACI.BACIOperation;
import si.ijs.acs.objectexplorer.engine.BACI.BACIRemote;
import si.ijs.acs.objectexplorer.engine.BACI.BACIRemoteAccess;
import si.ijs.acs.objectexplorer.engine.BACI.JavaIDLIntrospectionException;
import si.ijs.acs.objectexplorer.engine.IntrospectionInconsistentException;
import si.ijs.acs.objectexplorer.engine.Operation;
import si.ijs.acs.objectexplorer.engine.RemoteCall;
import si.ijs.acs.objectexplorer.engine.RemoteException;

public class BACIIntrospector {
    private BACIRemoteAccess ra = null;
    private HashMap IDLtoJavaMapping = new HashMap();
    public static final String ID_CORBA_OBJECT = "IDL:omg.org/CORBA/Object:1.0";
    public static final String ID_PROPERTY = "IDL:alma/ACS/Property:1.0";
    public static final String ID_CALLBACK = "IDL:alma/ACS/Callback:1.0";
    public static final String ID_DEVICE = "IDL:alma/ACS/ACSComponent:1.0";
    public static final String ID_SUBSCRIPTION = "IDL:alma/ACS/Subscription:1.0";
    public static final String ID_CBDESCIN = "IDL:alma/ACS/CBDescIn:1.0";
    public static final String METHOD_DONE = "done";
    public static final String METHOD_DESTROY = "destroy";
    public static final String IDL_PACKAGE_PREFIX = "alma.";
    public static final String BACI_PACKAGE_PREFIX = "alma.ACS.";

    public BACIIntrospector(BACIRemoteAccess bACIRemoteAccess) {
        if (bACIRemoteAccess == null) {
            throw new NullPointerException("ra");
        }
        this.ra = bACIRemoteAccess;
    }

    public static String addIDLPackagePrefix(String string) {
        if (string == null) {
            throw new NullPointerException("arg");
        }
        return string;
    }

    public static String addJavaPackagePrefix(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        return string;
    }

    public static String attributeNameToMethodName(String string) {
        if (string == null) {
            throw new NullPointerException("propertyName");
        }
        return "_get_" + string;
    }

    public static void destroyInvocation(BACIInvocation bACIInvocation) {
        if (bACIInvocation == null) {
            throw new NullPointerException("invoc");
        }
        if (bACIInvocation.isDestroyed()) {
            return;
        }
        Operation[] operationArray = bACIInvocation.getOperations();
        Operation operation = null;
        for (int i = 0; i < operationArray.length; ++i) {
            if (!METHOD_DESTROY.equals(operationArray[i].getName())) continue;
            operation = operationArray[i];
            if (operation.getParameterTypes().length == 0) break;
            throw new IntrospectionInconsistentException("Operation destroy' on a 'Subscription' instance '" + bACIInvocation + "' must take exactly 0 parameters.");
        }
        if (operation == null) {
            throw new IntrospectionInconsistentException("'Subscription' instance for invocation '" + bACIInvocation + "' does not declare a 'destroy()' method.");
        }
        bACIInvocation.ra.invoke(bACIInvocation, (BACIOperation)operation, new java.lang.Object[0], null);
    }

    public java.lang.Object extractAny(Any any) {
        if (any == null) {
            throw new NullPointerException("argument");
        }
        return this.extractAny(any.type(), any);
    }

    public java.lang.Object extractAny(TypeCode typeCode, Any any) {
        if (typeCode == null) {
            throw new NullPointerException("argumentType");
        }
        if (any == null) {
            throw new NullPointerException("argument");
        }
        switch (typeCode.kind().value()) {
            case 11: {
                return this.extractAny(any.extract_any());
            }
            case 0: 
            case 1: {
                return null;
            }
            case 14: {
                return any.extract_Object();
            }
            case 15: 
            case 21: 
            case 22: {
                return this.extractTypedef(any);
            }
            case 17: {
                java.lang.Object object = this.extractTypedef(any);
                Class<?> clazz = object.getClass();
                try {
                    Field[] fieldArray = clazz.getDeclaredFields();
                    for (int i = 0; i < fieldArray.length; ++i) {
                        if (fieldArray[i].getType() != clazz) continue;
                        try {
                            if (!fieldArray[i].get(object).equals(object)) continue;
                            return fieldArray[i].getName();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return object;
                }
                catch (Throwable throwable) {
                    return object;
                }
            }
            case 7: {
                return new Double(any.extract_double());
            }
            case 6: {
                return new Float(any.extract_float());
            }
            case 10: {
                return new Short((short)(any.extract_octet() & 0xFF));
            }
            case 23: {
                return new Long(any.extract_longlong());
            }
            case 24: {
                return new Long(any.extract_ulonglong());
            }
            case 3: {
                return new Integer(any.extract_long());
            }
            case 5: {
                return new Integer(any.extract_ulong());
            }
            case 2: {
                return new Short(any.extract_short());
            }
            case 4: {
                return new Short(any.extract_ushort());
            }
            case 18: {
                return any.extract_string();
            }
            case 9: {
                return new Character(any.extract_char());
            }
            case 8: {
                return new Boolean(any.extract_boolean());
            }
        }
        throw new IllegalArgumentException("Argument typecode '" + typeCode.kind().value() + "' is not supported.");
    }

    public InvocationObjectHolder extractInvocationObject(RemoteCall remoteCall) {
        if (remoteCall == null) {
            throw new NullPointerException("call");
        }
        if (!(remoteCall.getSyncReturnValue() instanceof Object)) {
            return new InvocationObjectHolder(null, null);
        }
        Object object = (Object)remoteCall.getSyncReturnValue();
        if (!object._is_a(ID_SUBSCRIPTION)) {
            throw new IntrospectionInconsistentException("Remote call '" + remoteCall.getSN() + "' that produced an 'Invocation' returns a CORBA object, which does not implement 'Subscription' interface.");
        }
        try {
            return new InvocationObjectHolder(object, ((BACIOperation)remoteCall.getOperation()).getOperationDesc().result.id());
        }
        catch (BadKind badKind) {
            throw new RemoteException("CORBA BadKind exception thrown while analysing typecode for 'Subscription' descendant. Should be a valid IDL operation.");
        }
    }

    public java.lang.Object[] extractOuts(Request request, OperationDescription operationDescription) {
        if (request == null) {
            throw new NullPointerException("req");
        }
        if (operationDescription == null) {
            throw new NullPointerException("desc");
        }
        java.lang.Object[] objectArray = new java.lang.Object[operationDescription.parameters.length];
        for (int i = 0; i < operationDescription.parameters.length; ++i) {
            if (operationDescription.parameters[i].mode != ParameterMode.PARAM_IN) {
                try {
                    objectArray[i] = this.extractAny(request.arguments().item(i).value());
                    continue;
                }
                catch (Bounds bounds) {
                    throw new IntrospectionInconsistentException("Request object and operation description object for operation '" + operationDescription.name + "' declare different number of arguments to remote function.");
                }
            }
            objectArray[i] = null;
        }
        return objectArray;
    }

    public java.lang.Object extractTypedef(Any any) {
        if (any == null) {
            throw new NullPointerException("argument");
        }
        return this.extractTypedef(any.type(), any);
    }

    public java.lang.Object extractTypedef(TypeCode typeCode, Any any) {
        if (typeCode == null) {
            throw new NullPointerException("argumentType");
        }
        if (any == null) {
            throw new NullPointerException("argument");
        }
        Class<?> clazz = null;
        String string = null;
        try {
            string = this.IDtoClassName(typeCode.id()) + "Helper";
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new JavaIDLIntrospectionException("Failed to load class '" + string + "'. Introspection failed on typedef argument: " + exception);
        }
        Class[] classArray = new Class[]{Any.class};
        java.lang.Object[] objectArray = new java.lang.Object[]{any};
        try {
            return clazz.getMethod("extract", classArray).invoke(null, objectArray);
        }
        catch (Exception exception) {
            throw new JavaIDLIntrospectionException("Dynamic invocation of 'extractAny()' failed on a typedef argument. Class instance: " + clazz.getName() + ". Exception:" + exception, exception);
        }
    }

    private Class extractTypeFromTC(TypeCode typeCode) {
        if (typeCode == null) {
            throw new NullPointerException("tc");
        }
        switch (typeCode.kind().value()) {
            case 14: 
            case 15: 
            case 17: {
                try {
                    try {
                        return Class.forName(this.IDtoClassName(typeCode.id()));
                    }
                    catch (Exception exception) {
                        throw new JavaIDLIntrospectionException("Java introspection (Class.forName()) failed for type '" + this.IDtoClassName(typeCode.id()) + "'. Exception: " + exception);
                    }
                }
                catch (BadKind badKind) {
                    throw new RemoteException("Exception while analyzing enum, objref or struct typecode (getting typecode name raises exception). Exception: " + (java.lang.Object)((java.lang.Object)badKind));
                }
            }
            case 21: {
                try {
                    return this.extractTypeFromTC(typeCode.content_type());
                }
                catch (BadKind badKind) {
                    throw new RemoteException("Exception while analyzing alias typecode (getting typecode name raises exception). Exception: " + (java.lang.Object)((java.lang.Object)badKind));
                }
            }
            case 19: {
                try {
                    Class clazz = this.extractTypeFromTC(typeCode.content_type());
                    return Array.newInstance(clazz, 0).getClass();
                }
                catch (BadKind badKind) {
                    throw new RemoteException("Exception while analyzing sequence typecode (getting typecode name raises exception). Exception: " + (java.lang.Object)((java.lang.Object)badKind));
                }
            }
            case 20: {
                try {
                    Class clazz = this.extractTypeFromTC(typeCode.content_type());
                    return Array.newInstance(clazz, 0).getClass();
                }
                catch (BadKind badKind) {
                    throw new RemoteException("Exception while analyzing array typecode (getting typecode name raises exception). Exception: " + (java.lang.Object)((java.lang.Object)badKind));
                }
            }
            case 7: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 10: {
                return Byte.TYPE;
            }
            case 23: {
                return Long.TYPE;
            }
            case 24: {
                return Long.TYPE;
            }
            case 3: {
                return Integer.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 2: {
                return Short.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 18: {
                return String.class;
            }
            case 9: {
                return Character.TYPE;
            }
            case 8: {
                return Boolean.TYPE;
            }
            case 1: {
                return Void.TYPE;
            }
        }
        throw new IllegalArgumentException("Argument typecode '" + typeCode.kind().value() + "' is not supported.");
    }

    public static String fullTypeToType(String string) {
        if (string == null) {
            throw new NullPointerException("fullType");
        }
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(58);
        if (n == -1 || n2 == -1) {
            throw new IntrospectionInconsistentException("Type returned by the Manager is not a valid IDL ID, beginning with IDL: and ending with :1.0");
        }
        return string.substring(n + 1, n2);
    }

    public BACIAttribute[] getAttributes(BACIRemote bACIRemote) {
        if (bACIRemote == null) {
            throw new NullPointerException("target");
        }
        AttributeDescription[] attributeDescriptionArray = bACIRemote.getIFDesc().attributes;
        ArrayList<BACIAttribute> arrayList = new ArrayList<BACIAttribute>();
        for (int i = 0; i < attributeDescriptionArray.length; ++i) {
            if (this.isProperty(attributeDescriptionArray[i])) continue;
            Class clazz = this.extractTypeFromTC(attributeDescriptionArray[i].type);
            arrayList.add(new BACIAttribute(this.ra, bACIRemote, attributeDescriptionArray[i], clazz));
        }
        BACIAttribute[] bACIAttributeArray = new BACIAttribute[arrayList.size()];
        arrayList.toArray(bACIAttributeArray);
        return bACIAttributeArray;
    }

    public int getCallbackLocation(Operation operation) {
        if (operation == null) {
            throw new NullPointerException("op");
        }
        Class[] classArray = operation.getParameterTypes();
        int n = -1;
        for (int i = 0; i < classArray.length; ++i) {
            if (!Callback.class.isAssignableFrom(classArray[i])) continue;
            if (n != -1) {
                throw new IntrospectionInconsistentException("Operation '" + operation + "' declares more than one parameter that extends 'Callback'");
            }
            n = i;
            if (i == classArray.length - 1 && this.ra.isStrict()) {
                throw new IntrospectionInconsistentException("Operation '" + operation + "' takes callback as its last parameter, but takes no 'CBDescIn' parameter.");
            }
            if (!this.ra.isStrict() || classArray[i + 1].equals(CBDescIn.class)) continue;
            throw new IntrospectionInconsistentException("Operation '" + operation + "' does not take a 'CBDescIn' parameter after 'Callback' parameter.");
        }
        return n;
    }

    public BACIOperation[] getOperations(BACIRemote bACIRemote) {
        if (bACIRemote == null) {
            throw new NullPointerException("target");
        }
        OperationDescription[] operationDescriptionArray = bACIRemote.getIFDesc().operations;
        ArrayList<BACIOperation> arrayList = new ArrayList<BACIOperation>();
        for (int i = 0; i < operationDescriptionArray.length; ++i) {
            this.ra.getNotifier().reportDebug("BACIIntrospector::getOperations", "Analysing operation '" + operationDescriptionArray[i].name + "'.");
            ParameterDescription[] parameterDescriptionArray = operationDescriptionArray[i].parameters;
            String[] stringArray = new String[parameterDescriptionArray.length];
            Class[] classArray = new Class[parameterDescriptionArray.length];
            boolean[] blArray = new boolean[parameterDescriptionArray.length];
            int n = -1;
            boolean bl = false;
            for (int j = 0; j < parameterDescriptionArray.length; ++j) {
                try {
                    stringArray[j] = parameterDescriptionArray[j].name;
                    classArray[j] = this.extractTypeFromTC(parameterDescriptionArray[j].type);
                    if (this.isOfType(parameterDescriptionArray[j].type, ID_CALLBACK)) {
                        if (n != -1) {
                            throw new IntrospectionInconsistentException("Operation '" + operationDescriptionArray[i].name + "' declares more than one callback parameter.");
                        }
                        n = j;
                        if (n == parameterDescriptionArray.length - 1 && this.ra.isStrict()) {
                            throw new IntrospectionInconsistentException("A callback parameter for operation '" + operationDescriptionArray[i].name + "' must be followed by a 'CBDescIn' parameter.");
                        }
                    }
                    blArray[j] = parameterDescriptionArray[j].mode != ParameterMode.PARAM_OUT && n != j;
                    if (n == -1 || j != n + 1) continue;
                    try {
                        if (ID_CBDESCIN.equals(parameterDescriptionArray[j].type.id())) {
                            blArray[j] = false;
                            continue;
                        }
                        if (!this.ra.isStrict()) continue;
                        throw new IntrospectionInconsistentException("A callback parameter for opration '" + operationDescriptionArray[i].name + "' must be followed by a 'CBDescIn' parameter.");
                    }
                    catch (Exception exception) {
                        throw new RemoteException("Exception while analyzing typecode (getting typecode name raises exception). Exception: " + exception);
                    }
                }
                catch (Exception exception) {
                    this.ra.getNotifier().reportDebug("BACIIntrospector::getOperations", "Failed to analyse parameter '" + parameterDescriptionArray[j].name + "' for operation '" + operationDescriptionArray[i].name + "'. Removing it from operation list... Exception:" + exception);
                    exception.printStackTrace();
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            arrayList.add(new BACIOperation(this.ra, operationDescriptionArray[i], bACIRemote, stringArray, classArray, blArray, n != -1, false));
        }
        BACIOperation[] bACIOperationArray = new BACIOperation[arrayList.size()];
        arrayList.toArray(bACIOperationArray);
        return bACIOperationArray;
    }

    public AttributeDescription[] getProperties(AttributeDescription[] attributeDescriptionArray) {
        if (attributeDescriptionArray == null) {
            throw new NullPointerException("attributes");
        }
        ArrayList<AttributeDescription> arrayList = new ArrayList<AttributeDescription>();
        for (int i = 0; i < attributeDescriptionArray.length; ++i) {
            if (!this.isProperty(attributeDescriptionArray[i])) continue;
            arrayList.add(attributeDescriptionArray[i]);
        }
        AttributeDescription[] attributeDescriptionArray2 = new AttributeDescription[arrayList.size()];
        arrayList.toArray(attributeDescriptionArray2);
        return attributeDescriptionArray2;
    }

    public String IDtoClassName(String string) {
        if (string == null) {
            throw new NullPointerException("ID");
        }
        String string2 = (String)this.IDLtoJavaMapping.get(string);
        if (string2 != null) {
            return string2;
        }
        int n = 0;
        int n2 = 0;
        n = string.indexOf(58);
        if (n == (n2 = string.lastIndexOf(58))) {
            throw new IntrospectionInconsistentException("IDL ID '" + string + "' is not well-formed because it contains only one ':' character");
        }
        String string3 = string.substring(n + 1, n2);
        n = string3.lastIndexOf(47);
        n2 = string3.indexOf(47);
        if (n == -1 || n2 == -1) {
            throw new IntrospectionInconsistentException("IDL ID '" + string + "' is not well-formed because it does not contain module separators '/'.");
        }
        if (n == n2) {
            return BACIIntrospector.addIDLPackagePrefix(string3.replace('/', '.'));
        }
        String string4 = "IDL:" + string3.substring(0, n) + ":1.0";
        if (n != n2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3.substring(0, n2), ".");
            String string5 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken() + "." + string5;
            }
            string3 = string5 + string3.substring(n2);
        }
        this.ra.getNotifier().reportDebug("BACIIntrospector::IDtoClassName", "Analysing IDL to Java mapping of type '" + string + "'. Querying IR for parent container '" + string4 + "'.");
        Contained contained = this.ra.lookupId(string4);
        if (contained == null) {
            throw new IntrospectionInconsistentException("Repository does not contain container '" + string4 + "' of child '" + string + "'.");
        }
        string2 = contained.def_kind() == DefinitionKind.dk_Module ? BACIIntrospector.addIDLPackagePrefix(string3.replace('/', '.')) : BACIIntrospector.addIDLPackagePrefix(string3.substring(0, n).replace('/', '.') + "Package." + string3.substring(n + 1));
        this.IDLtoJavaMapping.put(string, string2);
        return string2;
    }

    public void insertTypedef(ParameterDescription parameterDescription, java.lang.Object object, Any any) {
        if (any == null) {
            throw new NullPointerException("any");
        }
        if (object == null) {
            throw new NullPointerException("o");
        }
        String string = null;
        try {
            string = !object.getClass().isArray() ? object.getClass().getName() + "Helper" : this.IDtoClassName(parameterDescription.type.id()) + "Helper";
            if (string.startsWith("java.lang.")) {
                string = "org.omg.CORBA." + string.substring("java.lang.".length());
            }
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Any.class, object.getClass()};
            java.lang.Object[] objectArray = new java.lang.Object[]{any, object};
            clazz.getMethod("insert", classArray).invoke(null, objectArray);
        }
        catch (Exception exception) {
            throw new JavaIDLIntrospectionException("Error while dynamically inserting a typedef value into 'Any' by loading helper class '" + string + "' (inserting class '" + object.getClass().getName() + "'). Exception: " + exception, exception);
        }
    }

    public boolean isDevice(Object object) {
        if (object == null) {
            throw new NullPointerException("remote");
        }
        return object._is_a(ID_DEVICE);
    }

    public boolean isInvocationDestroyMethod(String string) {
        if (string == null) {
            throw new NullPointerException("operation");
        }
        return METHOD_DESTROY.equals(string);
    }

    public boolean isInvocationDoneMethod(String string) {
        if (string == null) {
            throw new NullPointerException("operation");
        }
        return METHOD_DONE.equals(string);
    }

    private boolean isOfType(TypeCode typeCode, String string) {
        switch (typeCode.kind().value()) {
            case 14: {
                break;
            }
            case 21: {
                try {
                    return this.isOfType(typeCode.content_type(), string);
                }
                catch (BadKind badKind) {
                    throw new RemoteException("Exception while analyzing typecode (getting typecode name raises exception). Exception: " + (java.lang.Object)((java.lang.Object)badKind));
                }
            }
            default: {
                return false;
            }
        }
        try {
            this.ra.getNotifier().reportDebug("BACIIntrospector::isOfType", "Checking if '" + typeCode.id() + "' implements '" + string + "'.");
            if (typeCode.id().equals(ID_CORBA_OBJECT)) {
                return string.equals(ID_CORBA_OBJECT);
            }
            InterfaceDef interfaceDef = InterfaceDefHelper.narrow((Object)this.ra.lookupId(typeCode.id()));
            if (interfaceDef.is_a(string)) {
                return true;
            }
        }
        catch (BadKind badKind) {
            throw new RemoteException("Exception while analyzing typecode (getting typecode name raises exception). Exception: " + (java.lang.Object)((java.lang.Object)badKind));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    private boolean isProperty(AttributeDescription attributeDescription) {
        if (attributeDescription == null) {
            throw new NullPointerException("desc");
        }
        if (attributeDescription.mode == AttributeMode.ATTR_NORMAL) {
            return false;
        }
        return attributeDescription.type.kind() == TCKind.tk_objref && this.isOfType(attributeDescription.type, ID_PROPERTY);
    }

    public java.lang.Object[] prepareDIIparameters(OperationDescription operationDescription, java.lang.Object[] objectArray) {
        return objectArray;
    }

    public class InvocationObjectHolder {
        public Object ref = null;
        public String id = null;

        public InvocationObjectHolder(Object object, String string) {
            this.id = string;
            this.ref = object;
        }
    }
}

