/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer.engine.BACI;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import si.ijs.acs.objectexplorer.engine.Converter;

public abstract class BACIConverterSupport
implements Converter {
    public static final String[] BACI_PROPERTY_OPERATIONS = new String[]{"get_sync", "get_history", "get_value_trigger", "working", "done"};
    public static final String[] BACI_PROPERTY_INVERSE_OPERATIONS = new String[]{"set_nonblocking", "set_sync", "set_async", "set_value_trigger"};
    public static final String[] BACI_PROPERTY_ATTRIBUTES = new String[]{"min_delta_trigger", "default_value", "graph_min", "graph_max", "min_step", "min_value", "max_value", "alarm_low_off", "alarm_low_on", "alarm_high_off", "alarm_high_on"};
    public static final String BACI_UNIT_ATTRIBUTE = "units";
    protected Map operationMap = null;
    protected Map operationInverseMap = null;
    protected Map attributeMap = null;

    public BACIConverterSupport() {
        this.initializeTables();
    }

    protected void initializeTables() {
        int n;
        this.operationMap = new HashMap();
        for (n = 0; n < BACI_PROPERTY_OPERATIONS.length; ++n) {
            this.operationMap.put(BACI_PROPERTY_OPERATIONS[n], null);
        }
        this.attributeMap = new HashMap();
        for (n = 0; n < BACI_PROPERTY_ATTRIBUTES.length; ++n) {
            this.attributeMap.put(BACI_PROPERTY_ATTRIBUTES[n], null);
        }
        this.operationInverseMap = new HashMap();
        for (n = 0; n < BACI_PROPERTY_INVERSE_OPERATIONS.length; ++n) {
            this.operationInverseMap.put(BACI_PROPERTY_INVERSE_OPERATIONS[n], null);
        }
    }

    @Override
    public boolean acceptConvert(String string) {
        return this.operationMap.containsKey(string) || this.attributeMap.containsKey(string) || BACI_UNIT_ATTRIBUTE.equals(string);
    }

    @Override
    public boolean acceptInverseConvert(String string) {
        return this.operationInverseMap.containsKey(string);
    }

    @Override
    public Object convert(String string, Object[] objectArray, Object object) {
        if (this.operationMap.containsKey(string)) {
            block14: {
                if (string.equals("get_sync")) {
                    return this.convertPropertyValue(object);
                }
                if (string.equals("get_history")) {
                    try {
                        int n = Array.getLength(objectArray[1]);
                        if (objectArray[1].getClass().getComponentType() == this.getInverseConvertPropertyParameterType()) {
                            for (int i = 0; i < n; ++i) {
                                Array.set(objectArray[1], i, this.convertPropertyValue(Array.get(objectArray[1], i)));
                            }
                            break block14;
                        }
                        Object object2 = Array.newInstance(this.getInverseConvertPropertyParameterType(), n);
                        for (int i = 0; i < n; ++i) {
                            Array.set(object2, i, this.convertPropertyValue(Array.get(objectArray[1], i)));
                        }
                        objectArray[1] = object2;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                } else if (string.equals("get_value_trigger")) {
                    objectArray[0] = this.convertPropertyValue(objectArray[0]);
                } else if ((string.equals("working") || string.equals("done")) && objectArray.length == 3) {
                    objectArray[0] = this.convertPropertyValue(objectArray[0]);
                }
            }
            return object;
        }
        if (this.attributeMap.containsKey(string)) {
            return this.convertPropertyValue(object);
        }
        if (string.equals(BACI_UNIT_ATTRIBUTE)) {
            return this.getConvertedPropertyValueUnits((String)object);
        }
        return object;
    }

    @Override
    public void inverseConvert(String string, Object[] objectArray) {
        objectArray[0] = this.inverseConvertPropertyValue(objectArray[0]);
    }

    @Override
    public Class[] getInverseConvertParameterTypes(String string, Class[] classArray) {
        Class[] classArray2 = new Class[classArray.length];
        System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
        classArray2[0] = this.getInverseConvertPropertyParameterType();
        return classArray2;
    }

    public abstract Object convertPropertyValue(Object var1);

    public abstract Object inverseConvertPropertyValue(Object var1);

    public abstract Class getInverseConvertPropertyParameterType();

    public abstract String getConvertedPropertyValueUnits(String var1);
}

