/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer;

import com.cosylab.gui.components.r2.DataFormatter;
import com.cosylab.gui.components.r2.SmartPanel;
import com.cosylab.gui.components.r2.SmartTextPane;
import com.cosylab.gui.components.r2.chart.AbstractDataModel;
import com.cosylab.gui.components.r2.chart.BaseChart;
import com.cosylab.gui.components.r2.chart.ChartDataModel;
import com.cosylab.gui.components.r2.chart.ChartXAxis;
import com.cosylab.gui.components.r2.chart.DefaultTimeXAxis;
import com.cosylab.gui.components.r2.chart.Interval;
import com.cosylab.gui.components.r2.chart.Point;
import com.cosylab.gui.components.r2.chart.PointIterator;
import com.cosylab.util.CircularArrayList;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import si.ijs.acs.objectexplorer.CallMethodDialog;
import si.ijs.acs.objectexplorer.NotificationBean;
import si.ijs.acs.objectexplorer.OERemoteResponseCallback;
import si.ijs.acs.objectexplorer.OperationInvocator;
import si.ijs.acs.objectexplorer.RemoteResponseCallbackListener;
import si.ijs.acs.objectexplorer.ReporterBean;
import si.ijs.acs.objectexplorer.engine.Invocation;
import si.ijs.acs.objectexplorer.engine.Operation;
import si.ijs.acs.objectexplorer.engine.RemoteCall;
import si.ijs.acs.objectexplorer.engine.RemoteResponse;

public class RemoteResponseWindow
extends JFrame
implements OperationInvocator,
RemoteResponseCallbackListener {
    private JPanel ivjJFrameContentPane = null;
    private JPanel ivjJPanel1 = null;
    private JLabel ivjJLabel1 = null;
    private JLabel ivjJLabel2 = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JLabel ivjmessageField = null;
    private SmartTextPane ivjReportArea = null;
    private JLabel ivjJLabel3 = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjJButton1 = null;
    private JLabel ivjJLabel4 = null;
    private JTextField ivjJTextField1 = null;
    private JList ivjJList1 = null;
    private JScrollPane ivjJScrollPane2 = null;
    private JSplitPane ivjJSplitPane1 = null;
    private JTabbedPane ivjResultPanel = null;
    private JPanel ivjTextPanel = null;
    private BaseChart ivjTrend = null;
    private JCheckBoxMenuItem ivjJCheckBoxMenuItem1 = null;
    private ReporterBean reporter = null;
    private RemoteResponse rr = null;
    private NotificationBean notifier = null;
    private StringBuffer minimText = new StringBuffer();
    private int reportLength = -1;
    private int minimTextReportCount = 0;
    private int maxLines = 500;
    private ArrayList numberIndexes = new ArrayList();
    private List<double[]> chartData = new CircularArrayList();
    private int selectedChartValue = -1;
    private int selectedChartXValue = -1;
    private double[] mins = null;
    private double[] maxs = null;
    private boolean enabled = true;
    private boolean editing = false;
    private boolean destroyed = false;
    private JScrollPane ivjJScrollPane3 = null;
    private JScrollPane ivjJScrollPane4 = null;
    private JSplitPane ivjJSplitPane2 = null;
    private SmartTextPane ivjoperationResultArea = null;
    private JList ivjoperationsList = null;
    private OETrendDataModel model = null;
    private JLabel ivjJLabel5 = null;
    private JLabel ivjJLabel6 = null;
    private JList ivjJList2 = null;
    private JPanel ivjJPanel3 = null;
    private JScrollPane ivjJScrollPane5 = null;
    private SmartPanel ivjOperations = null;
    private SmartPanel ivjTrendPanel = null;
    private boolean disposeOnDestroy = false;
    private volatile boolean textOutputTabSelected = false;
    private Style redStyle = null;
    private Style blackStyle = null;
    private Style redStyleOP = null;
    private Style blackStyleOP = null;

    public RemoteResponseWindow() {
        this.initialize();
    }

    public RemoteResponseWindow(RemoteResponse remoteResponse, NotificationBean notificationBean, ReporterBean reporterBean) {
        if (remoteResponse == null) {
            throw new NullPointerException("RemoteResponse in RemoteResponseWindow");
        }
        this.rr = remoteResponse;
        this.notifier = notificationBean;
        this.reporter = reporterBean;
        this.initialize();
        this.setTitle("[" + remoteResponse.getInvocation().getInvocationRequest().getSN() + "] " + remoteResponse.getInvocation().getName());
        this.getTrendPanel().setName("Trend for " + remoteResponse.getInvocation().getName());
        this.getTrendPanel().setShortName("Trend");
        this.getOperations().setName("Operations for " + remoteResponse.getInvocation().getName());
        this.getOperations().setShortName("Operations");
        this.getJList1().setModel(new DefaultListModel());
        this.getJList2().setModel(new DefaultListModel());
        this.fillTrendList(remoteResponse);
    }

    private void checkChartPointsSize() {
        while (this.chartData.size() > this.maxLines) {
            this.chartData.remove(0);
        }
    }

    private void connEtoC1(ActionEvent actionEvent) {
        try {
            this.jButton1_ActionPerformed(actionEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(ActionEvent actionEvent) {
        try {
            this.jTextField1_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3(FocusEvent focusEvent) {
        try {
            this.jTextField1_FocusLost();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC4(KeyEvent keyEvent) {
        try {
            this.jTextField1_FocusGained();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC5(WindowEvent windowEvent) {
        try {
            this.remoteResponseWindow_WindowDeiconified(windowEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC6() {
        try {
            this.remoteResponseWindow_Initialize();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC7(ActionEvent actionEvent) {
        try {
            this.jCheckBoxMenuItem1_ActionPerformed(actionEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC8(MouseEvent mouseEvent) {
        try {
            this.jList2_MouseClicked(mouseEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            this.setSelectedChartValue(this.getJList1().getSelectedIndex());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            this.setSelectedChartXValue(this.getJList2().getSelectedIndex());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    @Override
    public void disable() {
        this.setTitle(this.getTitle() + " -- Invocation Destroyed");
        this.getReportArea().append("\nINVOCATION WAS DESTROYED");
        this.getoperationsList().setEnabled(false);
        this.setDefaultCloseOperation(2);
        this.setDestroyed(true);
        if (this.disposeOnDestroy) {
            this.dispose();
        }
    }

    void fillTrendList(RemoteResponse remoteResponse) {
        int n;
        this.getTrend().setXAxis((ChartXAxis)new DefaultTimeXAxis());
        Object[] objectArray = remoteResponse.getData();
        String[] stringArray = remoteResponse.getDataNames();
        ((DefaultListModel)this.getJList1().getModel()).addElement("[time]");
        ((DefaultListModel)this.getJList2().getModel()).addElement("[time]");
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null || !Number.class.isAssignableFrom(objectArray[n].getClass())) continue;
            String string = stringArray[n];
            if (objectArray[n] instanceof Long) {
                string = string + " / 1000";
            }
            ((DefaultListModel)this.getJList1().getModel()).addElement(string);
            ((DefaultListModel)this.getJList2().getModel()).addElement(string);
            this.numberIndexes.add(new Integer(n));
        }
        this.mins = new double[this.numberIndexes.size() + 1];
        this.maxs = new double[this.numberIndexes.size() + 1];
        for (n = 0; n < this.mins.length; ++n) {
            this.mins[n] = Double.MAX_VALUE;
            this.maxs[n] = Double.MIN_VALUE;
        }
        this.model = new OETrendDataModel(this);
    }

    public int getChartSize() {
        return this.chartData.size();
    }

    public double getChartX(int n) {
        if (this.selectedChartXValue == -1) {
            return 0.0;
        }
        return this.chartData.get(n)[this.selectedChartXValue];
    }

    public double getChartY(int n) {
        if (this.selectedChartValue == -1) {
            return 0.0;
        }
        return this.chartData.get(n)[this.selectedChartValue];
    }

    public Interval getChartYBounds() {
        return new Interval(this.mins[this.selectedChartValue], this.maxs[this.selectedChartValue]);
    }

    private JButton getJButton1() {
        if (this.ivjJButton1 == null) {
            try {
                this.ivjJButton1 = new JButton();
                this.ivjJButton1.setName("JButton1");
                this.ivjJButton1.setText("Disable output");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButton1;
    }

    private JCheckBoxMenuItem getJCheckBoxMenuItem1() {
        if (this.ivjJCheckBoxMenuItem1 == null) {
            try {
                this.ivjJCheckBoxMenuItem1 = new JCheckBoxMenuItem();
                this.ivjJCheckBoxMenuItem1.setName("JCheckBoxMenuItem1");
                this.ivjJCheckBoxMenuItem1.setText("Expand results");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJCheckBoxMenuItem1;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new CardLayout());
                this.ivjJFrameContentPane.setBackground(SystemColor.control);
                this.ivjJFrameContentPane.setForeground(Color.orange);
                this.getJFrameContentPane().add((Component)this.getJPanel1(), this.getJPanel1().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("Message:");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setText("Serial Number:");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel2;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setText("");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel3;
    }

    private JLabel getJLabel4() {
        if (this.ivjJLabel4 == null) {
            try {
                this.ivjJLabel4 = new JLabel();
                this.ivjJLabel4.setName("JLabel4");
                this.ivjJLabel4.setText("max. no. of results:");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel4;
    }

    private JLabel getJLabel5() {
        if (this.ivjJLabel5 == null) {
            try {
                this.ivjJLabel5 = new JLabel();
                this.ivjJLabel5.setName("JLabel5");
                this.ivjJLabel5.setText("Y values");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel5;
    }

    private JLabel getJLabel6() {
        if (this.ivjJLabel6 == null) {
            try {
                this.ivjJLabel6 = new JLabel();
                this.ivjJLabel6.setName("JLabel6");
                this.ivjJLabel6.setText("X values");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel6;
    }

    private JList getJList1() {
        if (this.ivjJList1 == null) {
            try {
                this.ivjJList1 = new JList();
                this.ivjJList1.setName("JList1");
                this.ivjJList1.setBounds(0, 0, 145, 200);
                this.ivjJList1.setSelectionMode(0);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJList1;
    }

    private JList getJList2() {
        if (this.ivjJList2 == null) {
            try {
                this.ivjJList2 = new JList();
                this.ivjJList2.setName("JList2");
                this.ivjJList2.setBounds(0, 0, 49, 228);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJList2;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.ipadx = 5;
                gridBagConstraints.ipady = 5;
                gridBagConstraints.insets = new Insets(0, 15, 0, 0);
                this.getJPanel1().add((Component)this.getJLabel1(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 0;
                gridBagConstraints2.insets = new Insets(0, 15, 0, 0);
                this.getJPanel1().add((Component)this.getJLabel2(), gridBagConstraints2);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = 1;
                gridBagConstraints3.gridy = 1;
                gridBagConstraints3.gridwidth = 2;
                gridBagConstraints3.fill = 1;
                gridBagConstraints3.weightx = 1.0;
                gridBagConstraints3.insets = new Insets(0, 4, 0, 8);
                this.getJPanel1().add((Component)this.getmessageField(), gridBagConstraints3);
                GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
                gridBagConstraints4.gridx = 1;
                gridBagConstraints4.gridy = 0;
                gridBagConstraints4.fill = 1;
                gridBagConstraints4.insets = new Insets(0, 5, 0, 4);
                this.getJPanel1().add((Component)this.getJLabel3(), gridBagConstraints4);
                GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
                gridBagConstraints5.gridx = 3;
                gridBagConstraints5.gridy = 1;
                gridBagConstraints5.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJButton1(), gridBagConstraints5);
                GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
                gridBagConstraints6.gridx = 3;
                gridBagConstraints6.gridy = 0;
                gridBagConstraints6.fill = 2;
                gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJTextField1(), gridBagConstraints6);
                GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
                gridBagConstraints7.gridx = 2;
                gridBagConstraints7.gridy = 0;
                gridBagConstraints7.anchor = 13;
                gridBagConstraints7.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJLabel4(), gridBagConstraints7);
                GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
                gridBagConstraints8.gridx = 0;
                gridBagConstraints8.gridy = 2;
                gridBagConstraints8.gridwidth = 4;
                gridBagConstraints8.fill = 1;
                gridBagConstraints8.weightx = 1.0;
                gridBagConstraints8.weighty = 1.0;
                gridBagConstraints8.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getResultPanel(), gridBagConstraints8);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel3() {
        if (this.ivjJPanel3 == null) {
            try {
                this.ivjJPanel3 = new JPanel();
                this.ivjJPanel3.setName("JPanel3");
                this.ivjJPanel3.setPreferredSize(new Dimension(200, 490));
                this.ivjJPanel3.setLayout(new GridBagLayout());
                this.ivjJPanel3.setMinimumSize(new Dimension(200, 272));
                this.ivjJPanel3.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.ipadx = 126;
                gridBagConstraints.ipady = 92;
                this.getJPanel3().add((Component)this.getJScrollPane2(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 4;
                gridBagConstraints2.fill = 1;
                gridBagConstraints2.weightx = 1.0;
                gridBagConstraints2.weighty = 1.0;
                gridBagConstraints2.ipadx = 126;
                gridBagConstraints2.ipady = 92;
                this.getJPanel3().add((Component)this.getJScrollPane5(), gridBagConstraints2);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = 0;
                gridBagConstraints3.gridy = 1;
                gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJLabel5(), gridBagConstraints3);
                GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
                gridBagConstraints4.gridx = 0;
                gridBagConstraints4.gridy = 3;
                gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJLabel6(), gridBagConstraints4);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanel3;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView((Component)this.getReportArea());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JScrollPane getJScrollPane2() {
        if (this.ivjJScrollPane2 == null) {
            try {
                this.ivjJScrollPane2 = new JScrollPane();
                this.ivjJScrollPane2.setName("JScrollPane2");
                this.getJScrollPane2().setViewportView(this.getJList1());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane2;
    }

    private JScrollPane getJScrollPane3() {
        if (this.ivjJScrollPane3 == null) {
            try {
                this.ivjJScrollPane3 = new JScrollPane();
                this.ivjJScrollPane3.setName("JScrollPane3");
                this.getJScrollPane3().setViewportView(this.getoperationsList());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane3;
    }

    private JScrollPane getJScrollPane4() {
        if (this.ivjJScrollPane4 == null) {
            try {
                this.ivjJScrollPane4 = new JScrollPane();
                this.ivjJScrollPane4.setName("JScrollPane4");
                this.getJScrollPane4().setViewportView((Component)this.getoperationResultArea());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane4;
    }

    private JScrollPane getJScrollPane5() {
        if (this.ivjJScrollPane5 == null) {
            try {
                this.ivjJScrollPane5 = new JScrollPane();
                this.ivjJScrollPane5.setName("JScrollPane5");
                this.getJScrollPane5().setViewportView(this.getJList2());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane5;
    }

    private JSplitPane getJSplitPane1() {
        if (this.ivjJSplitPane1 == null) {
            try {
                this.ivjJSplitPane1 = new JSplitPane(1);
                this.ivjJSplitPane1.setName("JSplitPane1");
                this.getJSplitPane1().add((Component)this.getTrend(), "right");
                this.getJSplitPane1().add((Component)this.getJPanel3(), "left");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSplitPane1;
    }

    private JSplitPane getJSplitPane2() {
        if (this.ivjJSplitPane2 == null) {
            try {
                this.ivjJSplitPane2 = new JSplitPane(1);
                this.ivjJSplitPane2.setName("JSplitPane2");
                this.getJSplitPane2().add((Component)this.getJScrollPane3(), "left");
                this.getJSplitPane2().add((Component)this.getJScrollPane4(), "right");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSplitPane2;
    }

    private JTextField getJTextField1() {
        if (this.ivjJTextField1 == null) {
            try {
                this.ivjJTextField1 = new JTextField();
                this.ivjJTextField1.setName("JTextField1");
                this.ivjJTextField1.setText("500");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJTextField1;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    private JLabel getmessageField() {
        if (this.ivjmessageField == null) {
            try {
                this.ivjmessageField = new JLabel();
                this.ivjmessageField.setName("messageField");
                this.ivjmessageField.setText("");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjmessageField;
    }

    private SmartTextPane getoperationResultArea() {
        if (this.ivjoperationResultArea == null) {
            try {
                this.ivjoperationResultArea = new SmartTextPane();
                this.ivjoperationResultArea.setName("operationResultArea");
                this.ivjoperationResultArea.setBounds(0, 0, 11, 6);
                this.blackStyleOP = this.ivjoperationResultArea.getLogicalStyle();
                this.redStyleOP = this.ivjoperationResultArea.addStyle("Red", null);
                StyleConstants.setForeground(this.redStyleOP, Color.red);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjoperationResultArea;
    }

    private SmartPanel getOperations() {
        if (this.ivjOperations == null) {
            try {
                this.ivjOperations = new SmartPanel();
                this.ivjOperations.setName("Operations");
                this.ivjOperations.setLayout((LayoutManager)this.getOperationsCardLayout());
                this.getOperations().add((Component)this.getJSplitPane2(), (Object)this.getJSplitPane2().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjOperations;
    }

    private CardLayout getOperationsCardLayout() {
        CardLayout cardLayout = null;
        try {
            cardLayout = new CardLayout();
            cardLayout.setVgap(4);
            cardLayout.setHgap(4);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return cardLayout;
    }

    private JList getoperationsList() {
        if (this.ivjoperationsList == null) {
            try {
                this.ivjoperationsList = new JList();
                this.ivjoperationsList.setName("operationsList");
                this.ivjoperationsList.setBounds(0, 0, 183, 232);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjoperationsList;
    }

    private SmartTextPane getReportArea() {
        if (this.ivjReportArea == null) {
            try {
                this.ivjReportArea = new SmartTextPane();
                this.ivjReportArea.setName("ReportArea");
                this.ivjReportArea.setMaxLines(1000);
                this.ivjReportArea.setLocation(0, 0);
                this.blackStyle = this.ivjReportArea.getLogicalStyle();
                this.redStyle = this.ivjReportArea.addStyle("Red", null);
                StyleConstants.setForeground(this.redStyle, Color.red);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjReportArea;
    }

    private JTabbedPane getResultPanel() {
        if (this.ivjResultPanel == null) {
            try {
                this.ivjResultPanel = new JTabbedPane();
                this.ivjResultPanel.setName("ResultPanel");
                this.ivjResultPanel.insertTab("Text output", null, this.getTextPanel(), null, 0);
                this.ivjResultPanel.insertTab("Trend", null, (Component)this.getTrendPanel(), null, 1);
                this.ivjResultPanel.insertTab("Operations", null, (Component)this.getOperations(), null, 2);
                this.ivjResultPanel.setSelectedIndex(1);
                this.ivjResultPanel.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                        RemoteResponseWindow.this.textOutputTabSelected = jTabbedPane.getSelectedIndex() == 0;
                    }
                });
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjResultPanel;
    }

    public int getSelectedChartValue() {
        return this.selectedChartValue;
    }

    public int getSelectedChartXValue() {
        return this.selectedChartXValue;
    }

    private JPanel getTextPanel() {
        if (this.ivjTextPanel == null) {
            try {
                this.ivjTextPanel = new JPanel();
                this.ivjTextPanel.setName("TextPanel");
                this.ivjTextPanel.setLayout(this.getTextPanelCardLayout());
                this.getTextPanel().add((Component)this.getJScrollPane1(), this.getJScrollPane1().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjTextPanel;
    }

    private CardLayout getTextPanelCardLayout() {
        CardLayout cardLayout = null;
        try {
            cardLayout = new CardLayout();
            cardLayout.setVgap(4);
            cardLayout.setHgap(4);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return cardLayout;
    }

    private BaseChart getTrend() {
        if (this.ivjTrend == null) {
            try {
                this.ivjTrend = new BaseChart();
                this.ivjTrend.setName("Trend");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjTrend;
    }

    private SmartPanel getTrendPanel() {
        if (this.ivjTrendPanel == null) {
            try {
                this.ivjTrendPanel = new SmartPanel();
                this.ivjTrendPanel.setName("TrendPanel");
                this.ivjTrendPanel.setToolTipText("Trend");
                this.ivjTrendPanel.setLayout((LayoutManager)this.getTrendPanelCardLayout());
                this.getTrendPanel().add((Component)this.getJSplitPane1(), (Object)this.getJSplitPane1().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjTrendPanel;
    }

    private CardLayout getTrendPanelCardLayout() {
        CardLayout cardLayout = null;
        try {
            cardLayout = new CardLayout();
            cardLayout.setVgap(4);
            cardLayout.setHgap(4);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return cardLayout;
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION in RemoteResponseWindow ---------");
        throwable.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getJButton1().addActionListener(this.ivjEventHandler);
        this.getJTextField1().addActionListener(this.ivjEventHandler);
        this.getJTextField1().addFocusListener(this.ivjEventHandler);
        this.getJTextField1().addKeyListener(this.ivjEventHandler);
        this.addWindowListener(this.ivjEventHandler);
        this.getJCheckBoxMenuItem1().addActionListener(this.ivjEventHandler);
        this.getJList1().addListSelectionListener(this.ivjEventHandler);
        this.getJList2().addListSelectionListener(this.ivjEventHandler);
        this.getoperationsList().addMouseListener(this.ivjEventHandler);
        this.connPtoP1SetTarget();
        this.connPtoP2SetTarget();
    }

    private void initialize() {
        try {
            this.setName("RemoteResponseWindow");
            this.setDefaultCloseOperation(0);
            this.setSize(600, 333);
            this.setTitle("");
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
            this.connEtoC6();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    @Override
    public void invocationDestroyed(Invocation invocation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeOperation(Operation operation, Object[] objectArray) {
        if (operation != null) {
            if (operation.isInvocation()) {
                operation.invokeAsync(objectArray, new OERemoteResponseCallback(this, ReporterBean.raID));
            } else {
                RemoteCall remoteCall = operation.invoke(objectArray);
                SmartTextPane smartTextPane = this.getoperationResultArea();
                try {
                    boolean bl = remoteCall.isErrorResponse();
                    if (bl) {
                        smartTextPane.setCaretPosition(smartTextPane.getText().length());
                        smartTextPane.setLogicalStyle(this.redStyleOP);
                    }
                    smartTextPane.append(ReporterBean.toString(remoteCall, this.reporter.isExpand() | bl) + "\n");
                    if (bl) {
                        smartTextPane.append("\n");
                    }
                }
                finally {
                    smartTextPane.setLogicalStyle(this.blackStyleOP);
                }
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean isExpand() {
        return this.reporter.isExpand();
    }

    public void jButton1_ActionPerformed(ActionEvent actionEvent) {
        if (this.enabled) {
            this.getJButton1().setText("Enable output");
            this.enabled = false;
        } else {
            this.getJButton1().setText("Disable output");
            this.enabled = true;
        }
    }

    public void jCheckBoxMenuItem1_ActionPerformed(ActionEvent actionEvent) {
        this.reportLength = -1;
    }

    public void jList2_MouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16) {
            if (this.getoperationsList().locationToIndex(new java.awt.Point(10, mouseEvent.getY())) == -1) {
                return;
            }
            Operation operation = (Operation)this.getoperationsList().getSelectedValue();
            boolean bl = false;
            boolean[] blArray = operation.getMask();
            if (operation.getParameterTypes().length != 0) {
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                new CallMethodDialog(operation, this, true, this.notifier, this).setVisible(true);
            } else {
                this.invokeOperation(operation, new Object[operation.getParameterTypes().length]);
            }
        }
    }

    public void jTextField1_ActionPerformed() {
        if (this.editing && this.getJTextField1().getText() != "") {
            this.maxLines = 0;
            try {
                int n = Integer.parseInt(this.getJTextField1().getText());
                this.maxLines = n > 0 ? (n < Integer.MAX_VALUE ? n : Integer.MAX_VALUE) : 1;
            }
            catch (NumberFormatException numberFormatException) {
                this.maxLines = this.reportLength;
            }
            this.getJTextField1().setText(Integer.toString(this.maxLines));
            this.getJTextField1().setBackground(this.getJPanel1().getBackground());
            this.getReportArea().setMaxLines(this.maxLines * (this.reportLength - 1));
            this.checkChartPointsSize();
            this.editing = false;
        }
    }

    public void jTextField1_FocusGained() {
        if (!this.editing) {
            this.getJTextField1().setBackground(this.getReportArea().getBackground());
            this.editing = true;
        }
    }

    public void jTextField1_FocusLost() {
        if (this.editing) {
            this.getJTextField1().setText(Integer.toString(this.getReportArea().getMaxLines()));
            this.getJTextField1().setBackground(this.getJPanel1().getBackground());
            this.editing = false;
        }
    }

    public static void main(String[] stringArray) {
        try {
            CallMethodDialog callMethodDialog = new CallMethodDialog();
            callMethodDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            callMethodDialog.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }

    private void processChartValues(RemoteResponse remoteResponse) {
        Object[] objectArray = remoteResponse.getData();
        double[] dArray = new double[this.numberIndexes.size() + 1];
        dArray[0] = (double)remoteResponse.getTimestamp() / 1000.0;
        this.maxs[0] = dArray[0];
        for (int i = 0; i < this.numberIndexes.size(); ++i) {
            int n = ((Number)this.numberIndexes.get(i)).intValue();
            double d = 0.0;
            d = objectArray[n] instanceof Long ? (double)((Long)objectArray[n] / 1000L) : ((Number)objectArray[n]).doubleValue();
            int n2 = i + 1;
            dArray[n2] = d;
            if (d < this.mins[n2]) {
                this.mins[n2] = d;
            }
            if (!(d > this.maxs[n2])) continue;
            this.maxs[n2] = d;
        }
        this.chartData.add(dArray);
        if (this.chartData.size() > this.maxLines) {
            this.chartData.remove(0);
        }
        if (this.selectedChartValue != -1 && this.selectedChartXValue != -1) {
            this.model.reloadChartData();
        } else {
            this.mins[0] = this.chartData.get(0)[0];
        }
    }

    private static String processResponse(RemoteResponse remoteResponse, boolean bl) {
        return "\n" + ReporterBean.toString(remoteResponse, bl) + "\n";
    }

    public void remoteResponseWindow_Initialize() {
        this.getReportArea().getPopup().add(this.getJCheckBoxMenuItem1());
        this.getJTextField1().setText(Integer.toString(this.maxLines));
        if (this.rr != null && this.rr.getInvocation().isControllable()) {
            DefaultListModel<Operation> defaultListModel = new DefaultListModel<Operation>();
            Operation[] operationArray = this.rr.getInvocation().getOperations();
            for (int i = 0; i < operationArray.length; ++i) {
                defaultListModel.addElement(operationArray[i]);
            }
            this.getoperationsList().setModel(defaultListModel);
            this.getoperationsList().revalidate();
        }
        if (this.rr != null && !this.rr.getInvocation().isControllable()) {
            this.setDefaultCloseOperation(2);
        }
    }

    public void remoteResponseWindow_WindowDeiconified(WindowEvent windowEvent) {
        this.getReportArea().append(this.minimText.toString());
        this.minimText = new StringBuffer();
        this.minimTextReportCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportRemoteResponse(RemoteResponse remoteResponse) {
        this.getJLabel3().setText(String.valueOf(remoteResponse.getSequenceNumber()));
        this.getmessageField().setText(remoteResponse.getName());
        if (this.enabled) {
            this.processChartValues(remoteResponse);
            if (this.textOutputTabSelected) {
                boolean bl = remoteResponse.isErrorResponse();
                String string = RemoteResponseWindow.processResponse(remoteResponse, bl | this.isExpand());
                if (this.reportLength == -1) {
                    this.reportLength = DataFormatter.getLineCount((String)string);
                    this.editing = true;
                    this.jTextField1_ActionPerformed();
                }
                if (this.getState() == 1) {
                    this.minimText.append(string);
                    if (this.minimTextReportCount > this.maxLines) {
                        this.minimText.delete(0, string.length());
                    } else {
                        ++this.minimTextReportCount;
                    }
                } else {
                    SmartTextPane smartTextPane = this.getReportArea();
                    try {
                        if (bl) {
                            smartTextPane.setCaretPosition(smartTextPane.getText().length());
                            smartTextPane.setLogicalStyle(this.redStyle);
                        }
                        smartTextPane.append(string);
                        if (bl) {
                            smartTextPane.append("\n");
                        }
                    }
                    finally {
                        smartTextPane.setLogicalStyle(this.blackStyle);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceived(RemoteResponse remoteResponse) {
        SmartTextPane smartTextPane = this.getoperationResultArea();
        try {
            boolean bl = remoteResponse.isErrorResponse();
            if (bl) {
                smartTextPane.setCaretPosition(smartTextPane.getText().length());
                smartTextPane.setLogicalStyle(this.redStyleOP);
            }
            smartTextPane.append(ReporterBean.toString(remoteResponse, this.reporter.isExpand() | bl) + "\n");
            if (bl) {
                smartTextPane.append("\n");
            }
        }
        finally {
            smartTextPane.setLogicalStyle(this.blackStyleOP);
        }
    }

    public void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    public void setDisposeOnDestroy(boolean bl) {
        this.disposeOnDestroy = bl;
        if (this.disposeOnDestroy && this.destroyed) {
            this.dispose();
        }
    }

    public synchronized void setSelectedChartValue(int n) {
        if (n != this.selectedChartValue) {
            if (this.selectedChartValue == -1 && this.selectedChartXValue != -1) {
                this.model.setChartService(this.getTrend().getChartArea().getChartService());
                this.getTrend().getChartArea().addDataModel((ChartDataModel)this.model);
            } else {
                this.selectedChartValue = n;
                this.model.reloadChartData();
            }
            this.selectedChartValue = n;
        }
    }

    public synchronized void setSelectedChartXValue(int n) {
        if (n != this.selectedChartXValue) {
            if (this.selectedChartXValue == -1 && this.selectedChartValue != -1) {
                this.model.setChartService(this.getTrend().getChartArea().getChartService());
                this.getTrend().getChartArea().addDataModel((ChartDataModel)this.model);
            } else {
                this.selectedChartXValue = n;
                this.model.reloadChartData();
            }
            this.selectedChartXValue = n;
        }
    }

    class IvjEventHandler
    implements ActionListener,
    FocusListener,
    KeyListener,
    MouseListener,
    WindowListener,
    ListSelectionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == RemoteResponseWindow.this.getJButton1()) {
                RemoteResponseWindow.this.connEtoC1(actionEvent);
            }
            if (actionEvent.getSource() == RemoteResponseWindow.this.getJTextField1()) {
                RemoteResponseWindow.this.connEtoC2(actionEvent);
            }
            if (actionEvent.getSource() == RemoteResponseWindow.this.getJCheckBoxMenuItem1()) {
                RemoteResponseWindow.this.connEtoC7(actionEvent);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == RemoteResponseWindow.this.getJTextField1()) {
                RemoteResponseWindow.this.connEtoC3(focusEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == RemoteResponseWindow.this.getJTextField1()) {
                RemoteResponseWindow.this.connEtoC4(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == RemoteResponseWindow.this.getoperationsList()) {
                RemoteResponseWindow.this.connEtoC8(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == RemoteResponseWindow.this.getJList1()) {
                RemoteResponseWindow.this.connPtoP1SetTarget();
            }
            if (listSelectionEvent.getSource() == RemoteResponseWindow.this.getJList2()) {
                RemoteResponseWindow.this.connPtoP2SetTarget();
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            RemoteResponseWindow.this.setDestroyed(true);
            if (RemoteResponseWindow.this.rr != null) {
                RemoteResponseWindow.this.rr.getInvocation().requestDestroy();
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            if (windowEvent.getSource() == RemoteResponseWindow.this) {
                RemoteResponseWindow.this.connEtoC5(windowEvent);
            }
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    class OETrendDataModel
    extends AbstractDataModel {
        private RemoteResponseWindow rrWindow = null;
        private int pos = -1;

        public OETrendDataModel(RemoteResponseWindow remoteResponseWindow2) {
            this.rrWindow = remoteResponseWindow2;
            this.setPreferedXScale(new Interval(0.0, 1000.0));
            this.setPreferedYScale(new Interval(0.0, 1000.0));
        }

        public PointIterator getPointIterator() {
            this.pos = -1;
            return this;
        }

        public Interval getXBounds() {
            double d = this.getX(0);
            double d2 = this.getX(this.size() - 1);
            double d3 = (d2 - d) / 100.0;
            return new Interval(d - d3, d2 + d3);
        }

        public Interval getYBounds() {
            Interval interval = this.rrWindow.getChartYBounds();
            return interval;
        }

        public synchronized boolean hasNext() {
            return this.pos < this.size() - 1;
        }

        public synchronized Point next() {
            ++this.pos;
            return new Point(this.getX(this.pos), this.getY(this.pos));
        }

        private double getX(int n) {
            return this.rrWindow.getChartX(n);
        }

        private double getY(int n) {
            return this.rrWindow.getChartY(n);
        }

        private int size() {
            return this.rrWindow.getChartSize();
        }

        public void updateChartData() {
            this.getPreferedXScale().set(this.getXBounds());
            this.getPreferedYScale().set(this.getYBounds());
            this.pointCount = this.size();
            super.updateChartData();
        }

        public void reloadChartData() {
            this.getPreferedXScale().set(this.getXBounds());
            this.getPreferedYScale().set(this.getYBounds());
            this.pointCount = this.size();
            super.reloadChartData();
        }

        public String toString() {
            return " size:" + this.size() + " x:" + this.getX(0) + " y:" + this.getY(0);
        }
    }
}

