/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer;

import com.cosylab.gui.components.r2.InterceptorPane;
import com.cosylab.gui.components.r2.SmartPanel;
import com.cosylab.gui.components.r2.SmartTextPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import si.ijs.acs.objectexplorer.FirstTimeExpandedEvent;
import si.ijs.acs.objectexplorer.NotificationBean;
import si.ijs.acs.objectexplorer.OETree;
import si.ijs.acs.objectexplorer.OETreeEventListener;
import si.ijs.acs.objectexplorer.ReporterBean;
import si.ijs.acs.objectexplorer.TreeHandlerBean;
import si.ijs.acs.objectexplorer.engine.Converter;
import si.ijs.acs.objectexplorer.engine.Introspectable;
import si.ijs.acs.objectexplorer.engine.SimpleIntrospectable;

public class ObjectExplorer
extends JFrame {
    private boolean ready = false;
    private JMenu eMenu = null;
    private JPanel ivjJFrameContentPane = null;
    private JPanel ivjObjectExplorerPane = null;
    private JButton ivjJButton1 = null;
    private JPanel ivjJPanel2 = null;
    private JSplitPane ivjJSplitPane1 = null;
    private JSplitPane ivjJSplitPane2 = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JScrollPane ivjJScrollPane1 = null;
    private OETree ivjOETree1 = null;
    private JSplitPane ivjJSplitPane3 = null;
    private JScrollPane ivjJScrollPane4 = null;
    private TreeHandlerBean ivjTreeHandlerBean1 = null;
    private NotificationBean ivjNotificationBean1 = null;
    private JScrollPane ivjJScrollPane5 = null;
    private JMenuBar ivjObjectExplorerJMenuBar = null;
    private JCheckBoxMenuItem ivjJCheckBoxMenuItem1 = null;
    private JCheckBoxMenuItem ivjJCheckBoxMenuItem2 = null;
    private JMenu ivjJMenu2 = null;
    private JCheckBoxMenuItem ivjdebugCheckBox = null;
    private JMenuItem ivjconnectMenuItem = null;
    private JPopupMenu ivjoeTreePopup = null;
    private JMenuItem ivjdisconnectMenuItem = null;
    private JMenu ivjconverterMenu = null;
    private JSeparator ivjJSeparator2 = null;
    private JLabel ivjJLabel1 = null;
    private JMenu ivjFile = null;
    private JMenuItem ivjJMenuItem1 = null;
    private JSeparator ivjJSeparator1 = null;
    private SmartTextPane ivjSmartTextArea2 = null;
    private SmartPanel ivjMessages = null;
    private JPanel ivjJPanel1 = null;
    private SmartPanel ivjResults = null;
    private boolean ivjConnPtoP4Aligning = false;
    private boolean ivjConnPtoP5Aligning = false;
    private SmartTextPane ivjSmartTextArea3 = null;
    private JButton ivjJButton2 = null;
    private JButton ivjJButton3 = null;
    private JPanel ivjJDialogContentPane = null;
    private JLabel ivjJLabel2 = null;
    private JTextField ivjJTextField1 = null;
    private JMenu ivjConnectMenu = null;
    private JDialog ivjOtherRemoteAccessDialog = null;
    private static Map converters = new HashMap();
    private JTabbedPane jTabbedPaneTreesContainer = null;
    private JPanel jPanelTreeByName = null;
    private JScrollPane jScrollPaneTreeByName = null;
    private OETree oeTreeByName = null;
    private Hashtable devices = new Hashtable();
    private JButton jButtonSearchTreeByName = null;
    private static final String CONVERTER_PROPERTY = "objexp.converters";
    private static ArrayList converterRepository = new ArrayList();
    private ReporterBean ivjReporterBean = null;

    public synchronized boolean isReady() {
        return this.ready;
    }

    public synchronized void setReady(boolean bl) {
        this.ready = bl;
    }

    public static Converter getConverter(SimpleIntrospectable simpleIntrospectable) {
        return (Converter)converters.get(simpleIntrospectable);
    }

    public static void removeConverter(SimpleIntrospectable simpleIntrospectable) {
        converters.remove(simpleIntrospectable);
    }

    public static void addConverter(SimpleIntrospectable simpleIntrospectable, Converter converter) {
        converters.put(simpleIntrospectable, converter);
    }

    public List getConverterRepository() {
        return converterRepository;
    }

    private void loadConverters() {
        try {
            String string = System.getProperty(CONVERTER_PROPERTY);
            this.getNotificationBean1().reportDebug("ObjectExplorer::loadConverters", "Startup using 'objexp.converters' = '" + string + "'.");
            if (string == null) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if ((string2 = string2.trim()).length() > 0 && !string2.startsWith("#")) {
                    try {
                        Class<?> clazz = Class.forName(string2);
                        Converter converter = (Converter)clazz.getConstructor(null).newInstance(null);
                        this.getNotificationBean1().reportDebug("ObjectExplorer::loadConverters", "Loaded converter '" + string2 + "' (" + converter.getDescription() + ").");
                        converterRepository.add(converter);
                    }
                    catch (Throwable throwable) {
                        this.getNotificationBean1().reportDebug("ObjectExplorer::loadConverters", "Failed to load converter '" + string2 + "'.");
                        throwable.printStackTrace();
                    }
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.getNotificationBean1().reportDebug("ObjectExplorer::loadConverters", "Registered " + converterRepository.size() + " converter(s).");
    }

    public ObjectExplorer() {
        this.initialize();
        this.loadConverters();
    }

    public void addEngineMenu(JMenu jMenu) {
        if (this.eMenu != null) {
            this.removeEngineMenu();
        }
        this.eMenu = jMenu;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMenuBar jMenuBar = ObjectExplorer.this.getObjectExplorerJMenuBar();
                jMenuBar.add((Component)ObjectExplorer.this.eMenu);
                jMenuBar.revalidate();
                jMenuBar.repaint();
            }
        });
    }

    private void connEtoC1(ActionEvent actionEvent) {
        try {
            this.startConnect(this.getJTextField1().getText());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3(MouseEvent mouseEvent) {
        try {
            this.oETree1_MouseClicked(mouseEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC4(ActionEvent actionEvent) {
        try {
            this.systemExit();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM1(FirstTimeExpandedEvent firstTimeExpandedEvent) {
        try {
            this.getTreeHandlerBean1().getDevices(firstTimeExpandedEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM10(ActionEvent actionEvent) {
        try {
            this.getNotificationBean1().setDebugToConsole();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM11(ActionEvent actionEvent) {
        try {
            this.getTreeHandlerBean1().disconnect();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM12(ActionEvent actionEvent) {
        try {
            this.getTreeHandlerBean1().connect();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM13(ActionEvent actionEvent) {
        try {
            this.setEnabled(false);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM15(ActionEvent actionEvent) {
        try {
            this.getOtherRemoteAccessDialog().dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM17(ActionEvent actionEvent) {
        try {
            this.getOtherRemoteAccessDialog().dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM2() {
        try {
            this.getTreeHandlerBean1().selectionChanged(this.getOETree1());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM3(ActionEvent actionEvent) {
        try {
            this.getOETree1().clearTree();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM5(ActionEvent actionEvent) {
        try {
            this.getOETree1().clearTree();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM6(WindowEvent windowEvent) {
        try {
            this.getTreeHandlerBean1().destroy();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM8(ActionEvent actionEvent) {
        try {
            this.getReporterBean().setExpand();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM9(ActionEvent actionEvent) {
        try {
            this.getReporterBean().setWindow();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connPtoP10SetTarget() {
        try {
            this.getNotificationBean1().setTextArea(this.getSmartTextArea2());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connPtoP11SetTarget() {
        try {
            this.getJLabel2().setLabelFor(this.getJTextField1());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connPtoP13SetTarget() {
        try {
            this.getReporterBean().setResultArea(this.getSmartTextArea3());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connPtoP14SetTarget() {
        try {
            this.getNotificationBean1().setParent(this);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            this.getTreeHandlerBean1().setNotifier(this.getNotificationBean1());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            this.getTreeHandlerBean1().setTree(this.getOETree1());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connPtoP3SetTarget() {
        try {
            this.getReporterBean().setNotifier(this.getNotificationBean1());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connPtoP4SetSource() {
        try {
            if (!this.ivjConnPtoP4Aligning) {
                this.ivjConnPtoP4Aligning = true;
                this.getJSplitPane3().setDividerSize(this.getJSplitPane1().getDividerSize());
                this.ivjConnPtoP4Aligning = false;
            }
        }
        catch (Throwable throwable) {
            this.ivjConnPtoP4Aligning = false;
            this.handleException(throwable);
        }
    }

    private void connPtoP4SetTarget() {
        try {
            if (!this.ivjConnPtoP4Aligning) {
                this.ivjConnPtoP4Aligning = true;
                this.getJSplitPane1().setDividerSize(this.getJSplitPane3().getDividerSize());
                this.ivjConnPtoP4Aligning = false;
            }
        }
        catch (Throwable throwable) {
            this.ivjConnPtoP4Aligning = false;
            this.handleException(throwable);
        }
    }

    private void connPtoP5SetSource() {
        try {
            if (!this.ivjConnPtoP5Aligning) {
                this.ivjConnPtoP5Aligning = true;
                this.getJSplitPane3().setDividerSize(this.getJSplitPane2().getDividerSize());
                this.ivjConnPtoP5Aligning = false;
            }
        }
        catch (Throwable throwable) {
            this.ivjConnPtoP5Aligning = false;
            this.handleException(throwable);
        }
    }

    private void connPtoP5SetTarget() {
        try {
            if (!this.ivjConnPtoP5Aligning) {
                this.ivjConnPtoP5Aligning = true;
                this.getJSplitPane2().setDividerSize(this.getJSplitPane3().getDividerSize());
                this.ivjConnPtoP5Aligning = false;
            }
        }
        catch (Throwable throwable) {
            this.ivjConnPtoP5Aligning = false;
            this.handleException(throwable);
        }
    }

    private void connPtoP7SetTarget() {
        try {
            this.getTreeHandlerBean1().setParent(this);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private JMenu getConnectMenu() {
        if (this.ivjConnectMenu == null) {
            try {
                this.ivjConnectMenu = new JMenu();
                this.ivjConnectMenu.setName("ConnectMenu");
                this.ivjConnectMenu.setMnemonic('c');
                this.ivjConnectMenu.setText("Connect    ");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConnectMenu;
    }

    private JMenuItem getconnectMenuItem() {
        if (this.ivjconnectMenuItem == null) {
            try {
                this.ivjconnectMenuItem = new JMenuItem();
                this.ivjconnectMenuItem.setName("connectMenuItem");
                this.ivjconnectMenuItem.setText("connect");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjconnectMenuItem;
    }

    private JMenu getconverterMenu() {
        if (this.ivjconverterMenu == null) {
            try {
                this.ivjconverterMenu = new JMenu();
                this.ivjconverterMenu.setName("converterMenu");
                this.ivjconverterMenu.setText("convert");
                List list = this.getConverterRepository();
                if (list.size() > 0) {
                    JMenuItem jMenuItem = new JMenuItem("none");
                    jMenuItem.addActionListener(new SetConverterActionListener(null));
                    this.ivjconverterMenu.add(jMenuItem);
                    this.ivjconverterMenu.add(new JSeparator());
                }
                for (Converter converter : list) {
                    JMenuItem jMenuItem = new JMenuItem(converter.getDescription());
                    jMenuItem.addActionListener(new SetConverterActionListener(converter));
                    this.ivjconverterMenu.add(jMenuItem);
                }
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjconverterMenu;
    }

    private JCheckBoxMenuItem getdebugCheckBox() {
        if (this.ivjdebugCheckBox == null) {
            try {
                this.ivjdebugCheckBox = new JCheckBoxMenuItem();
                this.ivjdebugCheckBox.setName("debugCheckBox");
                this.ivjdebugCheckBox.setSelected(true);
                this.ivjdebugCheckBox.setMnemonic('d');
                this.ivjdebugCheckBox.setText("Debug to console");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjdebugCheckBox;
    }

    private JMenuItem getdisconnectMenuItem() {
        if (this.ivjdisconnectMenuItem == null) {
            try {
                this.ivjdisconnectMenuItem = new JMenuItem();
                this.ivjdisconnectMenuItem.setName("disconnectMenuItem");
                this.ivjdisconnectMenuItem.setSelected(true);
                this.ivjdisconnectMenuItem.setText("disconnect");
                this.ivjdisconnectMenuItem.setEnabled(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjdisconnectMenuItem;
    }

    private JMenu getFile() {
        if (this.ivjFile == null) {
            try {
                this.ivjFile = new JMenu();
                this.ivjFile.setName("File");
                this.ivjFile.setMnemonic('F');
                this.ivjFile.setText("File   ");
                this.ivjFile.add(this.getConnectMenu());
                this.ivjFile.add(this.getJSeparator1());
                this.ivjFile.add(this.getJMenuItem1());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFile;
    }

    private JButton getJButton1() {
        if (this.ivjJButton1 == null) {
            try {
                this.ivjJButton1 = new JButton();
                this.ivjJButton1.setName("JButton1");
                this.ivjJButton1.setMnemonic('S');
                this.ivjJButton1.setText("Search");
                this.ivjJButton1.setMaximumSize(new Dimension(150, 25));
                this.ivjJButton1.setPreferredSize(new Dimension(150, 25));
                this.ivjJButton1.setEnabled(false);
                this.ivjJButton1.setMinimumSize(new Dimension(150, 25));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButton1;
    }

    private JButton getJButton2() {
        if (this.ivjJButton2 == null) {
            try {
                this.ivjJButton2 = new JButton();
                this.ivjJButton2.setName("JButton2");
                this.ivjJButton2.setText("OK");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButton2;
    }

    private JButton getJButton3() {
        if (this.ivjJButton3 == null) {
            try {
                this.ivjJButton3 = new JButton();
                this.ivjJButton3.setName("JButton3");
                this.ivjJButton3.setText("Cancel");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButton3;
    }

    private JCheckBoxMenuItem getJCheckBoxMenuItem1() {
        if (this.ivjJCheckBoxMenuItem1 == null) {
            try {
                this.ivjJCheckBoxMenuItem1 = new JCheckBoxMenuItem();
                this.ivjJCheckBoxMenuItem1.setName("JCheckBoxMenuItem1");
                this.ivjJCheckBoxMenuItem1.setMnemonic('e');
                this.ivjJCheckBoxMenuItem1.setText("Expand result data");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJCheckBoxMenuItem1;
    }

    private JCheckBoxMenuItem getJCheckBoxMenuItem2() {
        if (this.ivjJCheckBoxMenuItem2 == null) {
            try {
                this.ivjJCheckBoxMenuItem2 = new JCheckBoxMenuItem();
                this.ivjJCheckBoxMenuItem2.setName("JCheckBoxMenuItem2");
                this.ivjJCheckBoxMenuItem2.setSelected(true);
                this.ivjJCheckBoxMenuItem2.setMnemonic('i');
                this.ivjJCheckBoxMenuItem2.setText("Invocation response in a separate window");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJCheckBoxMenuItem2;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(4, 10, 8, 10);
                this.getJDialogContentPane().add((Component)this.getJTextField1(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 2;
                gridBagConstraints2.anchor = 14;
                gridBagConstraints2.weightx = 1.0;
                gridBagConstraints2.weighty = 1.0;
                gridBagConstraints2.ipadx = 20;
                gridBagConstraints2.insets = new Insets(4, 4, 8, 5);
                this.getJDialogContentPane().add((Component)this.getJButton2(), gridBagConstraints2);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = 0;
                gridBagConstraints3.gridy = 0;
                gridBagConstraints3.gridwidth = 2;
                gridBagConstraints3.fill = 2;
                gridBagConstraints3.anchor = 17;
                gridBagConstraints3.insets = new Insets(8, 10, 4, 10);
                this.getJDialogContentPane().add((Component)this.getJLabel2(), gridBagConstraints3);
                GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
                gridBagConstraints4.gridx = 1;
                gridBagConstraints4.gridy = 2;
                gridBagConstraints4.anchor = 16;
                gridBagConstraints4.weightx = 1.0;
                gridBagConstraints4.weighty = 1.0;
                gridBagConstraints4.insets = new Insets(4, 5, 8, 4);
                this.getJDialogContentPane().add((Component)this.getJButton3(), gridBagConstraints4);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.getJFrameContentPane().add((Component)this.getObjectExplorerPane(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setFont(new Font("Arial", 1, 14));
                this.ivjJLabel1.setText("   Object name");
                this.ivjJLabel1.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                this.ivjJLabel1.setBounds(10, 0, 1, 1);
                this.ivjJLabel1.setForeground(SystemColor.controlText);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setDisplayedMnemonic('E');
                this.ivjJLabel2.setText("Enter the name of the RemoteAccess class:");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel2;
    }

    private JMenu getJMenu2() {
        if (this.ivjJMenu2 == null) {
            try {
                this.ivjJMenu2 = new JMenu();
                this.ivjJMenu2.setName("JMenu2");
                this.ivjJMenu2.setMnemonic('V');
                this.ivjJMenu2.setText("View");
                this.ivjJMenu2.add(this.getJCheckBoxMenuItem1());
                this.ivjJMenu2.add(this.getJCheckBoxMenuItem2());
                this.ivjJMenu2.add(this.getdebugCheckBox());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJMenu2;
    }

    private JMenuItem getJMenuItem1() {
        if (this.ivjJMenuItem1 == null) {
            try {
                this.ivjJMenuItem1 = new JMenuItem();
                this.ivjJMenuItem1.setName("JMenuItem1");
                this.ivjJMenuItem1.setMnemonic('x');
                this.ivjJMenuItem1.setText("Exit");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJMenuItem1;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(null);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 4.0;
                gridBagConstraints.weighty = 1.0;
                this.getJPanel2().add((Component)this.getJScrollPane1(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 0;
                gridBagConstraints2.fill = 1;
                this.getJPanel2().add((Component)this.getJButton1(), gridBagConstraints2);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanel2;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getOETree1());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JScrollPane getJScrollPane4() {
        if (this.ivjJScrollPane4 == null) {
            try {
                this.ivjJScrollPane4 = new JScrollPane();
                this.ivjJScrollPane4.setName("JScrollPane4");
                this.getJScrollPane4().setViewportView((Component)this.getSmartTextArea3());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane4;
    }

    private JScrollPane getJScrollPane5() {
        if (this.ivjJScrollPane5 == null) {
            try {
                this.ivjJScrollPane5 = new JScrollPane();
                this.ivjJScrollPane5.setName("JScrollPane5");
                this.getJScrollPane5().setViewportView((Component)this.getSmartTextArea2());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane5;
    }

    private JSeparator getJSeparator1() {
        if (this.ivjJSeparator1 == null) {
            try {
                this.ivjJSeparator1 = new JSeparator();
                this.ivjJSeparator1.setName("JSeparator1");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSeparator1;
    }

    private JSeparator getJSeparator2() {
        if (this.ivjJSeparator2 == null) {
            try {
                this.ivjJSeparator2 = new JSeparator();
                this.ivjJSeparator2.setName("JSeparator2");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSeparator2;
    }

    private JSplitPane getJSplitPane1() {
        if (this.ivjJSplitPane1 == null) {
            try {
                this.ivjJSplitPane1 = new JSplitPane(1);
                this.ivjJSplitPane1.setName("JSplitPane1");
                this.ivjJSplitPane1.setDividerLocation(200);
                this.getJSplitPane1().add((Component)this.getJTabbedPaneTreesContainer(), "left");
                this.getJSplitPane1().add((Component)this.getJPanel1(), "right");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSplitPane1;
    }

    private JSplitPane getJSplitPane2() {
        if (this.ivjJSplitPane2 == null) {
            try {
                this.ivjJSplitPane2 = new JSplitPane(1);
                this.ivjJSplitPane2.setName("JSplitPane2");
                this.ivjJSplitPane2.setDividerLocation(350);
                this.getJSplitPane2().add((Component)this.getMessages(), "left");
                this.getJSplitPane2().add((Component)this.getResults(), "right");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSplitPane2;
    }

    private JSplitPane getJSplitPane3() {
        if (this.ivjJSplitPane3 == null) {
            try {
                this.ivjJSplitPane3 = new JSplitPane(0);
                this.ivjJSplitPane3.setName("JSplitPane3");
                this.ivjJSplitPane3.setDividerSize(8);
                this.getJSplitPane3().add((Component)this.getJSplitPane1(), "top");
                this.getJSplitPane3().add((Component)this.getJSplitPane2(), "bottom");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSplitPane3;
    }

    private JTextField getJTextField1() {
        if (this.ivjJTextField1 == null) {
            try {
                this.ivjJTextField1 = new JTextField();
                this.ivjJTextField1.setName("JTextField1");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJTextField1;
    }

    private SmartPanel getMessages() {
        if (this.ivjMessages == null) {
            try {
                this.ivjMessages = new SmartPanel();
                this.ivjMessages.setName("Messages");
                this.ivjMessages.setLayout((LayoutManager)new CardLayout());
                this.getMessages().add((Component)this.getJScrollPane5(), (Object)this.getJScrollPane5().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMessages;
    }

    private NotificationBean getNotificationBean1() {
        if (this.ivjNotificationBean1 == null) {
            try {
                this.ivjNotificationBean1 = new NotificationBean();
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjNotificationBean1;
    }

    private JMenuBar getObjectExplorerJMenuBar() {
        if (this.ivjObjectExplorerJMenuBar == null) {
            try {
                this.ivjObjectExplorerJMenuBar = new JMenuBar();
                this.ivjObjectExplorerJMenuBar.setName("ObjectExplorerJMenuBar");
                this.ivjObjectExplorerJMenuBar.add(this.getFile());
                this.ivjObjectExplorerJMenuBar.add(this.getJMenu2());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjObjectExplorerJMenuBar;
    }

    private JPanel getObjectExplorerPane() {
        if (this.ivjObjectExplorerPane == null) {
            try {
                this.ivjObjectExplorerPane = new JPanel();
                this.ivjObjectExplorerPane.setName("ObjectExplorerPane");
                this.ivjObjectExplorerPane.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(4, 4, 4, 4);
                this.getObjectExplorerPane().add((Component)this.getJSplitPane3(), gridBagConstraints);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjObjectExplorerPane;
    }

    private OETree getOETree1() {
        if (this.ivjOETree1 == null) {
            try {
                this.ivjOETree1 = new OETree();
                this.ivjOETree1.setName("OETree1");
                this.ivjOETree1.setBounds(0, 0, 600, 266);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjOETree1;
    }

    private JPopupMenu getoeTreePopup() {
        if (this.ivjoeTreePopup == null) {
            try {
                this.ivjoeTreePopup = new JPopupMenu();
                this.ivjoeTreePopup.setName("oeTreePopup");
                this.ivjoeTreePopup.setBackground(SystemColor.control);
                this.ivjoeTreePopup.setForeground(SystemColor.controlText);
                this.getoeTreePopup().add((Component)this.getJLabel1(), this.getJLabel1().getName());
                this.ivjoeTreePopup.add(this.getJSeparator2());
                this.ivjoeTreePopup.add(this.getdisconnectMenuItem());
                this.ivjoeTreePopup.add(this.getconnectMenuItem());
                this.ivjoeTreePopup.add(this.getconverterMenu());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjoeTreePopup;
    }

    private JDialog getOtherRemoteAccessDialog() {
        if (this.ivjOtherRemoteAccessDialog == null) {
            try {
                this.ivjOtherRemoteAccessDialog = new JDialog();
                this.ivjOtherRemoteAccessDialog.setName("OtherRemoteAccessDialog");
                this.ivjOtherRemoteAccessDialog.setDefaultCloseOperation(2);
                this.ivjOtherRemoteAccessDialog.setTitle("Other Remote Access Type");
                this.ivjOtherRemoteAccessDialog.setBounds(487, 37, 310, 124);
                this.ivjOtherRemoteAccessDialog.setModal(true);
                this.ivjOtherRemoteAccessDialog.setResizable(false);
                this.getOtherRemoteAccessDialog().setContentPane(this.getJDialogContentPane());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjOtherRemoteAccessDialog;
    }

    public ReporterBean getReporter() {
        return this.getReporterBean();
    }

    private ReporterBean getReporterBean() {
        if (this.ivjReporterBean == null) {
            try {
                this.ivjReporterBean = new ReporterBean();
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjReporterBean;
    }

    private SmartPanel getResults() {
        if (this.ivjResults == null) {
            try {
                this.ivjResults = new SmartPanel();
                this.ivjResults.setName("Results");
                this.ivjResults.setLayout((LayoutManager)new BorderLayout());
                this.getResults().add((Component)this.getJScrollPane4(), (Object)"Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjResults;
    }

    private SmartTextPane getSmartTextArea2() {
        if (this.ivjSmartTextArea2 == null) {
            try {
                this.ivjSmartTextArea2 = new SmartTextPane();
                this.ivjSmartTextArea2.setName("SmartTextArea2");
                this.ivjSmartTextArea2.setBounds(0, 0, 131, 72);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSmartTextArea2;
    }

    private SmartTextPane getSmartTextArea3() {
        if (this.ivjSmartTextArea3 == null) {
            try {
                this.ivjSmartTextArea3 = new SmartTextPane();
                this.ivjSmartTextArea3.setName("SmartTextArea3");
                this.ivjSmartTextArea3.setBounds(0, 0, 160, 120);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSmartTextArea3;
    }

    private TreeHandlerBean getTreeHandlerBean1() {
        if (this.ivjTreeHandlerBean1 == null) {
            try {
                this.ivjTreeHandlerBean1 = new TreeHandlerBean(this.devices, this.getOETree1(), this.getOETreeByName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjTreeHandlerBean1;
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION in Object Explorer ---------");
        throwable.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getJButton1().addActionListener(this.ivjEventHandler);
        this.getJButtonSearchTreeByName().addActionListener(this.ivjEventHandler);
        this.getOETree1().addOETreeEventListener(this.ivjEventHandler);
        this.getOETreeByName().addOETreeEventListener(this.ivjEventHandler);
        this.addWindowListener(this.ivjEventHandler);
        this.getJCheckBoxMenuItem1().addActionListener(this.ivjEventHandler);
        this.getJCheckBoxMenuItem2().addActionListener(this.ivjEventHandler);
        this.getdebugCheckBox().addActionListener(this.ivjEventHandler);
        this.getOETree1().addMouseListener(this.ivjEventHandler);
        this.getOETreeByName().addMouseListener(this.ivjEventHandler);
        this.getdisconnectMenuItem().addActionListener(this.ivjEventHandler);
        this.getconnectMenuItem().addActionListener(this.ivjEventHandler);
        this.getJMenuItem1().addActionListener(this.ivjEventHandler);
        this.getOETree1().addTreeSelectionListener(this.ivjEventHandler);
        this.getOETreeByName().addTreeSelectionListener(this.ivjEventHandler);
        this.getJSplitPane3().addPropertyChangeListener(this.ivjEventHandler);
        this.getJSplitPane1().addPropertyChangeListener(this.ivjEventHandler);
        this.getJSplitPane2().addPropertyChangeListener(this.ivjEventHandler);
        this.getConnectMenu().addActionListener(this.ivjEventHandler);
        this.getJButton3().addActionListener(this.ivjEventHandler);
        this.getJButton2().addActionListener(this.ivjEventHandler);
        this.connPtoP2SetTarget();
        this.connPtoP1SetTarget();
        this.connPtoP14SetTarget();
        this.connPtoP7SetTarget();
        this.connPtoP3SetTarget();
        this.connPtoP10SetTarget();
        this.connPtoP4SetTarget();
        this.connPtoP5SetTarget();
        this.connPtoP11SetTarget();
        this.connPtoP13SetTarget();
    }

    private void initEngines(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jRadioButtonMenuItem.setActionCommand(stringArray[i]);
            jRadioButtonMenuItem.setName(stringArray[i]);
            jRadioButtonMenuItem.setText(stringArray[i]);
            jRadioButtonMenuItem.setSelected(false);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ObjectExplorer.this.startConnect(((JRadioButtonMenuItem)actionEvent.getSource()).getName());
                }
            });
            this.getConnectMenu().add(jRadioButtonMenuItem);
        }
        this.getConnectMenu().add(new JSeparator());
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setActionCommand("Other");
        jMenuItem.setName("Other");
        jMenuItem.setText("Other...");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectExplorer.this.getOtherRemoteAccessDialog().show();
            }
        });
        this.getConnectMenu().add(jMenuItem);
        if (stringArray.length > 0) {
            this.startConnect(stringArray[0]);
        }
    }

    private void initialize() {
        try {
            this.setName("ObjectExplorer");
            this.setDefaultCloseOperation(2);
            this.setJMenuBar(this.getObjectExplorerJMenuBar());
            this.setBounds(50, 50, 50, 50);
            this.setSize(760, 655);
            this.setTitle("Object Explorer");
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        this.setGlassPane((Component)new InterceptorPane((Window)this));
    }

    private JTabbedPane getJTabbedPaneTreesContainer() {
        if (this.jTabbedPaneTreesContainer == null) {
            try {
                this.jTabbedPaneTreesContainer = new JTabbedPane();
                this.jTabbedPaneTreesContainer.addTab("By type", this.getJPanel2());
                this.jTabbedPaneTreesContainer.addTab("By device", this.getJPanelTreeByName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.jTabbedPaneTreesContainer;
    }

    private JPanel getJPanelTreeByName() {
        if (this.jPanelTreeByName == null) {
            try {
                this.jPanelTreeByName = new JPanel();
                this.jPanelTreeByName.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 4.0;
                gridBagConstraints.weighty = 1.0;
                this.jPanelTreeByName.add((Component)this.getJScrollPaneTreeByName(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 0;
                gridBagConstraints2.fill = 1;
                this.jPanelTreeByName.add((Component)this.getJButtonSearchTreeByName(), gridBagConstraints2);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.jPanelTreeByName;
    }

    private JScrollPane getJScrollPaneTreeByName() {
        if (this.jScrollPaneTreeByName == null) {
            try {
                this.jScrollPaneTreeByName = new JScrollPane();
                this.getJScrollPaneTreeByName().setViewportView(this.getOETreeByName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.jScrollPaneTreeByName;
    }

    private OETree getOETreeByName() {
        if (this.oeTreeByName == null) {
            try {
                this.oeTreeByName = new OETree();
                this.oeTreeByName.setBounds(0, 0, 600, 266);
                this.oeTreeByName.setName("treeByName");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.oeTreeByName;
    }

    private JButton getJButtonSearchTreeByName() {
        if (this.jButtonSearchTreeByName == null) {
            this.jButtonSearchTreeByName = new JButton("Search");
            this.jButtonSearchTreeByName.setMnemonic('S');
            this.jButtonSearchTreeByName.setPreferredSize(new Dimension(150, 25));
            this.jButtonSearchTreeByName.setEnabled(false);
            this.jButtonSearchTreeByName.setMinimumSize(new Dimension(150, 25));
        }
        return this.jButtonSearchTreeByName;
    }

    public void oeTreeByName_MouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            TreePath treePath = this.getOETreeByName().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            Object object = null;
            if (treePath != null) {
                object = treePath.getLastPathComponent();
            }
            if (object instanceof Introspectable) {
                Introspectable introspectable = (Introspectable)object;
                this.getconnectMenuItem().setEnabled(!introspectable.isConnected());
                this.getdisconnectMenuItem().setEnabled(introspectable.isConnected());
                this.getJLabel1().setText(introspectable.toString());
                this.getTreeHandlerBean1().setClicked(introspectable);
                Converter converter = ObjectExplorer.getConverter(introspectable);
                int n = this.getconverterMenu().getItemCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem jMenuItem = this.getconverterMenu().getItem(i);
                    if (jMenuItem == null || jMenuItem.getActionListeners() == null || jMenuItem.getActionListeners().length != 1 || !(jMenuItem.getActionListeners()[0] instanceof SetConverterActionListener)) continue;
                    SetConverterActionListener setConverterActionListener = (SetConverterActionListener)jMenuItem.getActionListeners()[0];
                    if (setConverterActionListener.getConverter() == converter) {
                        jMenuItem.setEnabled(false);
                        continue;
                    }
                    jMenuItem.setEnabled(true);
                }
                this.getoeTreePopup().show(this.getOETreeByName(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void jMenuItem1_Accelerator(KeyStroke keyStroke) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            ObjectExplorer objectExplorer = new ObjectExplorer();
            objectExplorer.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            objectExplorer.setVisible(true);
            if (stringArray.length > 0) {
                objectExplorer.initEngines(stringArray);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of VajApplicationCreationWizard");
            throwable.printStackTrace(System.out);
        }
    }

    public void oETree1_MouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            TreePath treePath = this.getOETree1().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            Object object = null;
            if (treePath != null) {
                object = treePath.getLastPathComponent();
            }
            if (object instanceof Introspectable) {
                Introspectable introspectable = (Introspectable)object;
                this.getconnectMenuItem().setEnabled(!introspectable.isConnected());
                this.getdisconnectMenuItem().setEnabled(introspectable.isConnected() && !introspectable.isNonSticky());
                this.getJLabel1().setText(introspectable.toString());
                this.getTreeHandlerBean1().setClicked(introspectable);
                Converter converter = ObjectExplorer.getConverter(introspectable);
                int n = this.getconverterMenu().getItemCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem jMenuItem = this.getconverterMenu().getItem(i);
                    if (jMenuItem == null || jMenuItem.getActionListeners() == null || jMenuItem.getActionListeners().length != 1 || !(jMenuItem.getActionListeners()[0] instanceof SetConverterActionListener)) continue;
                    SetConverterActionListener setConverterActionListener = (SetConverterActionListener)jMenuItem.getActionListeners()[0];
                    if (setConverterActionListener.getConverter() == converter) {
                        jMenuItem.setEnabled(false);
                        continue;
                    }
                    jMenuItem.setEnabled(true);
                }
                this.getoeTreePopup().show(this.getOETree1(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void removeEngineMenu() {
        if (this.eMenu != null) {
            this.getObjectExplorerJMenuBar().remove(this.eMenu);
            this.getObjectExplorerJMenuBar().revalidate();
        }
        this.eMenu = null;
    }

    public void setDetailsPanel(JPanel jPanel) {
        this.getJSplitPane1().setBottomComponent(jPanel);
        if (this.getJSplitPane1().getDividerLocation() > this.getJSplitPane1().getWidth() - 20) {
            this.getJSplitPane1().setDividerLocation(300);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.getOETree1().setEnabled(bl);
        this.getJSplitPane1().setEnabled(bl);
        this.getJButton1().setEnabled(bl);
        this.getJButtonSearchTreeByName().setEnabled(bl);
        this.repaint();
    }

    private void startConnect(String string) {
        Component[] componentArray = this.getConnectMenu().getMenuComponents();
        boolean bl = false;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JRadioButtonMenuItem)) continue;
            ((JRadioButtonMenuItem)componentArray[i]).setSelected(((JRadioButtonMenuItem)componentArray[i]).getName().equals(string));
            bl = bl || ((JRadioButtonMenuItem)componentArray[i]).isSelected();
        }
        if (!bl) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jRadioButtonMenuItem.setActionCommand(string);
            jRadioButtonMenuItem.setName(string);
            jRadioButtonMenuItem.setText(string);
            jRadioButtonMenuItem.setSelected(true);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ObjectExplorer.this.startConnect(((JRadioButtonMenuItem)actionEvent.getSource()).getName());
                }
            });
            this.getConnectMenu().insert(jRadioButtonMenuItem, this.getConnectMenu().getMenuComponentCount() - 2);
        }
        this.getTreeHandlerBean1().setAccess(string);
        this.getOETree1().clearTree();
    }

    public void systemExit() {
        this.getTreeHandlerBean1().destroy();
        this.dispose();
        System.exit(0);
    }

    class SetConverterActionListener
    implements ActionListener {
        private Converter converter;

        public SetConverterActionListener(Converter converter) {
            this.converter = converter;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Introspectable introspectable = ObjectExplorer.this.getTreeHandlerBean1().getClicked();
            if (introspectable != null) {
                if (this.converter == null) {
                    ObjectExplorer.removeConverter(introspectable);
                } else {
                    ObjectExplorer.addConverter(introspectable, this.converter);
                }
            }
        }

        public Converter getConverter() {
            return this.converter;
        }
    }

    class IvjEventHandler
    implements ActionListener,
    MouseListener,
    WindowListener,
    PropertyChangeListener,
    TreeSelectionListener,
    OETreeEventListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ObjectExplorer.this.getJButton1() || actionEvent.getSource() == ObjectExplorer.this.getJButtonSearchTreeByName()) {
                ObjectExplorer.this.connEtoM13(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getJButton1() || actionEvent.getSource() == ObjectExplorer.this.getJButtonSearchTreeByName()) {
                ObjectExplorer.this.connEtoM3(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getJCheckBoxMenuItem1()) {
                ObjectExplorer.this.connEtoM8(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getJCheckBoxMenuItem2()) {
                ObjectExplorer.this.connEtoM9(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getdebugCheckBox()) {
                ObjectExplorer.this.connEtoM10(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getdisconnectMenuItem()) {
                ObjectExplorer.this.connEtoM11(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getconnectMenuItem()) {
                ObjectExplorer.this.connEtoM12(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getJMenuItem1()) {
                ObjectExplorer.this.connEtoC4(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getConnectMenu()) {
                ObjectExplorer.this.connEtoM5(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getJButton3()) {
                ObjectExplorer.this.connEtoM17(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getJButton2()) {
                ObjectExplorer.this.connEtoM15(actionEvent);
            }
            if (actionEvent.getSource() == ObjectExplorer.this.getJButton2()) {
                ObjectExplorer.this.connEtoC1(actionEvent);
            }
        }

        @Override
        public void firstTimeExpanded(FirstTimeExpandedEvent firstTimeExpandedEvent) {
            if (firstTimeExpandedEvent.getSource() == ObjectExplorer.this.getOETree1()) {
                ObjectExplorer.this.connEtoM1(firstTimeExpandedEvent);
            }
            if (firstTimeExpandedEvent.getSource() == ObjectExplorer.this.getOETreeByName() && ObjectExplorer.this.isReady()) {
                ObjectExplorer.this.getTreeHandlerBean1().getDevices(firstTimeExpandedEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == ObjectExplorer.this.getOETree1()) {
                ObjectExplorer.this.connEtoC3(mouseEvent);
            }
            if (mouseEvent.getSource() == ObjectExplorer.this.getOETreeByName()) {
                ObjectExplorer.this.oeTreeByName_MouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == ObjectExplorer.this.getJSplitPane3() && propertyChangeEvent.getPropertyName().equals("dividerSize")) {
                ObjectExplorer.this.connPtoP4SetTarget();
            }
            if (propertyChangeEvent.getSource() == ObjectExplorer.this.getJSplitPane1() && propertyChangeEvent.getPropertyName().equals("dividerSize")) {
                ObjectExplorer.this.connPtoP4SetSource();
            }
            if (propertyChangeEvent.getSource() == ObjectExplorer.this.getJSplitPane3() && propertyChangeEvent.getPropertyName().equals("dividerSize")) {
                ObjectExplorer.this.connPtoP5SetTarget();
            }
            if (propertyChangeEvent.getSource() == ObjectExplorer.this.getJSplitPane2() && propertyChangeEvent.getPropertyName().equals("dividerSize")) {
                ObjectExplorer.this.connPtoP5SetSource();
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (treeSelectionEvent.getSource() == ObjectExplorer.this.getOETree1()) {
                ObjectExplorer.this.connEtoM2();
            }
            if (treeSelectionEvent.getSource() == ObjectExplorer.this.getOETreeByName()) {
                ObjectExplorer.this.getTreeHandlerBean1().selectionChanged(ObjectExplorer.this.getOETreeByName());
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (windowEvent.getSource() == ObjectExplorer.this) {
                ObjectExplorer.this.connEtoM6(windowEvent);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

