/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import si.ijs.acs.objectexplorer.OETreeNode;
import si.ijs.acs.objectexplorer.engine.Introspectable;
import si.ijs.acs.objectexplorer.engine.Invocation;

public class OETreeCellRenderer
extends DefaultTreeCellRenderer {
    private boolean hasFocus;
    private Color connectedColor = new Color(0, 120, 116);
    private Color connectedColorSticky = new Color(120, 0, 32);
    private Color connectedBackColor = new Color(147, 185, 243);
    private Color selectedBackColor = this.getBackgroundSelectionColor();
    private boolean valuesAreOE = false;

    public Color getConnectedBackColor() {
        return this.connectedBackColor;
    }

    public Color getConnectedColor() {
        return this.connectedColor;
    }

    public Color getConnectedColorSticky() {
        return this.connectedColorSticky;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.setComponentOrientation(jTree.getComponentOrientation());
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.hasFocus = bl4;
        if (!this.valuesAreOE) {
            if (object instanceof OETreeNode) {
                this.valuesAreOE = true;
            } else {
                return this;
            }
        }
        if (((OETreeNode)object).isIntrospectable() && ((Introspectable)object).isConnected()) {
            boolean bl5 = ((Introspectable)object).isNonSticky();
            this.setForeground(bl5 ? this.getConnectedColor() : this.getConnectedColorSticky());
            this.setFont(new Font("dialog", 1, 12));
            this.setBackgroundSelectionColor(this.getConnectedBackColor());
        } else if (bl) {
            this.setForeground(this.getTextSelectionColor());
            this.setFont(new Font("dialog", 0, 12));
            this.setBackgroundSelectionColor(this.selectedBackColor);
            string = string + " ";
        } else {
            this.setFont(new Font("dialog", 0, 12));
            this.setForeground(this.getTextNonSelectionColor());
            string = string + " ";
        }
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            if (bl3) {
                this.setDisabledIcon(this.getOpenIcon());
            } else if (bl2) {
                this.setDisabledIcon(this.getLeafIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (object instanceof OETreeNode && ((OETreeNode)object).getIcon() != null) {
                this.setIcon(((OETreeNode)object).getIcon());
            } else if (bl3) {
                this.setIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
        if (object instanceof Invocation) {
            this.setText(string + "[" + ((Invocation)object).getInvocationRequest().getSN() + "]");
        } else {
            this.setText(string);
        }
        this.setSize(this.getHeight(), jTree.getWidth());
        this.selected = bl;
        return this;
    }
}

