/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer;

import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import si.ijs.acs.objectexplorer.CallMethodDialog;
import si.ijs.acs.objectexplorer.ListsSimpleIntrospectableDetails;
import si.ijs.acs.objectexplorer.NodeRequestListener;
import si.ijs.acs.objectexplorer.NotificationBean;
import si.ijs.acs.objectexplorer.OERemoteResponseCallback;
import si.ijs.acs.objectexplorer.OETreeNode;
import si.ijs.acs.objectexplorer.ObjectDetailsHandler;
import si.ijs.acs.objectexplorer.OperationInvocator;
import si.ijs.acs.objectexplorer.RemoteResponseCallbackListener;
import si.ijs.acs.objectexplorer.ReporterBean;
import si.ijs.acs.objectexplorer.engine.Attribute;
import si.ijs.acs.objectexplorer.engine.Introspectable;
import si.ijs.acs.objectexplorer.engine.Invocation;
import si.ijs.acs.objectexplorer.engine.Operation;
import si.ijs.acs.objectexplorer.engine.RemoteResponse;
import si.ijs.acs.objectexplorer.engine.SimpleIntrospectable;

public class ListsHandlerBean
implements OperationInvocator,
ObjectDetailsHandler,
RemoteResponseCallbackListener {
    NotificationBean notifier = null;
    NodeRequestListener nodeRequestListener = null;
    ReporterBean reporter = null;
    Attribute[] cacheAttributes = null;
    Operation[] cacheOperations = null;
    SimpleIntrospectable currentNode = null;
    boolean showSpecial = true;
    boolean isSearching = false;
    private ListsSimpleIntrospectableDetails panel = null;

    synchronized void clickedItem(Object object) {
        if (object == null) {
            return;
        }
        try {
            if (object instanceof Operation) {
                Operation operation = (Operation)object;
                this.notifier.reportDebug("ListsHandlerBean::clickItem", "Operation '" + operation + "' clicked.");
                boolean[] blArray = operation.getMask();
                boolean bl = false;
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    bl = true;
                }
                if (bl) {
                    CallMethodDialog callMethodDialog = new CallMethodDialog(operation, (JFrame)this.panel.getTopLevelAncestor(), true, this.notifier, this);
                    callMethodDialog.show();
                } else {
                    this.invokeOperation(operation, new Object[blArray.length]);
                }
            } else if (object instanceof Attribute) {
                Attribute attribute = (Attribute)object;
                this.notifier.reportDebug("ListsHandlerBean::clickItem", "Attribute '" + attribute + "' accessor clicked.");
                if (attribute.isReadOnly()) {
                    this.invokeOperation(attribute, null);
                } else {
                    this.notifier.reportMessage("Read only attributes supported only");
                    this.invokeOperation(attribute, null);
                }
            }
        }
        catch (Exception exception) {
            this.handleException("ListsHandler clickItem", exception);
        }
    }

    @Override
    public JPanel getEditorPanel() {
        if (this.panel == null) {
            this.panel = new ListsSimpleIntrospectableDetails(this);
        }
        return this.panel;
    }

    private void handleException(String string, Throwable throwable) {
        this.notifier.reportError(string, throwable);
    }

    @Override
    public void invocationDestroyed(Invocation invocation) {
        if (invocation == null) {
            return;
        }
        if (invocation.isDestroyed()) {
            return;
        }
        this.notifier.reportDebug("ListsHandlerBean::invocationDestroyed", "I:" + invocation);
        this.nodeRequestListener.removeNode(invocation);
        this.reporter.invocationDestroyed(invocation);
        invocation.destroy();
    }

    private void invokeOperation(Object object, Object[] objectArray) {
        try {
            new OperationAcquiry(this, this.reporter, object, objectArray).start();
        }
        catch (Exception exception) {
            this.handleException("ListsHandler invokeOperation", exception);
        }
    }

    @Override
    public void invokeOperation(Operation operation, Object[] objectArray) {
        this.invokeOperation((Object)operation, objectArray);
    }

    @Override
    public void responseReceived(RemoteResponse remoteResponse) {
        this.reporter.reportRemoteResponse(remoteResponse);
    }

    private void selectionChange(SimpleIntrospectable simpleIntrospectable) {
        try {
            if (this.currentNode != simpleIntrospectable && !this.isSearching) {
                this.currentNode = simpleIntrospectable;
                this.panel.clear();
                this.panel.setDeviceText(simpleIntrospectable.getName());
                this.isSearching = true;
                new MembersSearching(this, simpleIntrospectable).start();
            }
            return;
        }
        catch (Exception exception) {
            this.handleException("ListHandlerBean::selectionChange " + simpleIntrospectable + " ", exception);
            this.isSearching = false;
            return;
        }
    }

    @Override
    public void setNodeRequestListener(NodeRequestListener nodeRequestListener) {
        this.nodeRequestListener = nodeRequestListener;
    }

    @Override
    public void setNotifier(NotificationBean notificationBean) {
        this.notifier = notificationBean;
    }

    @Override
    public void setObject(SimpleIntrospectable simpleIntrospectable) {
        if (simpleIntrospectable == null) {
            this.currentNode = null;
            this.panel.clear();
        } else {
            this.selectionChange(simpleIntrospectable);
        }
    }

    @Override
    public void setReporter(ReporterBean reporterBean) {
        this.reporter = reporterBean;
    }

    void setSpecial(boolean bl) {
        if (this.showSpecial == !bl) {
            this.showSpecial = bl;
            this.updateLists();
        }
    }

    private void updateLists() {
        int n;
        DefaultListModel<Object> defaultListModel;
        this.isSearching = false;
        if (this.cacheAttributes != null) {
            defaultListModel = new DefaultListModel<Object>();
            for (n = 0; n < this.cacheAttributes.length; ++n) {
                defaultListModel.addElement(this.cacheAttributes[n]);
            }
            this.panel.setAttributesModel(defaultListModel);
        }
        if (this.cacheOperations != null) {
            defaultListModel = new DefaultListModel();
            for (n = 0; n < this.cacheOperations.length; ++n) {
                if (this.cacheOperations[n].isSpecial() && !this.showSpecial) continue;
                defaultListModel.addElement(this.cacheOperations[n]);
            }
            this.panel.setOperationsModel(defaultListModel);
        }
    }

    private void updateLists(Attribute[] attributeArray, Operation[] operationArray) {
        this.isSearching = false;
        this.cacheAttributes = attributeArray;
        this.cacheOperations = operationArray;
        this.updateLists();
    }

    private class MembersSearching
    extends Thread {
        private ListsHandlerBean parent = null;
        private SimpleIntrospectable node = null;

        private MembersSearching(ListsHandlerBean listsHandlerBean2, SimpleIntrospectable simpleIntrospectable) {
            this.parent = listsHandlerBean2;
            this.node = simpleIntrospectable;
        }

        @Override
        public void run() {
            try {
                if (this.node instanceof Introspectable) {
                    ((Introspectable)this.node).connect();
                }
                Attribute[] attributeArray = this.node.getAttributes();
                Operation[] operationArray = this.node.getOperations();
                this.parent.updateLists(attributeArray, operationArray);
            }
            catch (Exception exception) {
                this.parent.isSearching = false;
                ListsHandlerBean.this.notifier.reportError("Members Searching::run", exception);
            }
        }
    }

    private class OperationAcquiry
    extends Thread {
        private ListsHandlerBean parent = null;
        private ReporterBean reporter = null;
        private NotificationBean notifier = null;
        private Object[] params = null;
        private Object ob = null;

        private OperationAcquiry(ListsHandlerBean listsHandlerBean2, ReporterBean reporterBean, Object object, Object[] objectArray) {
            this.parent = listsHandlerBean2;
            this.reporter = reporterBean;
            this.notifier = this.parent.notifier;
            this.params = objectArray;
            this.ob = object;
        }

        @Override
        public void run() {
            try {
                if (this.ob instanceof Operation) {
                    Operation operation = (Operation)this.ob;
                    if (operation.isInvocation()) {
                        this.notifier.reportDebug("OperationAcquiry::run", "Invocation " + operation);
                        OERemoteResponseCallback oERemoteResponseCallback = new OERemoteResponseCallback(this.parent, ReporterBean.raID);
                        Invocation invocation = operation.invokeAsync(this.params, oERemoteResponseCallback);
                        if (invocation != null) {
                            oERemoteResponseCallback.setInvocation(invocation);
                            this.reporter.reportRemoteCall(invocation.getInvocationRequest());
                            if (operation.getIntrospectable() instanceof OETreeNode && invocation.isControllable()) {
                                OETreeNode oETreeNode = (OETreeNode)((Object)operation.getIntrospectable());
                                this.parent.nodeRequestListener.addNode(invocation, oETreeNode);
                            }
                        }
                    } else {
                        this.notifier.reportDebug("OperationAcquiry::run", "Operation " + operation + " invoked");
                        this.reporter.reportRemoteCall(operation.invoke(this.params));
                    }
                } else if (this.ob instanceof Attribute) {
                    Attribute attribute = (Attribute)this.ob;
                    this.notifier.reportDebug("OperationAcquiry::run", "Attribute " + attribute + " invoked");
                    this.reporter.reportRemoteCall(attribute.invokeAccessor());
                }
            }
            catch (Exception exception) {
                this.notifier.reportError("Operation Aquiry::run", exception);
            }
        }
    }
}

