/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

public class ANYDATA
implements ORAData {
    static final byte KAD_VSN = 1;
    static final byte KAD_VSN2 = 2;
    boolean isNull;
    byte[] data;
    TypeDescriptor type;
    boolean isREF = false;
    short serverCharsetId = 0;
    short serverNCharsetId = 0;
    OracleConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:35:54_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    ANYDATA(TypeDescriptor typeDescriptor, boolean bl, byte[] byArray, boolean bl2) {
        this.type = typeDescriptor;
        this.isNull = bl;
        this.data = byArray;
        this.isREF = bl2;
    }

    public ANYDATA(OPAQUE oPAQUE) throws SQLException {
        byte[] byArray = oPAQUE.getBytesValue();
        this.connection = oPAQUE.getPhysicalConnection();
        if (this.connection != null) {
            this.serverCharsetId = this.connection.getDbCsId();
            this.serverNCharsetId = this.connection.getNCharSet();
        }
        this.unpickle(byArray, 0);
    }

    int unpickle(byte[] byArray, int n2) throws SQLException {
        int n3;
        PickleContext pickleContext = new PickleContext(byArray, n2);
        byte by = pickleContext.readByte();
        if (by == 2) {
            pickleContext.skipBytes(4);
        }
        short[] sArray = new short[1];
        this.type = TypeDescriptor.unpickleOpaqueTypeImage(pickleContext, this.connection, sArray);
        this.isNull = pickleContext.readByte() != 0;
        if (!this.isNull) {
            n3 = (int)pickleContext.readUB4();
            this.data = pickleContext.readDataValue(n3);
        }
        this.isREF = sArray[0] == 110;
        n3 = pickleContext.offset();
        return n3;
    }

    int pickle(byte[] byArray, int n2) {
        byArray[n2++] = 1;
        n2 = this.type.pickleOpaqueTypeImage(byArray, n2, this.isREF);
        byArray[n2++] = this.isNull ? (byte)1 : 0;
        if (!this.isNull) {
            int n3 = this.data.length;
            byArray[n2++] = (byte)((n3 & 0xFF000000) >> 24 & 0xFF);
            byArray[n2++] = (byte)((n3 & 0xFF0000) >> 16 & 0xFF);
            byArray[n2++] = (byte)((n3 & 0xFF00) >> 8 & 0xFF);
            byArray[n2++] = (byte)(n3 & 0xFF);
            System.arraycopy(this.data, 0, byArray, n2, n3);
        }
        return n2;
    }

    int getImageSize() {
        int n2 = this.type.getOpaqueImageTypeSize() + 1 + 1;
        if (!this.isNull) {
            n2 += 4 + this.data.length;
        }
        return n2;
    }

    public Datum toDatum(Connection connection) throws SQLException {
        this.connection = (OracleConnection)connection;
        OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", connection);
        byte[] byArray = new byte[this.getImageSize()];
        this.pickle(byArray, 0);
        OPAQUE oPAQUE = new OPAQUE(opaqueDescriptor, this.connection, byArray);
        oPAQUE.setShareBytes(oPAQUE.toBytes());
        return oPAQUE;
    }

    public static ANYDATA convertDatum(Datum datum) throws SQLException {
        ANYDATA aNYDATA = null;
        if (datum instanceof STRUCT) {
            aNYDATA = new ANYDATA(((STRUCT)datum).getDescriptor(), false, ((STRUCT)datum).toBytes(), false);
        } else if (datum instanceof ARRAY) {
            aNYDATA = new ANYDATA(((ARRAY)datum).getDescriptor(), false, ((ARRAY)datum).toBytes(), false);
        } else if (datum instanceof REF) {
            aNYDATA = new ANYDATA(((REF)datum).getDescriptor(), false, ((REF)datum).getBytes(), true);
        } else if (datum instanceof OPAQUE) {
            aNYDATA = new ANYDATA(((OPAQUE)datum).getDescriptor(), false, ((OPAQUE)datum).toBytes(), false);
        } else {
            TypeDescriptor typeDescriptor = null;
            if (datum instanceof NUMBER) {
                typeDescriptor = new TypeDescriptor(2);
            } else if (datum instanceof DATE) {
                typeDescriptor = new TypeDescriptor(12);
            } else if (datum instanceof INTERVALDS) {
                typeDescriptor = new TypeDescriptor(190);
            } else if (datum instanceof INTERVALYM) {
                typeDescriptor = new TypeDescriptor(189);
            } else if (datum instanceof TIMESTAMPTZ) {
                typeDescriptor = new TypeDescriptor(188);
            } else if (datum instanceof TIMESTAMPLTZ) {
                typeDescriptor = new TypeDescriptor(232);
            } else if (datum instanceof TIMESTAMP) {
                typeDescriptor = new TypeDescriptor(187);
            } else if (datum instanceof NCLOB) {
                typeDescriptor = new TypeDescriptor(288);
            } else if (datum instanceof CLOB) {
                typeDescriptor = new TypeDescriptor(112);
            } else if (datum instanceof BLOB) {
                typeDescriptor = new TypeDescriptor(113);
            } else if (datum instanceof BFILE) {
                typeDescriptor = new TypeDescriptor(114);
            } else if (datum instanceof RAW) {
                typeDescriptor = new TypeDescriptor(95);
            } else if (datum instanceof BINARY_DOUBLE) {
                typeDescriptor = new TypeDescriptor(101);
            } else if (datum instanceof BINARY_FLOAT) {
                typeDescriptor = new TypeDescriptor(100);
            } else if (datum instanceof ROWID) {
                typeDescriptor = new TypeDescriptor(104);
            } else if (datum instanceof CHAR) {
                typeDescriptor = new TypeDescriptor(96);
            }
            if (datum instanceof ROWID) {
                byte[] byArray = datum.shareBytes();
                long[] lArray = InternalFactory.rowid2urowid(byArray, 0, byArray.length);
                byte[] byArray2 = new byte[]{1, (byte)((lArray[0] & 0xFFFFFFFFFF000000L) >> 24), (byte)((lArray[0] & 0xFF0000L) >> 16), (byte)((lArray[0] & 0xFF00L) >> 8), (byte)(lArray[0] & 0xFFL), (byte)((lArray[1] & 0xFF00L) >> 8), (byte)(lArray[1] & 0xFFL), (byte)((lArray[2] & 0xFFFFFFFFFF000000L) >> 24), (byte)((lArray[2] & 0xFF0000L) >> 16), (byte)((lArray[2] & 0xFF00L) >> 8), (byte)(lArray[2] & 0xFFL), (byte)((lArray[3] & 0xFF00L) >> 8), (byte)(lArray[3] & 0xFFL)};
                aNYDATA = new ANYDATA(typeDescriptor, false, byArray2, false);
            } else {
                aNYDATA = new ANYDATA(typeDescriptor, false, datum.shareBytes(), false);
            }
        }
        if (datum instanceof DatumWithConnection) {
            aNYDATA.connection = ((DatumWithConnection)datum).getInternalConnection();
        }
        return aNYDATA;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.type;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isREF() {
        return this.isREF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValue() throws SQLException {
        String string = null;
        string = "ANYDATA TypeCode: \"" + this.getTypeDescriptor().getTypeCodeName();
        if (this.isREF) {
            string = string + "(REF)";
        }
        string = string + "\" - ANYDATA Value: \"";
        Datum datum = this.accessDatum();
        try {
            string = string + datum.stringValue();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!(this.type.getInternalTypeCode() != 108 && this.type.getInternalTypeCode() != 110 || this.type.isTransient())) {
            string = string + ((StructDescriptor)this.type).getName() + "(...)";
        } else if (this.type.getInternalTypeCode() == 122 && !this.type.isTransient()) {
            string = string + ((ArrayDescriptor)this.type).getName() + "(...)";
        } else if (this.type.getInternalTypeCode() == 112 || this.type.getInternalTypeCode() == 288) {
            Reader reader = ((CLOB)datum).getCharacterStream();
            try {
                int n2;
                String string2 = "";
                while ((n2 = reader.read()) != -1) {
                    string2 = string2 + (char)n2;
                }
                string = string + string2;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        } else if (this.type.getInternalTypeCode() == 113) {
            InputStream inputStream = ((BLOB)datum).getBinaryStream();
            try {
                int n3;
                String string3 = "";
                while ((n3 = inputStream.read()) != -1) {
                    string3 = string3 + Integer.toHexString(n3);
                }
                string = string + string3;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        } else if (this.type.getInternalTypeCode() == 188) {
            string = string + ((TIMESTAMPTZ)datum).stringValue(this.connection);
        } else if (this.type.getInternalTypeCode() == 232) {
            string = this.connection == null ? string + "?" : string + ((TIMESTAMPLTZ)datum).stringValue(this.connection);
        } else if (this.type.getInternalTypeCode() == 114) {
            string = string + "bfile_dir=" + ((BFILE)datum).getDirAlias() + " bfile_name=" + ((BFILE)datum).getName();
        }
        string = string + "\"";
        return string;
    }

    public Datum accessDatum() throws SQLException {
        Datum datum = null;
        if (!this.isNull) {
            short s2 = this.type.getInternalTypeCode();
            switch (s2) {
                case 58: {
                    datum = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
                    break;
                }
                case 108: {
                    if (this.type instanceof OpaqueDescriptor) {
                        datum = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
                        break;
                    }
                    if (!this.isREF) {
                        datum = new STRUCT((StructDescriptor)this.type, this.data, this.connection);
                        break;
                    }
                    datum = new REF((StructDescriptor)this.type, (Connection)this.connection, this.data);
                    break;
                }
                case 122: {
                    datum = new ARRAY((ArrayDescriptor)this.type, this.data, this.connection);
                    break;
                }
                case 110: {
                    datum = new REF((StructDescriptor)this.type, (Connection)this.connection, this.data);
                    break;
                }
                case 2: {
                    datum = new NUMBER(this.data);
                    break;
                }
                case 12: {
                    datum = new DATE(this.data);
                    break;
                }
                case 190: {
                    datum = new INTERVALDS(this.data);
                    break;
                }
                case 189: {
                    datum = new INTERVALYM(this.data);
                    break;
                }
                case 188: {
                    datum = new TIMESTAMPTZ(this.data);
                    break;
                }
                case 232: {
                    datum = new TIMESTAMPLTZ(this.data);
                    break;
                }
                case 187: {
                    datum = new TIMESTAMP(this.data);
                    break;
                }
                case 112: {
                    datum = new CLOB(this.connection, this.data);
                    break;
                }
                case 288: {
                    datum = new NCLOB(this.connection, this.data);
                    break;
                }
                case 113: {
                    datum = new BLOB(this.connection, this.data);
                    break;
                }
                case 114: {
                    datum = new BFILE(this.connection, this.data);
                    break;
                }
                case 95: {
                    datum = new RAW(this.data);
                    break;
                }
                case 101: {
                    datum = new BINARY_DOUBLE(this.data);
                    break;
                }
                case 100: {
                    datum = new BINARY_FLOAT(this.data);
                    break;
                }
                case 104: {
                    long l2 = ((long)this.data[1] & 0xFFL) << 24 | ((long)this.data[2] & 0xFFL) << 16 | ((long)this.data[3] & 0xFFL) << 8 | (long)this.data[4] & 0xFFL;
                    long l3 = ((long)this.data[5] & 0xFFL) << 8 | (long)this.data[6] & 0xFFL;
                    long l4 = ((long)this.data[7] & 0xFFL) << 24 | ((long)this.data[8] & 0xFFL) << 16 | ((long)this.data[9] & 0xFFL) << 8 | (long)this.data[10] & 0xFFL;
                    long l5 = ((long)this.data[11] & 0xFFL) << 8 | (long)this.data[12] & 0xFFL;
                    long[] lArray = new long[]{l2, l3, l4, l5};
                    byte[] byArray = InternalFactory.urowid2rowid(lArray);
                    datum = new ROWID(byArray);
                    break;
                }
                case 1: 
                case 9: 
                case 96: {
                    if (this.serverCharsetId != 0) {
                        datum = new CHAR(this.data, CharacterSet.make(this.serverCharsetId));
                        break;
                    }
                    datum = new CHAR(this.data, null);
                    break;
                }
                case 286: 
                case 287: {
                    if (this.serverNCharsetId != 0) {
                        datum = new CHAR(this.data, CharacterSet.make(this.serverNCharsetId));
                        break;
                    }
                    datum = new CHAR(this.data, null);
                    break;
                }
                default: {
                    String string = "internal typecode: " + s2;
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, string);
                }
            }
        }
        return datum;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

