/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.loader;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityExistsException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.Permissions;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class TestDataLoader {
    private InternalIF internal;
    private SchemaManager smanager;

    public TestDataLoader() {
        try {
            this.internal = InternalIFFactory.getInternalIF((Logger)Logger.getAnonymousLogger());
            this.smanager = this.internal.getSchemaManager("user");
        }
        catch (ArchiveException archiveException) {
            archiveException.printStackTrace();
        }
        catch (ModuleCriticalException moduleCriticalException) {
            moduleCriticalException.printStackTrace();
        }
    }

    private File[] fileList(String string, String string2) {
        SuffixFilter suffixFilter = new SuffixFilter(string2);
        File file = new File(string);
        return file.listFiles(suffixFilter);
    }

    private File[] dirList(String string) {
        DirFilter dirFilter = new DirFilter(this.smanager);
        File file = new File(string);
        return file.listFiles(dirFilter);
    }

    private void store(File file, String string) {
        String string2 = file.getName();
        String string3 = string2.substring(0, string2.indexOf("."));
        string3 = string3.replaceAll("uid", "uid:/");
        string3 = string3.replaceAll("X", "/X");
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build((Reader)new FileReader(file));
            XMLOutputter xMLOutputter = new XMLOutputter(Format.getRawFormat());
            String string4 = xMLOutputter.outputString(document);
            URI uRI = new URI(string3);
            URI uRI2 = this.smanager.getSchemaURI(string);
            try {
                System.out.println("Storing: " + uRI.toASCIIString() + " under: " + string);
                this.internal.store(uRI, string4, uRI2, string, "owner", new Permissions(), "user", true);
            }
            catch (EntityExistsException entityExistsException) {
                DocumentData documentData = this.internal.status(uRI, "user");
                this.internal.update(uRI, documentData.getTimestamp(), string4, uRI2, false, "user");
            }
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        catch (ArchiveException archiveException) {
            archiveException.printStackTrace();
        }
        catch (ModuleCriticalException moduleCriticalException) {
            moduleCriticalException.printStackTrace();
        }
    }

    public void load(String string) {
        System.out.println("Loading from path: " + string);
        File[] fileArray = this.fileList(string, "xml");
        for (int i = 0; i < fileArray.length; ++i) {
            this.store(fileArray[i], "SchedBlock");
        }
        File[] fileArray2 = this.dirList(string);
        for (int i = 0; i < fileArray2.length; ++i) {
            fileArray = this.fileList(fileArray2[i].getAbsolutePath(), "xml");
            for (int j = 0; j < fileArray.length; ++j) {
                this.store(fileArray[j], fileArray2[i].getName());
            }
        }
    }

    public void close() throws DatabaseException, ModuleCriticalException {
        this.smanager.close();
        this.internal.close();
    }

    public static void main(String[] stringArray) throws DatabaseException, ModuleCriticalException {
        TestDataLoader testDataLoader = new TestDataLoader();
        testDataLoader.load(stringArray[0] + " " + stringArray[1]);
        testDataLoader.close();
    }

    private class DirFilter
    implements FileFilter {
        private SchemaManager sm;

        public DirFilter(SchemaManager schemaManager) {
            this.sm = schemaManager;
        }

        @Override
        public boolean accept(File file) {
            try {
                if (file.isDirectory()) {
                    this.sm.getSchemaURI(file.getName());
                    return true;
                }
                return false;
            }
            catch (UnknownSchemaException unknownSchemaException) {
                return false;
            }
            catch (ArchiveException archiveException) {
                return false;
            }
            catch (ModuleCriticalException moduleCriticalException) {
                return false;
            }
        }
    }

    private class SuffixFilter
    implements FileFilter {
        private String suffix;

        public SuffixFilter(String string) {
            this.suffix = string;
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            return string.endsWith(this.suffix);
        }
    }
}

