/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.commands;

import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.ResultStruct;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom.Content;
import org.jdom.Element;

public class EntityList {
    private InternalIF internalif = null;
    private SchemaManager smanager = null;
    private Element entityList;
    private Hashtable entityTable;
    private Hashtable xmlTable;
    private String m_XPath = null;
    private String m_schema = null;
    private URI m_uri = null;

    public EntityList(InternalIF internalIF) throws DatabaseException, ModuleCriticalException {
        this.internalif = internalIF;
        this.entityList = new Element("EntityList");
        this.entityTable = new Hashtable();
        this.xmlTable = new Hashtable();
    }

    private void addEntity(URI uRI, String string, String string2) {
        Element element = this.getEntityElment(uRI, string);
        if (element != null && !this.entityTable.containsKey(uRI)) {
            this.entityList.addContent((Content)element);
            this.entityTable.put(uRI, string);
            this.xmlTable.put(uRI, string2);
        }
    }

    public void queryURI(URI uRI) {
        this.m_uri = uRI;
        this.m_XPath = null;
        this.m_schema = null;
        this.removeAll();
        this.addEntity(uRI, "", "");
    }

    public void queryXPath(String string, String string2) throws ArchiveException, ModuleCriticalException {
        this.removeAll();
        this.m_XPath = string;
        this.m_schema = string2;
        this.m_uri = null;
        this.smanager = this.internalif.getSchemaManager("browser");
        URI uRI = this.smanager.getSchemaURI(string2);
        HashMap hashMap = this.smanager.getSchemaNamespaces(uRI);
        this.smanager.close();
        DBCursor dBCursor = this.internalif.query(string, string2, hashMap, false, "browser");
        while (dBCursor.hasNext()) {
            ResultStruct resultStruct = dBCursor.next();
            this.addEntity(resultStruct.getUri(), string, resultStruct.getXml());
        }
        dBCursor.close();
    }

    public void removeEntity(URI uRI) {
        List list = this.entityList.getChildren();
        if (list.size() != 0) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Element element = (Element)listIterator.next();
                String string = element.getAttributeValue("URI");
                if (string != null) {
                    if (!string.equalsIgnoreCase(uRI.toASCIIString())) continue;
                    listIterator.remove();
                    this.entityTable.remove(uRI);
                    this.xmlTable.remove(uRI);
                    continue;
                }
                listIterator.remove();
            }
        }
    }

    public void refresh() throws ArchiveException, ModuleCriticalException {
        this.removeAll();
        if (this.m_XPath != null) {
            this.queryXPath(this.m_XPath, this.m_schema);
        }
        if (this.m_uri != null) {
            this.queryURI(this.m_uri);
        }
    }

    public void removeAll() {
        this.clearElements();
        this.entityTable.clear();
        this.xmlTable.clear();
    }

    private void clearElements() {
        List list = this.entityList.getChildren();
        if (list.size() != 0) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Element element = (Element)listIterator.next();
                listIterator.remove();
            }
        }
    }

    private Element getEntityElment(URI uRI, String string) {
        Element element = new Element("entity");
        try {
            DocumentData[] documentDataArray = this.internalif.allStatus(uRI, "browser");
            element.setAttribute("URI", uRI.toASCIIString());
            element.setAttribute("path", string);
            for (int i = 0; i < documentDataArray.length; ++i) {
                Element element2 = documentDataArray[i].getElement();
                element.addContent((Content)element2);
            }
            return element;
        }
        catch (EntityDoesNotExistException entityDoesNotExistException) {
            return null;
        }
        catch (ArchiveException archiveException) {
            return null;
        }
        catch (ModuleCriticalException moduleCriticalException) {
            return null;
        }
    }

    public Element getElement() {
        return this.entityList;
    }

    public Hashtable getElementTable() {
        return this.entityTable;
    }

    public void WriteOutputStream(OutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        Enumeration enumeration = this.xmlTable.keys();
        while (enumeration.hasMoreElements()) {
            URI uRI = (URI)enumeration.nextElement();
            String string = (String)this.xmlTable.get(uRI);
            byte[] byArray = string.getBytes();
            String string2 = uRI.toASCIIString();
            string2 = string2.replaceAll("uid:", "");
            string2 = string2.replaceAll("/", "");
            zipOutputStream.setMethod(8);
            zipOutputStream.setLevel(0);
            zipOutputStream.putNextEntry(new ZipEntry(uRI.toASCIIString()));
            zipOutputStream.write(byArray, 0, byArray.length);
            zipOutputStream.closeEntry();
        }
        outputStream.flush();
    }
}

