/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.browser;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.DocumentData;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GetStatus
extends HttpServlet {
    private Templates ddTemplate;
    private InternalIF internalif = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ArchiveTimeStamp archiveTimeStamp;
        String string = httpServletRequest.getParameter("uri");
        String string2 = httpServletRequest.getParameter("timeStamp");
        String string3 = httpServletRequest.getParameter("format");
        String string4 = httpServletRequest.getParameter("action");
        String string5 = httpServletRequest.getParameter("parameter");
        if (string == null || string2 == null) throw new UnavailableException("There is a problem with the uri or timeStamp");
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UnavailableException("The URI was invalid");
        }
        try {
            archiveTimeStamp = new ArchiveTimeStamp(string2);
        }
        catch (Exception exception) {
            throw new UnavailableException("Invalid timestamp: " + string2);
        }
        try {
            DocumentData documentData = this.internalif.status(uRI, archiveTimeStamp, "browser");
            if (string4 != null) {
                if (string4.equalsIgnoreCase("change")) {
                    if (string5.equalsIgnoreCase("hidden")) {
                        if (documentData.getHidden()) {
                            this.internalif.visible(uRI, "browser");
                        } else {
                            this.internalif.hidden(uRI, "browser");
                        }
                    } else if (string5.equalsIgnoreCase("dirty")) {
                        if (documentData.getDirty()) {
                            this.internalif.clean(uRI, "browser");
                        } else {
                            this.internalif.dirty(uRI, "browser");
                        }
                    } else if (string5.equalsIgnoreCase("deleted")) {
                        if (documentData.getDeleted()) {
                            this.internalif.undelete(uRI, "browser");
                        } else {
                            this.internalif.delete(uRI, "browser");
                        }
                    }
                }
                documentData = this.internalif.status(uRI, archiveTimeStamp, "browser");
            }
            Element element = documentData.getElement();
            if (string3.equalsIgnoreCase("xml")) {
                this.showXmlPage(element, httpServletResponse);
                return;
            } else {
                if (!string3.equalsIgnoreCase("html")) return;
                this.showHtmlPage(element, uRI, this.ddTemplate, httpServletResponse);
            }
            return;
        }
        catch (ArchiveException archiveException) {
            throw new UnavailableException(archiveException.getMessage());
        }
        catch (ModuleCriticalException moduleCriticalException) {
            throw new UnavailableException(moduleCriticalException.getMessage());
        }
    }

    private void showHtmlPage(Element element, URI uRI, Templates templates, HttpServletResponse httpServletResponse) throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        String string = xMLOutputter.outputString(element);
        StreamSource streamSource = new StreamSource(new StringReader(string));
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/html");
        try {
            Transformer transformer = templates.newTransformer();
            transformer.setParameter("uri", uRI.toASCIIString());
            transformer.transform(streamSource, new StreamResult(printWriter));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
    }

    private void showXmlPage(Element element, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        printWriter.print(xMLOutputter.outputString(element));
    }

    public void init() throws ServletException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        String string = null;
        try {
            string = "/WEB-INF/xslt/DocumentData.xslt";
            URL uRL = this.getServletContext().getResource(string);
            if (uRL == null) {
                throw new MalformedURLException();
            }
            String string2 = uRL.toExternalForm();
            this.ddTemplate = transformerFactory.newTemplates(new StreamSource(string2));
            try {
                this.internalif = InternalIFFactory.getInternalIF((Logger)Logger.getAnonymousLogger());
                this.internalif.init();
            }
            catch (DatabaseException databaseException) {
                throw new ServletException(databaseException.getMessage());
            }
            catch (ModuleCriticalException moduleCriticalException) {
                throw new ServletException(moduleCriticalException.getMessage());
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.log("Unable to compile stylesheet", transformerConfigurationException);
            throw new UnavailableException("Unable to compile stylesheet");
        }
        catch (MalformedURLException malformedURLException) {
            this.log("Unable to locate XSLT file: " + string);
            throw new UnavailableException("Unable to locate XSLT file: " + string);
        }
    }

    public void destroy() {
        try {
            this.internalif.close();
        }
        catch (DatabaseException databaseException) {
            this.log("Problems closong the internal interface", databaseException);
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.log("Problems closong the internal interface", moduleCriticalException);
        }
        super.destroy();
    }
}

